/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.server;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.jboss.galleon.ProvisioningException;

public class ClassLoaderHelper {
    public static void close(URLClassLoader newCl) {
        if (newCl != null) {
            try {
                newCl.close();
            }
            catch (IOException ioex) {
                throw new IllegalStateException("Couldn't stop server because of " + ioex.getMessage(), ioex);
            }
        }
    }

    public static URLClassLoader prepareClassLoader(Path jbossHome, ClassLoader originalCl, URL ... urls) {
        ArrayList<URL> cp = new ArrayList<URL>();
        try {
            cp.addAll(Arrays.asList(urls));
            ClassLoaderHelper.addJars(jbossHome, cp);
            if (!(originalCl instanceof URLClassLoader)) {
                throw new IllegalArgumentException("Expected a URLClassLoader");
            }
            cp.addAll(Arrays.asList(((URLClassLoader)originalCl).getURLs()));
            return new URLClassLoader(cp.toArray(new URL[cp.size()]), null);
        }
        catch (IOException ioex) {
            throw new IllegalStateException("Couldn't load jars", ioex);
        }
    }

    public static URLClassLoader prepareProvisioningClassLoader(Path jbossHome, ClassLoader originalCl, URL ... urls) {
        ArrayList<URL> cp = new ArrayList<URL>();
        try {
            cp.addAll(Arrays.asList(urls));
            ClassLoaderHelper.addJars(jbossHome, cp);
            if (!(originalCl instanceof URLClassLoader)) {
                throw new IllegalArgumentException("Expected a URLClassLoader");
            }
            cp.addAll(Arrays.asList(((URLClassLoader)originalCl).getURLs()));
            return new URLClassLoader(cp.toArray(new URL[cp.size()]), ProvisioningException.class.getClassLoader());
        }
        catch (IOException ioex) {
            throw new IllegalStateException("Couldn't load jars", ioex);
        }
    }

    private static List<URL> addJars(Path dir, final List<URL> urls) throws IOException {
        Files.walkFileTree(dir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!file.getFileName().toString().endsWith(".jar")) {
                    return FileVisitResult.CONTINUE;
                }
                urls.add(file.toUri().toURL());
                return FileVisitResult.CONTINUE;
            }
        });
        return urls;
    }
}

