/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.ProvisioningRuntime;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.universe.maven.MavenUniverseException;
import org.wildfly.galleon.plugin.AbstractEE9ArtifactInstaller;
import org.wildfly.galleon.plugin.WfInstallPlugin;
import org.wildfly.galleon.plugin.transformer.JakartaTransformer;

class EE9ArtifactInstaller
extends AbstractEE9ArtifactInstaller {
    private final Path provisioningMavenRepo;

    EE9ArtifactInstaller(WfInstallPlugin.ArtifactResolver resolver, Path generatedMavenRepo, Set<String> transformExcluded, WfInstallPlugin plugin, String jakartaTransformSuffix, Path jakartaTransformConfigsDir, JakartaTransformer.LogHandler logHandler, boolean jakartaTransformVerbose, ProvisioningRuntime runtime, Path provisioningMavenRepo) {
        super(resolver, generatedMavenRepo, transformExcluded, plugin, jakartaTransformSuffix, jakartaTransformConfigsDir, logHandler, jakartaTransformVerbose, runtime);
        this.provisioningMavenRepo = provisioningMavenRepo;
    }

    boolean isOverriddenTransformed(MavenArtifact artifact) throws IOException {
        String transformedVersion = this.getTransformedVersion(artifact.getVersion());
        Path transformedPath = EE9ArtifactInstaller.getLocalRepoPath(artifact, transformedVersion, this.provisioningMavenRepo, false);
        boolean transformed = false;
        if (Files.exists(transformedPath, new LinkOption[0])) {
            transformed = true;
        } else {
            Path notTransformedPath = EE9ArtifactInstaller.getLocalRepoPath(artifact, artifact.getVersion(), this.provisioningMavenRepo, false);
            if (Files.exists(notTransformedPath, new LinkOption[0])) {
                this.excludeFromTransformation(artifact);
            }
        }
        return transformed;
    }

    Path handleOverriddenTransformation(MavenArtifact artifact) throws IOException, ProvisioningException {
        boolean isTransformed = this.isOverriddenTransformed(artifact);
        Path path = artifact.getPath();
        if (!isTransformed && !this.isExcludedFromTransformation(artifact)) {
            Path pomFile = EE9ArtifactInstaller.getPomArtifactPath(artifact, this.getArtifactResolver());
            Path transformedFile = this.setupOverriddenArtifact(artifact);
            if (transformedFile == null) {
                Path notTransformedVersionPath = EE9ArtifactInstaller.getLocalRepoPath(artifact, artifact.getVersion(), this.provisioningMavenRepo);
                path = notTransformedVersionPath.resolve(artifact.getArtifactFileName());
                Files.copy(artifact.getPath(), path, StandardCopyOption.REPLACE_EXISTING);
                Files.copy(pomFile, notTransformedVersionPath.resolve(pomFile.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
            } else {
                String transformedVersion = this.getTransformedVersion(artifact.getVersion());
                Path transformedVersionPath = EE9ArtifactInstaller.getLocalRepoPath(artifact, transformedVersion, this.provisioningMavenRepo);
                path = transformedVersionPath.resolve(transformedFile.getFileName());
                Files.copy(transformedFile, path, StandardCopyOption.REPLACE_EXISTING);
                Files.copy(pomFile, transformedVersionPath.resolve(pomFile.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return path;
    }

    @Override
    String installArtifactFat(MavenArtifact artifact, Path targetDir, Path localCache) throws IOException, MavenUniverseException, ProvisioningException {
        Path path = artifact.getPath();
        if (this.isOverriddenArtifact(artifact)) {
            path = this.handleOverriddenTransformation(artifact);
        }
        Files.copy(path, targetDir.resolve(path.getFileName()), StandardCopyOption.REPLACE_EXISTING);
        return path.getFileName().toString();
    }

    @Override
    String installArtifactThin(MavenArtifact artifact) throws IOException, MavenUniverseException, ProvisioningException {
        String version = artifact.getVersion();
        if (this.isOverriddenArtifact(artifact)) {
            this.handleOverriddenTransformation(artifact);
        }
        if (!this.isExcludedFromTransformation(artifact)) {
            version = this.getTransformedVersion(artifact.getVersion());
        }
        return version;
    }

    @Override
    Path installCopiedArtifact(MavenArtifact artifact) throws IOException, ProvisioningException {
        Path path = artifact.getPath();
        if (this.isOverriddenArtifact(artifact)) {
            path = this.handleOverriddenTransformation(artifact);
        }
        return path;
    }
}

