/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.layout.FeaturePackLayout;
import org.jboss.galleon.layout.ProvisioningLayout;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.jboss.galleon.util.CollectionUtils;
import org.jboss.galleon.util.IoUtils;
import org.jboss.galleon.util.LayoutUtils;
import org.jboss.galleon.util.StringUtils;
import org.wildfly.galleon.plugin.config.CopyArtifact;

public class Utils {
    private static final String EXPRESSION_PREFIX = "${";
    private static final String EXPRESSION_SUFFIX = "}";
    private static final String EXPRESSION_ENV_VAR = "env.";
    private static final String EXPRESSION_DEFAULT_VALUE_SEPARATOR = ":";

    public static void readProperties(Path propsFile, Map<String, String> propsMap) throws ProvisioningException {
        try (BufferedReader reader = Files.newBufferedReader(propsFile);){
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).charAt(0) != '#' && !line.isEmpty()) {
                    int i = line.indexOf(61);
                    if (i < 0) {
                        throw new ProvisioningException("Failed to parse property " + line + " from " + propsFile);
                    }
                    propsMap.put(line.substring(0, i), line.substring(i + 1));
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readFile((Path)propsFile), (Throwable)e);
        }
    }

    public static Map<String, String> readProperties(Path propsFile) throws ProvisioningException {
        HashMap<String, String> propsMap = new HashMap<String, String>();
        Utils.readProperties(propsFile, propsMap);
        return propsMap;
    }

    public static boolean containsArtifact(Map<String, String> artifactsMap, MavenArtifact artifact) throws ProvisioningException {
        StringBuilder key = new StringBuilder();
        StringBuilder val = new StringBuilder();
        val.append(artifact.getGroupId()).append(EXPRESSION_DEFAULT_VALUE_SEPARATOR).append(artifact.getArtifactId()).append(EXPRESSION_DEFAULT_VALUE_SEPARATOR).append(artifact.getVersion()).append(EXPRESSION_DEFAULT_VALUE_SEPARATOR);
        key.append(artifact.getGroupId()).append(':').append(artifact.getArtifactId());
        if (artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            key.append("::").append(artifact.getClassifier());
            val.append(artifact.getClassifier());
        }
        val.append(EXPRESSION_DEFAULT_VALUE_SEPARATOR).append(artifact.getExtension());
        String value = artifactsMap.get(key.toString());
        return val.toString().equals(value);
    }

    public static MavenArtifact toArtifactCoords(Map<String, String> versionProps, String str, boolean optional, boolean channelArtifactResolution, boolean requireChannel) throws ProvisioningException {
        MavenArtifact artifact = new MavenArtifact();
        if (requireChannel) {
            artifact.addMetadata("org.wildfly.plugins.galleon.all.artifact.requires.channel.resolution", "true");
        }
        artifact.setExtension("jar");
        Utils.resolveArtifact(str, artifact, channelArtifactResolution);
        if (artifact.getGroupId() == null && artifact.getArtifactId() == null) {
            throw new IllegalArgumentException("Unexpected artifact coordinates format: " + str);
        }
        if (!artifact.hasVersion()) {
            String key = artifact.getGroupId() + EXPRESSION_DEFAULT_VALUE_SEPARATOR + artifact.getArtifactId() + (String)(artifact.getClassifier() == null || artifact.getClassifier().isEmpty() ? "" : "::" + artifact.getClassifier());
            String resolvedStr = versionProps.get(key);
            if (resolvedStr == null) {
                if (optional) {
                    return null;
                }
                if (channelArtifactResolution) {
                    return artifact;
                }
                throw new ProvisioningException("Failed to resolve the version of " + artifact.getGroupId() + EXPRESSION_DEFAULT_VALUE_SEPARATOR + artifact.getArtifactId());
            }
            MavenArtifact resolvedArtifact = new MavenArtifact();
            Utils.resolveArtifact(resolvedStr, resolvedArtifact, channelArtifactResolution);
            if (!resolvedArtifact.hasVersion() && !channelArtifactResolution) {
                throw new ProvisioningException("Failed to resolve the version for artifact: " + resolvedStr);
            }
            artifact.setVersion(resolvedArtifact.getVersion());
        }
        return artifact;
    }

    private static String resolveExpression(String coords, String str, boolean channelArtifactResolution, boolean isVersion) throws ProvisioningException {
        if (str == null) {
            return str;
        }
        String resolved = str;
        if ((str = str.trim()).startsWith(EXPRESSION_PREFIX) && str.endsWith(EXPRESSION_SUFFIX)) {
            String[] split;
            String expressions = str.substring(EXPRESSION_PREFIX.length(), str.length() - EXPRESSION_SUFFIX.length());
            int defValueSeparator = expressions.indexOf(EXPRESSION_DEFAULT_VALUE_SEPARATOR);
            String defaultValue = null;
            if (defValueSeparator >= 0) {
                defaultValue = expressions.substring(defValueSeparator + 1, expressions.length());
                defaultValue = defaultValue.trim();
                expressions = expressions.substring(0, defValueSeparator);
            }
            for (String expression : split = expressions.split(",", -1)) {
                String value;
                if ((expression = expression.trim()).isEmpty()) {
                    throw new ProvisioningException("Invalid syntax for expression " + coords);
                }
                if (expression.startsWith(EXPRESSION_ENV_VAR)) {
                    if ((expression = expression.substring(EXPRESSION_ENV_VAR.length(), expression.length())).isEmpty()) {
                        throw new ProvisioningException("Invalid syntax for expression " + coords);
                    }
                    value = System.getenv(expression);
                    if (value == null) continue;
                    return value;
                }
                value = System.getProperty(expression);
                if (value == null) continue;
                return value;
            }
            if (!(defaultValue != null || isVersion && channelArtifactResolution)) {
                throw new ProvisioningException("Unresolved expression for " + coords);
            }
            resolved = defaultValue;
        }
        return resolved;
    }

    static void resolveArtifact(String coords, MavenArtifact artifact, boolean channelArtifactResolution) throws ProvisioningException {
        if (coords == null) {
            return;
        }
        COORDS_STATE state = COORDS_STATE.GROUPID;
        StringBuilder currentBuilder = null;
        char[] array = coords.toCharArray();
        boolean expectSeparator = false;
        for (int i = 0; i < array.length; ++i) {
            char c = array[i];
            if (c == ' ') continue;
            if (expectSeparator && c != ':') {
                throw new ProvisioningException("Invalid syntax for expression " + coords);
            }
            expectSeparator = false;
            if (c == '$') {
                if (i < array.length - 1) {
                    char next = array[i + 1];
                    if ('{' != next) continue;
                    String remaining = coords.substring(i);
                    int end = remaining.indexOf(EXPRESSION_SUFFIX);
                    if (end < 0) {
                        throw new ProvisioningException("Invalid syntax for expression " + coords);
                    }
                    String exp = remaining.substring(0, end + 1);
                    String resolvedExp = Utils.resolveExpression(coords, exp, channelArtifactResolution, state == COORDS_STATE.VERSION);
                    if (resolvedExp != null) {
                        if (currentBuilder == null) {
                            currentBuilder = new StringBuilder();
                        }
                        currentBuilder.append(resolvedExp);
                    }
                    expectSeparator = true;
                    i += end;
                    continue;
                }
                if (currentBuilder == null) {
                    currentBuilder = new StringBuilder();
                }
                currentBuilder.append(c);
                continue;
            }
            if (c == ':') {
                String current = currentBuilder == null ? null : currentBuilder.toString();
                state = Utils.setState(coords, state, current, artifact);
                currentBuilder = null;
                continue;
            }
            if (currentBuilder == null) {
                currentBuilder = new StringBuilder();
            }
            currentBuilder.append(c);
        }
        Utils.setState(coords, state, currentBuilder == null ? null : currentBuilder.toString(), artifact);
    }

    private static COORDS_STATE setState(String coords, COORDS_STATE state, String value, MavenArtifact artifact) {
        COORDS_STATE newState = null;
        if (state == null) {
            throw new IllegalArgumentException("Unexpected artifact coordinates format: " + coords);
        }
        switch (state) {
            case GROUPID: {
                if (value != null) {
                    artifact.setGroupId(value);
                }
                newState = COORDS_STATE.ARTIFACTID;
                break;
            }
            case ARTIFACTID: {
                if (value != null) {
                    artifact.setArtifactId(value);
                }
                newState = COORDS_STATE.VERSION;
                break;
            }
            case VERSION: {
                if (value != null) {
                    artifact.setVersion(value);
                }
                newState = COORDS_STATE.CLASSIFIER;
                break;
            }
            case CLASSIFIER: {
                if (value != null) {
                    artifact.setClassifier(value);
                }
                newState = COORDS_STATE.EXTENSION;
                break;
            }
            case EXTENSION: {
                if (value == null) break;
                artifact.setExtension(value);
            }
        }
        return newState;
    }

    public static List<Path> collectLayersConf(ProvisioningLayout<?> layout) throws ProvisioningException {
        List layersConfs = Collections.emptyList();
        for (FeaturePackLayout fp : layout.getOrderedFeaturePacks()) {
            Path p = LayoutUtils.getPackageContentDir((Path)fp.getDir(), (String)"layers.conf");
            if (!Files.exists(p, new LinkOption[0])) continue;
            if (!Files.exists(p = p.resolve("modules").resolve("layers.conf"), new LinkOption[0])) {
                throw new ProvisioningException("Feature-pack " + fp.getFPID() + " package layers.conf is expected to contain modules/layers.conf but it does not");
            }
            layersConfs = CollectionUtils.add(layersConfs, (Object)p);
        }
        return layersConfs;
    }

    public static void mergeLayersConfs(List<Path> layersConfs, Path distHome) throws ProvisioningException {
        if (layersConfs.isEmpty()) {
            return;
        }
        if (layersConfs.size() == 1) {
            try {
                IoUtils.copy((Path)layersConfs.get(0), (Path)distHome.resolve("modules").resolve("layers.conf"));
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to install layes.conf to " + distHome, (Throwable)e);
            }
            return;
        }
        Properties props = new Properties();
        LinkedHashSet<String> layers = new LinkedHashSet<String>(layersConfs.size());
        for (Path p : layersConfs) {
            String[] layerNames;
            try (BufferedReader reader = Files.newBufferedReader(p);){
                props.load(reader);
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to generate layer.conf", (Throwable)e);
            }
            String layersProp = props.getProperty("layers");
            if (layersProp == null || (layersProp = layersProp.trim()).length() == 0) continue;
            for (String layerName : layerNames = layersProp.split(",")) {
                layers.add(layerName);
            }
        }
        if (!layers.isEmpty()) {
            StringBuilder buf = new StringBuilder();
            StringUtils.append((StringBuilder)buf, layers);
            props.setProperty("layers", buf.toString());
        }
        try (BufferedWriter writer = Files.newBufferedWriter(distHome.resolve("modules").resolve("layers.conf"), new OpenOption[0]);){
            props.store(writer, "Generated by WildFly Galleon provisioning plugin");
        }
        catch (IOException e) {
            throw new ProvisioningException("Failed to persist generated layers.conf", (Throwable)e);
        }
    }

    public static void extractArtifact(Path artifact, final Path target, final CopyArtifact copy) throws IOException {
        if (!Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target, new FileAttribute[0]);
        }
        try (FileSystem zipFS = FileSystems.newFileSystem(artifact, (ClassLoader)null);){
            for (final Path zipRoot : zipFS.getRootDirectories()) {
                Files.walkFileTree(zipRoot, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        block5: {
                            Object entry = dir.toString().substring(1);
                            if (((String)entry).isEmpty()) {
                                return FileVisitResult.CONTINUE;
                            }
                            if (!((String)entry).endsWith("/")) {
                                entry = (String)entry + "/";
                            }
                            if (!copy.includeFile((String)entry)) {
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            Path targetDir = target.resolve(zipRoot.relativize(dir).toString());
                            try {
                                Files.copy(dir, targetDir, new CopyOption[0]);
                            }
                            catch (FileAlreadyExistsException e) {
                                if (Files.isDirectory(targetDir, new LinkOption[0])) break block5;
                                throw e;
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        if (copy.includeFile(file.toString().substring(1))) {
                            Path targetPath = target.resolve(zipRoot.relativize(file).toString());
                            Files.copy(file, targetPath, new CopyOption[0]);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }

    static Map<String, String> toArtifactsMap(String str) throws ProvisioningException {
        if (str == null) {
            return Collections.emptyMap();
        }
        String[] split = str.split("\\|");
        HashMap<String, String> ret = new HashMap<String, String>();
        for (String artifact : split) {
            MavenArtifact mavenArtifact = new MavenArtifact();
            mavenArtifact.setExtension(null);
            Utils.resolveArtifact(artifact, mavenArtifact, false);
            StringBuilder builder = new StringBuilder();
            if (mavenArtifact.getGroupId() == null || mavenArtifact.getArtifactId() == null || !mavenArtifact.hasVersion() || mavenArtifact.getExtension() == null) {
                throw new IllegalArgumentException("Unexpected artifact coordinates format: " + artifact);
            }
            String grpId = Utils.check(artifact, mavenArtifact.getGroupId());
            String artifactId = Utils.check(artifact, mavenArtifact.getArtifactId());
            String version = Utils.check(artifact, mavenArtifact.getVersion());
            String classifier = mavenArtifact.getClassifier();
            if (classifier != null) {
                classifier = classifier.trim();
            }
            String ext = Utils.check(artifact, mavenArtifact.getExtension());
            String key = grpId + EXPRESSION_DEFAULT_VALUE_SEPARATOR + artifactId;
            builder.append(grpId).append(EXPRESSION_DEFAULT_VALUE_SEPARATOR).append(artifactId).append(EXPRESSION_DEFAULT_VALUE_SEPARATOR).append(version).append(EXPRESSION_DEFAULT_VALUE_SEPARATOR);
            if (classifier != null && !classifier.isEmpty()) {
                key = key + "::" + classifier;
                builder.append(classifier);
            }
            builder.append(EXPRESSION_DEFAULT_VALUE_SEPARATOR).append(ext);
            ret.put(key, builder.toString());
        }
        return ret;
    }

    private static String check(String artifact, String item) {
        if (item != null) {
            item = item.trim();
        }
        if (item == null || item.isEmpty()) {
            throw new IllegalArgumentException("Unexpected artifact coordinates format: " + artifact);
        }
        return item;
    }

    static enum COORDS_STATE {
        GROUPID,
        ARTIFACTID,
        VERSION,
        CLASSIFIER,
        EXTENSION;

    }
}

