/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.galleon.Errors;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.runtime.PackageRuntime;
import org.jboss.galleon.util.CollectionUtils;
import org.wildfly.galleon.plugin.WfInstallPlugin;
import org.wildfly.galleon.plugin.WildFlyPackageTask;
import org.wildfly.galleon.plugin.config.FileFilter;

public class XmlMerge
implements WildFlyPackageTask {
    private String basedir;
    private List<FileFilter> filters = Collections.emptyList();
    private String output;

    public void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void addFilter(FileFilter filter) {
        this.filters = CollectionUtils.add(this.filters, (Object)filter);
    }

    public boolean includeFile(String path) {
        for (FileFilter filter : this.filters) {
            if (!filter.matches(path)) continue;
            return filter.isInclude();
        }
        return false;
    }

    @Override
    public WildFlyPackageTask.Phase getPhase() {
        return WildFlyPackageTask.Phase.FINALIZING;
    }

    @Override
    public void execute(WfInstallPlugin plugin, PackageRuntime pkg) throws ProvisioningException {
        Path srcDir = plugin.getRuntime().getStagedDir();
        if (this.basedir != null) {
            srcDir = srcDir.resolve(this.basedir);
        }
        if (!Files.exists(srcDir, new LinkOption[0])) {
            plugin.getRuntime().getMessageWriter().print("WARN: base dir %s for xml-merge does not exist", new Object[]{srcDir});
            return;
        }
        StringBuilder buf = new StringBuilder();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(srcDir);){
            for (Path p : stream) {
                if (!this.includeFile(p.toString())) continue;
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(p.toUri().toString());
            }
        }
        catch (IOException e) {
            throw new ProvisioningException(Errors.readDirectory((Path)srcDir));
        }
        if (buf.length() == 0) {
            return;
        }
        Path pmWf = pkg.getResource(new String[]{"pm", "wildfly"});
        Path mergerXsl = pmWf.resolve("merger.xsl");
        if (!Files.exists(mergerXsl, new LinkOption[0])) {
            throw new ProvisioningException(Errors.pathDoesNotExist((Path)mergerXsl));
        }
        Path mergedXml = plugin.getRuntime().getStagedDir().resolve(this.output);
        try (OutputStream out = Files.newOutputStream(mergedXml, new OpenOption[0]);){
            Transformer transformer = plugin.getXslTransformer(mergerXsl);
            transformer.setParameter("fileList", buf.toString());
            transformer.setParameter("fileSeparator", File.separator);
            DOMSource source = new DOMSource(plugin.getXmlDocumentBuilderFactory().newDocumentBuilder().newDocument());
            StreamResult result = new StreamResult(out);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            throw new ProvisioningException("Failed to transform", (Throwable)e);
        }
    }
}

