/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.galleon.plugin;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.universe.maven.MavenArtifact;
import org.wildfly.galleon.plugin.ShadedModel;
import org.wildfly.galleon.plugin.WfInstallPlugin;

abstract class AbstractArtifactInstaller
implements ShadedModel.Installer {
    private final Path generatedMavenRepo;
    private final WfInstallPlugin.ArtifactResolver resolver;

    AbstractArtifactInstaller(WfInstallPlugin.ArtifactResolver resolver, Path generatedMavenRepo) {
        this.resolver = resolver;
        this.generatedMavenRepo = generatedMavenRepo;
    }

    abstract String installArtifactFat(MavenArtifact var1, Path var2) throws IOException, ProvisioningException;

    abstract String installArtifactThin(MavenArtifact var1) throws IOException, ProvisioningException;

    @Override
    public abstract Path installCopiedArtifact(MavenArtifact var1) throws IOException, ProvisioningException;

    Path getGeneratedMavenRepo() {
        return this.generatedMavenRepo;
    }

    WfInstallPlugin.ArtifactResolver getArtifactResolver() {
        return this.resolver;
    }

    static Path getPomArtifactPath(MavenArtifact artifact, WfInstallPlugin.ArtifactResolver resolver) throws ProvisioningException {
        MavenArtifact pomArtifact = new MavenArtifact();
        pomArtifact.setGroupId(artifact.getGroupId());
        pomArtifact.setArtifactId(artifact.getArtifactId());
        pomArtifact.setVersion(artifact.getVersion());
        pomArtifact.setExtension("pom");
        resolver.resolve(pomArtifact);
        return pomArtifact.getPath();
    }

    static Path getLocalRepoPath(MavenArtifact artifact, String version, Path repo) throws IOException {
        return AbstractArtifactInstaller.getLocalRepoPath(artifact, version, repo, true);
    }

    static Path getLocalRepoPath(MavenArtifact artifact, String version, Path repo, boolean create) throws IOException {
        String grpid = artifact.getGroupId().replaceAll("\\.", Matcher.quoteReplacement(File.separator));
        Path grpidPath = repo.resolve(grpid);
        Path artifactidPath = grpidPath.resolve(artifact.getArtifactId());
        Path versionPath = artifactidPath.resolve(version);
        if (create) {
            Files.createDirectories(versionPath, new FileAttribute[0]);
        }
        return versionPath;
    }

    void installInGeneratedRepo(MavenArtifact artifact, String version, Path path) throws IOException, ProvisioningException {
        if (this.getGeneratedMavenRepo() != null) {
            Path versionPath = AbstractArtifactInstaller.getLocalRepoPath(artifact, version, this.getGeneratedMavenRepo());
            Path actualTarget = versionPath.resolve(path.getFileName().toString());
            Files.copy(path, actualTarget, StandardCopyOption.REPLACE_EXISTING);
            Path pomFile = AbstractArtifactInstaller.getPomArtifactPath(artifact, this.getArtifactResolver());
            Files.copy(pomFile, versionPath.resolve(pomFile.getFileName().toString()), StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

