/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.wildfly.prospero.ProsperoLogger;

class InstallFolderUtils {
    InstallFolderUtils() {
    }

    static void verifyIsWritable(Path directory) {
        if (!InstallFolderUtils.isWritable(directory)) {
            throw ProsperoLogger.ROOT_LOGGER.dirMustBeWritable(directory);
        }
    }

    static void verifyIsEmptyDir(Path directory) {
        if (directory.toFile().isFile()) {
            throw ProsperoLogger.ROOT_LOGGER.dirMustBeDirectory(directory);
        }
        if (!InstallFolderUtils.isEmptyDirectory(directory)) {
            throw ProsperoLogger.ROOT_LOGGER.cannotInstallIntoNonEmptyDirectory(directory);
        }
    }

    private static boolean isWritable(Path path) {
        Path absPath = path.toAbsolutePath();
        if (Files.exists(absPath, new LinkOption[0])) {
            return Files.isWritable(absPath);
        }
        if (absPath.getParent() == null) {
            return false;
        }
        return InstallFolderUtils.isWritable(absPath.getParent());
    }

    private static boolean isEmptyDirectory(Path directory) {
        String[] list = directory.toFile().list();
        return list == null || list.length == 0;
    }
}

