/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.actions;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.wildfly.channel.Channel;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.api.InstallationMetadata;
import org.wildfly.prospero.api.exceptions.MetadataException;
import org.wildfly.prospero.metadata.ManifestVersionRecord;
import org.wildfly.prospero.model.ProsperoConfig;

public class MetadataAction
implements AutoCloseable {
    private final InstallationMetadata installationMetadata;

    public MetadataAction(Path installation) throws MetadataException {
        this.installationMetadata = InstallationMetadata.loadInstallation(installation);
    }

    protected MetadataAction(InstallationMetadata installationMetadata) {
        this.installationMetadata = installationMetadata;
    }

    public void addChannel(Channel channel) throws MetadataException {
        ProsperoLogger.ROOT_LOGGER.addingChannel(channel.toString());
        ProsperoConfig prosperoConfig = this.installationMetadata.getProsperoConfig();
        List<Channel> channels = prosperoConfig.getChannels();
        if (channels.stream().anyMatch(c -> c.getName().equals(channel.getName()))) {
            ProsperoLogger.ROOT_LOGGER.existingChannel(channel.getName());
            throw ProsperoLogger.ROOT_LOGGER.channelExists(channel.getName());
        }
        channels.add(channel);
        this.installationMetadata.updateProsperoConfig(prosperoConfig);
        ProsperoLogger.ROOT_LOGGER.channelAdded(channel.getName());
    }

    public void removeChannel(String channelName) throws MetadataException {
        ProsperoLogger.ROOT_LOGGER.removingChannel(channelName);
        ProsperoConfig prosperoConfig = this.installationMetadata.getProsperoConfig();
        List<Channel> channels = prosperoConfig.getChannels();
        Optional<Channel> removedChannel = channels.stream().filter(c -> c.getName().equals(channelName)).findAny();
        if (removedChannel.isEmpty()) {
            MetadataException ex = ProsperoLogger.ROOT_LOGGER.channelNotFound(channelName);
            ProsperoLogger.ROOT_LOGGER.warnf(ex, "", new Object[0]);
            throw ex;
        }
        channels.remove(removedChannel.get());
        this.installationMetadata.updateProsperoConfig(prosperoConfig);
        ProsperoLogger.ROOT_LOGGER.channelRemoved(channelName);
    }

    public void changeChannel(String channelName, Channel newChannel) throws MetadataException {
        ProsperoLogger.ROOT_LOGGER.updatingChannel(newChannel.toString(), channelName);
        ProsperoConfig prosperoConfig = this.installationMetadata.getProsperoConfig();
        List<Channel> channels = prosperoConfig.getChannels();
        Optional<Channel> modifiedChannel = channels.stream().filter(c -> c.getName().equals(channelName)).findAny();
        if (modifiedChannel.isEmpty()) {
            throw ProsperoLogger.ROOT_LOGGER.channelNotFound(channelName);
        }
        channels.set(channels.indexOf(modifiedChannel.get()), newChannel);
        this.installationMetadata.updateProsperoConfig(prosperoConfig);
        ProsperoLogger.ROOT_LOGGER.channelUpdated(channelName);
    }

    public List<Channel> getChannels() throws MetadataException {
        ProsperoLogger.ROOT_LOGGER.listChannels();
        return new ArrayList<Channel>(this.installationMetadata.getProsperoConfig().getChannels());
    }

    public ManifestVersionRecord getChannelVersions() {
        return this.installationMetadata.getManifestVersions().orElse(new ManifestVersionRecord());
    }

    @Override
    public void close() {
        this.installationMetadata.close();
    }
}

