/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.prospero.spi;

import java.io.File;
import java.nio.file.Path;
import org.wildfly.installationmanager.MavenOptions;
import org.wildfly.installationmanager.spi.InstallationManager;
import org.wildfly.installationmanager.spi.InstallationManagerFactory;
import org.wildfly.prospero.ProsperoLogger;
import org.wildfly.prospero.spi.ProsperoInstallationManager;

public class ProsperoInstallationManagerFactory
implements InstallationManagerFactory {
    public InstallationManager create(Path installationDir, MavenOptions mavenOptions) throws Exception {
        this.verifyInstallationDirectory(installationDir);
        return new ProsperoInstallationManager(installationDir, mavenOptions);
    }

    public String getName() {
        return "prospero";
    }

    private void verifyInstallationDirectory(Path path) {
        File dotGalleonDir = path.resolve(".galleon").toFile();
        File channelsFile = path.resolve(".installation").resolve("installer-channels.yaml").toFile();
        if (!dotGalleonDir.isDirectory() || !channelsFile.isFile()) {
            throw ProsperoLogger.ROOT_LOGGER.invalidInstallationDir(path);
        }
    }
}

