/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.common;

import java.security.Permission;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.wildfly.elytron.web.undertow.common.AbstractHttpServerMechanismTest;
import org.wildfly.elytron.web.undertow.common.UndertowServer;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.permission.PermissionVerifier;

@Ignore(value="https://github.com/wildfly-security/elytron-web/issues/45")
public abstract class FormAuthenticationWithSessionReplicationBase
extends AbstractHttpServerMechanismTest {
    @Rule
    public UndertowServer serverA = this.createUndertowServer(7776);
    @Rule
    public UndertowServer serverB = this.createUndertowServer(7777);
    @Rule
    public UndertowServer serverC = this.createUndertowServer(7778);

    protected FormAuthenticationWithSessionReplicationBase() throws Exception {
    }

    @Test
    public void testSuccessFulAuthentication() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        FormAuthenticationWithSessionReplicationBase.assertLoginPage(httpClient.execute((HttpUriRequest)new HttpGet(this.serverA.createUri())));
        HttpPost httpAuthenticate = new HttpPost(this.serverA.createUri("/j_security_check"));
        ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
        parameters.add(new BasicNameValuePair("j_username", "ladybird"));
        parameters.add(new BasicNameValuePair("j_password", "Coleoptera"));
        httpAuthenticate.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
        HttpResponse execute = httpClient.execute((HttpUriRequest)httpAuthenticate);
        for (int i = 0; i < 2; ++i) {
            this.assertSuccessfulResponse(execute, "ladybird");
            this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)new HttpGet(this.serverB.createUri())), "ladybird");
            this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)new HttpGet(this.serverC.createUri())), "ladybird");
        }
    }

    @Test
    public void testSessionInvalidation() throws Exception {
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        FormAuthenticationWithSessionReplicationBase.assertLoginPage(httpClient.execute((HttpUriRequest)new HttpGet(this.serverA.createUri())));
        for (int i = 0; i < 10; ++i) {
            HttpPost httpAuthenticate = new HttpPost(this.serverA.createUri("/j_security_check"));
            ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
            parameters.add(new BasicNameValuePair("j_username", "ladybird"));
            parameters.add(new BasicNameValuePair("j_password", "Coleoptera"));
            httpAuthenticate.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters));
            HttpResponse execute = httpClient.execute((HttpUriRequest)httpAuthenticate);
            this.assertSuccessfulResponse(execute, "ladybird");
            this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)new HttpGet(this.serverA.createUri())), "ladybird");
            this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)new HttpGet(this.serverB.createUri())), "ladybird");
            this.assertSuccessfulResponse(httpClient.execute((HttpUriRequest)new HttpGet(this.serverC.createUri())), "ladybird");
            httpClient.execute((HttpUriRequest)new HttpGet(this.serverA.createUri("/logout")));
            FormAuthenticationWithSessionReplicationBase.assertLoginPage(httpClient.execute((HttpUriRequest)new HttpGet(this.serverC.createUri())));
            FormAuthenticationWithSessionReplicationBase.assertLoginPage(httpClient.execute((HttpUriRequest)new HttpGet(this.serverA.createUri())));
            FormAuthenticationWithSessionReplicationBase.assertLoginPage(httpClient.execute((HttpUriRequest)new HttpGet(this.serverB.createUri())));
        }
    }

    @Override
    protected String getMechanismName() {
        return "FORM";
    }

    @Override
    protected SecurityDomain doCreateSecurityDomain() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"clear");
        HashMap<String, SimpleRealmEntry> passwordMap = new HashMap<String, SimpleRealmEntry>();
        passwordMap.put("ladybird", new SimpleRealmEntry(Collections.singletonList(new PasswordCredential(passwordFactory.generatePassword((KeySpec)new ClearPasswordSpec("Coleoptera".toCharArray()))))));
        SimpleMapBackedSecurityRealm securityRealm = new SimpleMapBackedSecurityRealm();
        securityRealm.setPasswordMap(passwordMap);
        SecurityDomain.Builder builder = SecurityDomain.builder().setDefaultRealmName("TestRealm");
        builder.addRealm("TestRealm", (SecurityRealm)securityRealm).build();
        builder.setPermissionMapper((principal, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        return builder.build();
    }

    protected abstract UndertowServer createUndertowServer(int var1) throws Exception;
}

