/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HttpString;
import java.util.List;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronAccount;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpExchangeSpi;

class ElytronHttpExchange
implements HttpExchangeSpi {
    private final HttpServerExchange httpServerExchange;

    ElytronHttpExchange(HttpServerExchange httpServerExchange) {
        this.httpServerExchange = (HttpServerExchange)Assert.checkNotNullParam((String)"httpServerExchange", (Object)httpServerExchange);
    }

    public List<String> getRequestHeaderValues(String headerName) {
        return this.httpServerExchange.getRequestHeaders().get(headerName);
    }

    public void addResponseHeader(String headerName, String headerValue) {
        this.httpServerExchange.getResponseHeaders().add(new HttpString(headerName), headerValue);
    }

    public void setResponseCode(int responseCode) {
        this.httpServerExchange.setResponseCode(responseCode);
    }

    public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
        SecurityContext securityContext = this.httpServerExchange.getSecurityContext();
        if (securityContext != null) {
            securityContext.authenticationComplete((Account)new ElytronAccount(securityIdentity), mechanismName, false);
        }
    }

    public void authenticationFailed(String message, String mechanismName) {
        SecurityContext securityContext = this.httpServerExchange.getSecurityContext();
        if (securityContext != null) {
            securityContext.authenticationFailed(message, mechanismName);
        }
    }
}

