/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.SecurityContext;
import io.undertow.security.idm.Account;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.ServerConnection;
import io.undertow.server.handlers.Cookie;
import io.undertow.server.handlers.CookieImpl;
import io.undertow.server.protocol.http.HttpServerConnection;
import io.undertow.util.HttpString;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLSession;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronAccount;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerCookie;

class ElytronHttpExchange
implements HttpExchangeSpi {
    private final HttpServerExchange httpServerExchange;

    ElytronHttpExchange(HttpServerExchange httpServerExchange) {
        this.httpServerExchange = (HttpServerExchange)Assert.checkNotNullParam((String)"httpServerExchange", (Object)httpServerExchange);
    }

    public List<String> getRequestHeaderValues(String headerName) {
        return this.httpServerExchange.getRequestHeaders().get(headerName);
    }

    public void addResponseHeader(String headerName, String headerValue) {
        this.httpServerExchange.getResponseHeaders().add(new HttpString(headerName), headerValue);
    }

    public void setResponseCode(int responseCode) {
        this.httpServerExchange.setResponseCode(responseCode);
    }

    public SSLSession getSSLSession() {
        ServerConnection connection = this.httpServerExchange.getConnection();
        if (connection instanceof HttpServerConnection) {
            return ((HttpServerConnection)connection).getSslSession();
        }
        return null;
    }

    public void authenticationComplete(SecurityIdentity securityIdentity, String mechanismName) {
        SecurityContext securityContext = this.httpServerExchange.getSecurityContext();
        if (securityContext != null) {
            securityContext.authenticationComplete((Account)new ElytronAccount(securityIdentity), mechanismName, false);
        }
    }

    public void authenticationFailed(String message, String mechanismName) {
        SecurityContext securityContext = this.httpServerExchange.getSecurityContext();
        if (securityContext != null) {
            securityContext.authenticationFailed(message, mechanismName);
        }
    }

    public void badRequest(HttpAuthenticationException error, String mechanismName) {
    }

    public String getRequestMethod() {
        return this.httpServerExchange.getRequestMethod().toString();
    }

    public String getRequestURI() {
        StringBuilder uriBuilder = new StringBuilder();
        if (!this.httpServerExchange.isHostIncludedInRequestURI()) {
            uriBuilder.append(this.httpServerExchange.getRequestScheme()).append("://").append(this.httpServerExchange.getHostAndPort());
        }
        uriBuilder.append(this.httpServerExchange.getRequestURI());
        String queryString = this.httpServerExchange.getQueryString();
        if (queryString != null && !"".equals(queryString.trim())) {
            uriBuilder.append("?").append(queryString);
        }
        return uriBuilder.toString();
    }

    public Map<String, String[]> getRequestParameters() {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        Map queryParameters = this.httpServerExchange.getQueryParameters();
        queryParameters.forEach((name, values) -> parameters.put((String)name, values.toArray(new String[values.size()])));
        return parameters;
    }

    public HttpServerCookie[] getCookies() {
        Map cookies = this.httpServerExchange.getRequestCookies();
        return cookies.values().stream().map(cookie -> new HttpServerCookie((Cookie)cookie){
            final /* synthetic */ Cookie val$cookie;
            {
                this.val$cookie = cookie;
            }

            public String getName() {
                return this.val$cookie.getName();
            }

            public String getValue() {
                return this.val$cookie.getValue();
            }

            public String getDomain() {
                return this.val$cookie.getDomain();
            }

            public int getMaxAge() {
                return this.val$cookie.getMaxAge();
            }

            public String getPath() {
                return this.val$cookie.getPath();
            }

            public boolean isSecure() {
                return this.val$cookie.isSecure();
            }

            public int getVersion() {
                return this.val$cookie.getVersion();
            }

            public boolean isHttpOnly() {
                return this.val$cookie.isHttpOnly();
            }
        }).collect(Collectors.toList()).toArray(new HttpServerCookie[cookies.size()]);
    }

    public InputStream getRequestInputStream() {
        return this.httpServerExchange.getInputStream();
    }

    public InetSocketAddress getSourceAddress() {
        return this.httpServerExchange.getSourceAddress();
    }

    public void setResponseCookie(HttpServerCookie cookie) {
        CookieImpl actualCookie = new CookieImpl(cookie.getName(), cookie.getValue());
        actualCookie.setDomain(cookie.getDomain());
        actualCookie.setMaxAge(Integer.valueOf(cookie.getMaxAge()));
        actualCookie.setHttpOnly(cookie.isHttpOnly());
        actualCookie.setSecure(cookie.isSecure());
        actualCookie.setPath(cookie.getPath());
        this.httpServerExchange.setResponseCookie((Cookie)actualCookie);
    }

    public OutputStream getResponseOutputStream() {
        return null;
    }
}

