/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import java.util.Set;
import org.wildfly.security.http.HttpServerSession;
import org.wildfly.security.http.HttpSessionSpi;

public class ElytronHttpSession
implements HttpSessionSpi {
    private final HttpServerExchange exchange;

    public ElytronHttpSession(HttpServerExchange exchange) {
        this.exchange = exchange;
    }

    public HttpServerSession getSession(boolean create) {
        SessionManager sessionManager = this.getSessionManager(this.exchange);
        SessionConfig sessionConfig = this.getSessionConfig(this.exchange);
        Session session = sessionManager.getSession(this.exchange, sessionConfig);
        if (create && session == null) {
            session = sessionManager.createSession(this.exchange, sessionConfig);
        }
        return this.createSession(session);
    }

    public HttpServerSession getSession(String id) {
        SessionManager sessionManager = this.getSessionManager(this.exchange);
        Session session = sessionManager.getSession(id);
        return this.createSession(session);
    }

    public Set<String> getSessions() {
        SessionManager sessionManager = this.getSessionManager(this.exchange);
        return sessionManager.getAllSessions();
    }

    protected SessionManager getSessionManager(HttpServerExchange exchange) {
        return (SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
    }

    protected SessionConfig getSessionConfig(HttpServerExchange exchange) {
        return (SessionConfig)exchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
    }

    private HttpServerSession createSession(final Session session) {
        if (session == null) {
            return null;
        }
        return new HttpServerSession(){

            public String getId() {
                return session.getId();
            }

            public Object getAttribute(String name) {
                return session.getAttribute(name);
            }

            public void setAttribute(String name, Object value) {
                session.setAttribute(name, value);
            }

            public Object removeAttribute(String name) {
                return session.removeAttribute(name);
            }

            public void invalidate() {
                session.invalidate(ElytronHttpSession.this.exchange);
            }
        };
    }
}

