/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.elytron.web.undertow.server;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.idm.IdentityManager;
import io.undertow.security.impl.AbstractSecurityContext;
import io.undertow.server.HttpServerExchange;
import java.util.List;
import java.util.function.Supplier;
import org.wildfly.common.Assert;
import org.wildfly.elytron.web.undertow.server.ElytronHttpExchange;
import org.wildfly.security.http.HttpAuthenticationException;
import org.wildfly.security.http.HttpAuthenticator;
import org.wildfly.security.http.HttpExchangeSpi;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpSessionSpi;

public class SecurityContextImpl
extends AbstractSecurityContext {
    private final Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier;
    private final Supplier<HttpSessionSpi> httpSessionSpiSupplier;

    SecurityContextImpl(HttpServerExchange exchange, Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier) {
        this(exchange, mechanismSupplier, null);
    }

    SecurityContextImpl(HttpServerExchange exchange, Supplier<List<HttpServerAuthenticationMechanism>> mechanismSupplier, Supplier<HttpSessionSpi> httpSessionSpiSupplier) {
        super((HttpServerExchange)Assert.checkNotNullParam((String)"exchange", (Object)exchange));
        this.mechanismSupplier = (Supplier)Assert.checkNotNullParam((String)"mechanismSupplier", mechanismSupplier);
        this.httpSessionSpiSupplier = httpSessionSpiSupplier != null ? httpSessionSpiSupplier : () -> HttpSessionSpi.NOT_SUPPORTED;
    }

    public boolean authenticate() {
        HttpAuthenticator authenticator = HttpAuthenticator.builder().setMechanismSupplier(this.mechanismSupplier).setHttpExchangeSpi((HttpExchangeSpi)new ElytronHttpExchange(this.exchange)).setHttpSessionSpi(this.httpSessionSpiSupplier.get()).setRequired(this.isAuthenticationRequired()).setIgnoreOptionalFailures(false).build();
        try {
            return authenticator.authenticate();
        }
        catch (HttpAuthenticationException e) {
            this.exchange.setResponseCode(500);
            return false;
        }
    }

    public boolean login(String username, String password) {
        return false;
    }

    public void addAuthenticationMechanism(AuthenticationMechanism mechanism) {
        throw new UnsupportedOperationException();
    }

    public List<AuthenticationMechanism> getAuthenticationMechanisms() {
        throw new UnsupportedOperationException();
    }

    public IdentityManager getIdentityManager() {
        throw new UnsupportedOperationException();
    }
}

