package org.wildfly.security.auth.server._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import org.wildfly.security.authz.AuthorizationFailureException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.security.GeneralSecurityException;
import org.wildfly.security.auth.server.RealmUnavailableException;
import java.lang.SecurityException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.security.Principal;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.ERROR;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-05-14T11:14:49+0100")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String builderAlreadyBuilt$str() {
        return "ELY00003: This builder has already been built";
    }
    @Override
    public final IllegalStateException builderAlreadyBuilt() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), builderAlreadyBuilt$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String credentialNotSupported$str() {
        return "ELY00008: The given credential is not supported here";
    }
    @Override
    public final IllegalArgumentException credentialNotSupported() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), credentialNotSupported$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String nameAlreadySet$str() {
        return "ELY01000: Authentication name was already set on this context";
    }
    @Override
    public final IllegalStateException nameAlreadySet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), nameAlreadySet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noAuthenticationInProgress$str() {
        return "ELY01003: No authentication is in progress";
    }
    @Override
    public final IllegalStateException noAuthenticationInProgress() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noAuthenticationInProgress$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String realmMapDoesNotContainDefault$str() {
        return "ELY01005: Realm map does not contain mapping for default realm '%s'";
    }
    @Override
    public final IllegalArgumentException realmMapDoesNotContainDefault(final String defaultRealm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), realmMapDoesNotContainDefault$str(), defaultRealm));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToObtainExclusiveAccess$str() {
        return "ELY01019: Unable to obtain exclusive access to backing identity";
    }
    @Override
    public final RealmUnavailableException unableToObtainExclusiveAccess() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), unableToObtainExclusiveAccess$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String userDoesNotExist$str() {
        return "ELY01033: User does not exist";
    }
    @Override
    public final IllegalStateException userDoesNotExist() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), userDoesNotExist$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidCredentialTypeSpecified$str() {
        return "ELY01034: Invalid credential type specified";
    }
    @Override
    public final IllegalStateException invalidCredentialTypeSpecified() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidCredentialTypeSpecified$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidName$str() {
        return "ELY01064: Invalid identity name";
    }
    @Override
    public final IllegalArgumentException invalidName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidName$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String runAsAuthorizationFailed$str() {
        return "ELY01088: Attempting to run as \"%s\" authorization operation failed";
    }
    @Override
    public final AuthorizationFailureException runAsAuthorizationFailed(final Principal principal, final Principal targetPrincipal, final Throwable cause) {
        final AuthorizationFailureException result = new AuthorizationFailureException(String.format(getLoggingLocale(), runAsAuthorizationFailed$str(), targetPrincipal), cause, principal);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidMechRealmSelection$str() {
        return "ELY01092: Invalid mechanism realm selection \"%s\"";
    }
    @Override
    public final IllegalArgumentException invalidMechRealmSelection(final String realmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidMechRealmSelection$str(), realmName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String mechRealmAlreadySelected$str() {
        return "ELY01093: Mechanism realm was already selected";
    }
    @Override
    public final IllegalStateException mechRealmAlreadySelected() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), mechRealmAlreadySelected$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToCreateIdentity$str() {
        return "ELY01095: Unable to create identity";
    }
    @Override
    public final RealmUnavailableException unableToCreateIdentity() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), unableToCreateIdentity$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchIdentity$str() {
        return "ELY01096: No such identity";
    }
    @Override
    public final RealmUnavailableException noSuchIdentity() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), noSuchIdentity$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotSucceedNotAuthorized$str() {
        return "ELY01112: Authentication cannot succeed; not authorized";
    }
    @Override
    public final IllegalStateException cannotSucceedNotAuthorized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotSucceedNotAuthorized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unableToSelectMechanismConfiguration$str() {
        return "ELY01119: Unable to resolve MechanismConfiguration for mechanismType='%s', mechanismName='%s', hostName='%s', protocol='%s'.";
    }
    @Override
    public final IllegalStateException unableToSelectMechanismConfiguration(final String mechanismType, final String mechanismName, final String hostName, final String protocol) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToSelectMechanismConfiguration$str(), mechanismType, mechanismName, hostName, protocol));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String tooLateToSetMechanismInformation$str() {
        return "ELY01120: Too late to set mechanism information as authentication has already begun.";
    }
    @Override
    public final IllegalStateException tooLateToSetMechanismInformation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tooLateToSetMechanismInformation$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String credentialUpdateNotSupportedByRealm$str() {
        return "ELY01124: The security realm does not support updating a credential";
    }
    @Override
    public final UnsupportedOperationException credentialUpdateNotSupportedByRealm() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), credentialUpdateNotSupportedByRealm$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String classLoaderSecurityDomainExists$str() {
        return "ELY01148: A SecurityDomain has already been associated with the specified ClassLoader";
    }
    @Override
    public final IllegalStateException classLoaderSecurityDomainExists() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), classLoaderSecurityDomainExists$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cantWithSameSecurityDomainDomain$str() {
        return "ELY01149: Can not use SecurityIdentity with SecurityIdentity from same SecurityDomain";
    }
    @Override
    public final IllegalArgumentException cantWithSameSecurityDomainDomain() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cantWithSameSecurityDomainDomain$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationFailedEvidenceVerification$str() {
        return "ELY01151: Evidence Verification Failed.";
    }
    @Override
    public final SecurityException authenticationFailedEvidenceVerification() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), authenticationFailedEvidenceVerification$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String authenticationFailedAuthorization$str() {
        return "ELY01152: Authorization Check Failed.";
    }
    @Override
    public final SecurityException authenticationFailedAuthorization() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), authenticationFailedAuthorization$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String securityDomainMismatch$str() {
        return "ELY01155: Security domain mismatch";
    }
    @Override
    public final IllegalArgumentException securityDomainMismatch() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), securityDomainMismatch$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotObtainCredentialFromFactory$str() {
        return "ELY01156: Cannot obtain a credential from a security factory";
    }
    @Override
    public final IOException cannotObtainCredentialFromFactory(final GeneralSecurityException e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), cannotObtainCredentialFromFactory$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void eventHandlerFailed(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, eventHandlerFailed$str());
    }
    protected String eventHandlerFailed$str() {
        return "ELY01094: An event handler threw an exception";
    }
    protected String roleMappedAlreadyInitialized$str() {
        return "ELY08510: Role mapper has already been initialized.";
    }
    @Override
    public final IllegalStateException roleMappedAlreadyInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), roleMappedAlreadyInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String roleMappedNotInitialized$str() {
        return "ELY08511: Role mapper hasn't been initialized yet.";
    }
    @Override
    public final IllegalStateException roleMappedNotInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), roleMappedNotInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
