package org.wildfly.security.auth.server._private;

import java.util.Locale;
import java.lang.IllegalStateException;
import org.wildfly.security.authz.AuthorizationFailureException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.security.GeneralSecurityException;
import org.wildfly.security.auth.server.RealmUnavailableException;
import java.lang.SecurityException;
import java.lang.String;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.security.Principal;
import java.lang.UnsupportedOperationException;


import static org.jboss.logging.Logger.Level.ERROR;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2019-02-07T10:04:37-0500")
public class ElytronMessages_$logger extends DelegatingBasicLogger implements ElytronMessages, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    public ElytronMessages_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String builderAlreadyBuilt = "ELY00003: This builder has already been built";
    protected String builderAlreadyBuilt$str() {
        return builderAlreadyBuilt;
    }
    @Override
    public final IllegalStateException builderAlreadyBuilt() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), builderAlreadyBuilt$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialNotSupported = "ELY00008: The given credential is not supported here";
    protected String credentialNotSupported$str() {
        return credentialNotSupported;
    }
    @Override
    public final IllegalArgumentException credentialNotSupported() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), credentialNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nameAlreadySet = "ELY01000: Authentication name was already set on this context";
    protected String nameAlreadySet$str() {
        return nameAlreadySet;
    }
    @Override
    public final IllegalStateException nameAlreadySet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), nameAlreadySet$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noAuthenticationInProgress = "ELY01003: No authentication is in progress";
    protected String noAuthenticationInProgress$str() {
        return noAuthenticationInProgress;
    }
    @Override
    public final IllegalStateException noAuthenticationInProgress() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), noAuthenticationInProgress$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String realmMapDoesNotContainDefault = "ELY01005: Realm map does not contain mapping for default realm '%s'";
    protected String realmMapDoesNotContainDefault$str() {
        return realmMapDoesNotContainDefault;
    }
    @Override
    public final IllegalArgumentException realmMapDoesNotContainDefault(final String defaultRealm) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), realmMapDoesNotContainDefault$str(), defaultRealm));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToObtainExclusiveAccess = "ELY01019: Unable to obtain exclusive access to backing identity";
    protected String unableToObtainExclusiveAccess$str() {
        return unableToObtainExclusiveAccess;
    }
    @Override
    public final RealmUnavailableException unableToObtainExclusiveAccess() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), unableToObtainExclusiveAccess$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String userDoesNotExist = "ELY01033: User does not exist";
    protected String userDoesNotExist$str() {
        return userDoesNotExist;
    }
    @Override
    public final IllegalStateException userDoesNotExist() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), userDoesNotExist$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidCredentialTypeSpecified = "ELY01034: Invalid credential type specified";
    protected String invalidCredentialTypeSpecified$str() {
        return invalidCredentialTypeSpecified;
    }
    @Override
    public final IllegalStateException invalidCredentialTypeSpecified() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), invalidCredentialTypeSpecified$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidName = "ELY01064: Invalid identity name";
    protected String invalidName$str() {
        return invalidName;
    }
    @Override
    public final IllegalArgumentException invalidName() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String runAsAuthorizationFailed = "ELY01088: Attempting to run as \"%s\" authorization operation failed";
    protected String runAsAuthorizationFailed$str() {
        return runAsAuthorizationFailed;
    }
    @Override
    public final AuthorizationFailureException runAsAuthorizationFailed(final Principal principal, final Principal targetPrincipal, final Throwable cause) {
        final AuthorizationFailureException result = new AuthorizationFailureException(String.format(getLoggingLocale(), runAsAuthorizationFailed$str(), targetPrincipal), cause, principal);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMechRealmSelection = "ELY01092: Invalid mechanism realm selection \"%s\"";
    protected String invalidMechRealmSelection$str() {
        return invalidMechRealmSelection;
    }
    @Override
    public final IllegalArgumentException invalidMechRealmSelection(final String realmName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidMechRealmSelection$str(), realmName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String mechRealmAlreadySelected = "ELY01093: Mechanism realm was already selected";
    protected String mechRealmAlreadySelected$str() {
        return mechRealmAlreadySelected;
    }
    @Override
    public final IllegalStateException mechRealmAlreadySelected() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), mechRealmAlreadySelected$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToCreateIdentity = "ELY01095: Unable to create identity";
    protected String unableToCreateIdentity$str() {
        return unableToCreateIdentity;
    }
    @Override
    public final RealmUnavailableException unableToCreateIdentity() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), unableToCreateIdentity$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noSuchIdentity = "ELY01096: No such identity";
    protected String noSuchIdentity$str() {
        return noSuchIdentity;
    }
    @Override
    public final RealmUnavailableException noSuchIdentity() {
        final RealmUnavailableException result = new RealmUnavailableException(String.format(getLoggingLocale(), noSuchIdentity$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotSucceedNotAuthorized = "ELY01112: Authentication cannot succeed; not authorized";
    protected String cannotSucceedNotAuthorized$str() {
        return cannotSucceedNotAuthorized;
    }
    @Override
    public final IllegalStateException cannotSucceedNotAuthorized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotSucceedNotAuthorized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToSelectMechanismConfiguration = "ELY01119: Unable to resolve MechanismConfiguration for mechanismType='%s', mechanismName='%s', hostName='%s', protocol='%s'.";
    protected String unableToSelectMechanismConfiguration$str() {
        return unableToSelectMechanismConfiguration;
    }
    @Override
    public final IllegalStateException unableToSelectMechanismConfiguration(final String mechanismType, final String mechanismName, final String hostName, final String protocol) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unableToSelectMechanismConfiguration$str(), mechanismType, mechanismName, hostName, protocol));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String tooLateToSetMechanismInformation = "ELY01120: Too late to set mechanism information as authentication has already begun.";
    protected String tooLateToSetMechanismInformation$str() {
        return tooLateToSetMechanismInformation;
    }
    @Override
    public final IllegalStateException tooLateToSetMechanismInformation() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), tooLateToSetMechanismInformation$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String credentialUpdateNotSupportedByRealm = "ELY01124: The security realm does not support updating a credential";
    protected String credentialUpdateNotSupportedByRealm$str() {
        return credentialUpdateNotSupportedByRealm;
    }
    @Override
    public final UnsupportedOperationException credentialUpdateNotSupportedByRealm() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), credentialUpdateNotSupportedByRealm$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classLoaderSecurityDomainExists = "ELY01148: A SecurityDomain has already been associated with the specified ClassLoader";
    protected String classLoaderSecurityDomainExists$str() {
        return classLoaderSecurityDomainExists;
    }
    @Override
    public final IllegalStateException classLoaderSecurityDomainExists() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), classLoaderSecurityDomainExists$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cantWithSameSecurityDomainDomain = "ELY01149: Can not use SecurityIdentity with SecurityIdentity from same SecurityDomain";
    protected String cantWithSameSecurityDomainDomain$str() {
        return cantWithSameSecurityDomainDomain;
    }
    @Override
    public final IllegalArgumentException cantWithSameSecurityDomainDomain() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cantWithSameSecurityDomainDomain$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationFailedEvidenceVerification = "ELY01151: Evidence Verification Failed.";
    protected String authenticationFailedEvidenceVerification$str() {
        return authenticationFailedEvidenceVerification;
    }
    @Override
    public final SecurityException authenticationFailedEvidenceVerification() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), authenticationFailedEvidenceVerification$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String authenticationFailedAuthorization = "ELY01152: Authorization Check Failed.";
    protected String authenticationFailedAuthorization$str() {
        return authenticationFailedAuthorization;
    }
    @Override
    public final SecurityException authenticationFailedAuthorization() {
        final SecurityException result = new SecurityException(String.format(getLoggingLocale(), authenticationFailedAuthorization$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String securityDomainMismatch = "ELY01155: Security domain mismatch";
    protected String securityDomainMismatch$str() {
        return securityDomainMismatch;
    }
    @Override
    public final IllegalArgumentException securityDomainMismatch() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), securityDomainMismatch$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotObtainCredentialFromFactory = "ELY01156: Cannot obtain a credential from a security factory";
    protected String cannotObtainCredentialFromFactory$str() {
        return cannotObtainCredentialFromFactory;
    }
    @Override
    public final IOException cannotObtainCredentialFromFactory(final GeneralSecurityException e) {
        final IOException result = new IOException(String.format(getLoggingLocale(), cannotObtainCredentialFromFactory$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void eventHandlerFailed(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, eventHandlerFailed$str());
    }
    private static final String eventHandlerFailed = "ELY01094: An event handler threw an exception";
    protected String eventHandlerFailed$str() {
        return eventHandlerFailed;
    }
    private static final String roleMappedAlreadyInitialized = "ELY08510: Role mapper has already been initialized.";
    protected String roleMappedAlreadyInitialized$str() {
        return roleMappedAlreadyInitialized;
    }
    @Override
    public final IllegalStateException roleMappedAlreadyInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), roleMappedAlreadyInitialized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String roleMappedNotInitialized = "ELY08511: Role mapper hasn't been initialized yet.";
    protected String roleMappedNotInitialized$str() {
        return roleMappedNotInitialized;
    }
    @Override
    public final IllegalStateException roleMappedNotInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), roleMappedNotInitialized$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
