/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Locale;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.ssl.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String warnInvalidStringCountForMechanismDatabaseEntry = "ELY01066: Invalid string count for mechanism database entry \"%s\"";
    private static final String warnInvalidKeyExchangeForMechanismDatabaseEntry = "ELY01067: Invalid key exchange \"%s\" for mechanism database entry \"%s\"";
    private static final String warnInvalidAuthenticationForMechanismDatabaseEntry = "ELY01068: Invalid authentication \"%s\" for mechanism database entry \"%s\"";
    private static final String warnInvalidEncryptionForMechanismDatabaseEntry = "ELY01069: Invalid encryption \"%s\" for mechanism database entry \"%s\"";
    private static final String warnInvalidDigestForMechanismDatabaseEntry = "ELY01070: Invalid digest \"%s\" for mechanism database entry \"%s\"";
    private static final String warnInvalidProtocolForMechanismDatabaseEntry = "ELY01071: Invalid protocol \"%s\" for mechanism database entry \"%s\"";
    private static final String warnInvalidLevelForMechanismDatabaseEntry = "ELY01072: Invalid level \"%s\" for mechanism database entry \"%s\"";
    private static final String warnInvalidStrengthBitsForMechanismDatabaseEntry = "ELY01073: Invalid strength bits \"%s\" for mechanism database entry \"%s\"";
    private static final String warnInvalidAlgorithmBitsForMechanismDatabaseEntry = "ELY01074: Invalid algorithm bits \"%s\" for mechanism database entry \"%s\"";
    private static final String warnInvalidDuplicateMechanismDatabaseEntry = "ELY01075: Invalid duplicate mechanism database entry \"%s\"";
    private static final String warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry = "ELY01076: Invalid duplicate OpenSSL-style alias \"%s\" for mechanism database entry \"%s\" (original is \"%s\")";
    private static final String warnInvalidAliasForMissingMechanismDatabaseEntry = "ELY01077: Invalid alias \"%s\" for missing mechanism database entry \"%s\"";
    private static final String noAlgorithmForSslProtocol = "ELY04001: No algorithm found matching TLS/SSL protocol selection criteria";
    private static final String emptyChainNotTrusted = "ELY04002: Empty certificate chain is not trusted";
    private static final String notTrustedRealmProblem = "ELY04003: Certificate not trusted due to realm failure for principal [%s]";
    private static final String notTrusted = "ELY04004: Credential validation failed: certificate is not trusted for principal [%s]";
    private static final String noDefaultTrustManager = "ELY04005: No default trust manager available";
    private static final String noContextForSslConnection = "ELY04006: No context for SSL connection";
    private static final String sslClosed = "ELY04007: SSL channel is closed";
    private static final String notHandshakeRecord = "ELY04008: Initial SSL/TLS data is not a handshake record";
    private static final String invalidHandshakeRecord = "ELY04009: Initial SSL/TLS handshake record is invalid";
    private static final String multiRecordSSLHandshake = "ELY04010: Initial SSL/TLS handshake spans multiple records";
    private static final String expectedClientHello = "ELY04011: Expected \"client hello\" record";
    private static final String unsupportedSslRecord = "ELY04012: Unsupported SSL/TLS record";
    private static final String invalidTlsExt = "ELY04013: Invalid TLS extension data";
    private static final String notEnoughData = "ELY04014: Not enough data in record to fill declared item size";
    private static final String emptyHostNameSni = "ELY04015: Empty host name in SNI record data";
    private static final String duplicatedSniServerName = "ELY04016: Duplicated SNI server name of type %d";
    private static final String unknownAuthenticationName = "ELY04017: Unknown authentication name \"%s\"";
    private static final String unknownEncryptionName = "ELY04018: Unknown encryption name \"%s\"";
    private static final String unknownKeyExchangeName = "ELY04019: Unknown key exchange name \"%s\"";
    private static final String invalidClientMode = "ELY04024: Invalid client mode, expected %s, got %s";
    private static final String sslErrorCreatingTrustManager = "ELY04026: Could not create trust manager [%s]";
    private static final String securityDomainOfSSLContextDoesNotSupportX509 = "ELY04027: SecurityDomain of SSLContext does not support X509PeerCertificateChainEvidence verification";
    private static final String defaultContextCannotBeNull = "ELY04029: Default context cannot be null";
    private static final String noSNIContextForSslConnection = "ELY04030: No context for SSL connection";
    private static final String mechSelectorUnexpectedChar = "ELY05015: Unexpected character U+%04x at offset %d of mechanism selection string \"%s\"";
    private static final String mechSelectorUnknownToken = "ELY05016: Unrecognized token \"%s\" in mechanism selection string \"%s\"";
    private static final String mechSelectorTokenNotAllowed = "ELY05017: Token \"%s\" not allowed at offset %d of mechanism selection string \"%s\"";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void warnInvalidStringCountForMechanismDatabaseEntry(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidStringCountForMechanismDatabaseEntry$str(), (Object)name);
    }

    protected String warnInvalidStringCountForMechanismDatabaseEntry$str() {
        return warnInvalidStringCountForMechanismDatabaseEntry;
    }

    @Override
    public final void warnInvalidKeyExchangeForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidKeyExchangeForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidKeyExchangeForMechanismDatabaseEntry$str() {
        return warnInvalidKeyExchangeForMechanismDatabaseEntry;
    }

    @Override
    public final void warnInvalidAuthenticationForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidAuthenticationForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidAuthenticationForMechanismDatabaseEntry$str() {
        return warnInvalidAuthenticationForMechanismDatabaseEntry;
    }

    @Override
    public final void warnInvalidEncryptionForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidEncryptionForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidEncryptionForMechanismDatabaseEntry$str() {
        return warnInvalidEncryptionForMechanismDatabaseEntry;
    }

    @Override
    public final void warnInvalidDigestForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidDigestForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidDigestForMechanismDatabaseEntry$str() {
        return warnInvalidDigestForMechanismDatabaseEntry;
    }

    @Override
    public final void warnInvalidProtocolForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidProtocolForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidProtocolForMechanismDatabaseEntry$str() {
        return warnInvalidProtocolForMechanismDatabaseEntry;
    }

    @Override
    public final void warnInvalidLevelForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidLevelForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidLevelForMechanismDatabaseEntry$str() {
        return warnInvalidLevelForMechanismDatabaseEntry;
    }

    @Override
    public final void warnInvalidStrengthBitsForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidStrengthBitsForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidStrengthBitsForMechanismDatabaseEntry$str() {
        return warnInvalidStrengthBitsForMechanismDatabaseEntry;
    }

    @Override
    public final void warnInvalidAlgorithmBitsForMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidAlgorithmBitsForMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidAlgorithmBitsForMechanismDatabaseEntry$str() {
        return warnInvalidAlgorithmBitsForMechanismDatabaseEntry;
    }

    @Override
    public final void warnInvalidDuplicateMechanismDatabaseEntry(String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidDuplicateMechanismDatabaseEntry$str(), (Object)name);
    }

    protected String warnInvalidDuplicateMechanismDatabaseEntry$str() {
        return warnInvalidDuplicateMechanismDatabaseEntry;
    }

    @Override
    public final void warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry(String alias, String name, String originalName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry$str(), (Object)alias, (Object)name, (Object)originalName);
    }

    protected String warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry$str() {
        return warnInvalidDuplicateOpenSslStyleAliasForMechanismDatabaseEntry;
    }

    @Override
    public final void warnInvalidAliasForMissingMechanismDatabaseEntry(String value, String name) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidAliasForMissingMechanismDatabaseEntry$str(), (Object)value, (Object)name);
    }

    protected String warnInvalidAliasForMissingMechanismDatabaseEntry$str() {
        return warnInvalidAliasForMissingMechanismDatabaseEntry;
    }

    protected String noAlgorithmForSslProtocol$str() {
        return noAlgorithmForSslProtocol;
    }

    @Override
    public final NoSuchAlgorithmException noAlgorithmForSslProtocol() {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noAlgorithmForSslProtocol$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String emptyChainNotTrusted$str() {
        return emptyChainNotTrusted;
    }

    @Override
    public final CertificateException emptyChainNotTrusted() {
        CertificateException result = new CertificateException(String.format(this.getLoggingLocale(), this.emptyChainNotTrusted$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notTrustedRealmProblem$str() {
        return notTrustedRealmProblem;
    }

    @Override
    public final CertificateException notTrustedRealmProblem(RealmUnavailableException e, Principal principal) {
        CertificateException result = new CertificateException(String.format(this.getLoggingLocale(), this.notTrustedRealmProblem$str(), principal), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notTrusted$str() {
        return notTrusted;
    }

    @Override
    public final CertificateException notTrusted(Principal principal) {
        CertificateException result = new CertificateException(String.format(this.getLoggingLocale(), this.notTrusted$str(), principal));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noDefaultTrustManager$str() {
        return noDefaultTrustManager;
    }

    @Override
    public final NoSuchAlgorithmException noDefaultTrustManager() {
        NoSuchAlgorithmException result = new NoSuchAlgorithmException(String.format(this.getLoggingLocale(), this.noDefaultTrustManager$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noContextForSslConnection$str() {
        return noContextForSslConnection;
    }

    @Override
    public final SSLHandshakeException noContextForSslConnection() {
        SSLHandshakeException result = new SSLHandshakeException(String.format(this.getLoggingLocale(), this.noContextForSslConnection$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sslClosed$str() {
        return sslClosed;
    }

    @Override
    public final SSLException sslClosed() {
        SSLException result = new SSLException(String.format(this.getLoggingLocale(), this.sslClosed$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notHandshakeRecord$str() {
        return notHandshakeRecord;
    }

    @Override
    public final SSLHandshakeException notHandshakeRecord() {
        SSLHandshakeException result = new SSLHandshakeException(String.format(this.getLoggingLocale(), this.notHandshakeRecord$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidHandshakeRecord$str() {
        return invalidHandshakeRecord;
    }

    @Override
    public final SSLHandshakeException invalidHandshakeRecord() {
        SSLHandshakeException result = new SSLHandshakeException(String.format(this.getLoggingLocale(), this.invalidHandshakeRecord$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multiRecordSSLHandshake$str() {
        return multiRecordSSLHandshake;
    }

    @Override
    public final SSLHandshakeException multiRecordSSLHandshake() {
        SSLHandshakeException result = new SSLHandshakeException(String.format(this.getLoggingLocale(), this.multiRecordSSLHandshake$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String expectedClientHello$str() {
        return expectedClientHello;
    }

    @Override
    public final SSLHandshakeException expectedClientHello() {
        SSLHandshakeException result = new SSLHandshakeException(String.format(this.getLoggingLocale(), this.expectedClientHello$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedSslRecord$str() {
        return unsupportedSslRecord;
    }

    @Override
    public final SSLHandshakeException unsupportedSslRecord() {
        SSLHandshakeException result = new SSLHandshakeException(String.format(this.getLoggingLocale(), this.unsupportedSslRecord$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidTlsExt$str() {
        return invalidTlsExt;
    }

    @Override
    public final SSLProtocolException invalidTlsExt() {
        SSLProtocolException result = new SSLProtocolException(String.format(this.getLoggingLocale(), this.invalidTlsExt$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notEnoughData$str() {
        return notEnoughData;
    }

    @Override
    public final SSLProtocolException notEnoughData() {
        SSLProtocolException result = new SSLProtocolException(String.format(this.getLoggingLocale(), this.notEnoughData$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String emptyHostNameSni$str() {
        return emptyHostNameSni;
    }

    @Override
    public final SSLProtocolException emptyHostNameSni() {
        SSLProtocolException result = new SSLProtocolException(String.format(this.getLoggingLocale(), this.emptyHostNameSni$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicatedSniServerName$str() {
        return duplicatedSniServerName;
    }

    @Override
    public final SSLProtocolException duplicatedSniServerName(int type) {
        SSLProtocolException result = new SSLProtocolException(String.format(this.getLoggingLocale(), this.duplicatedSniServerName$str(), type));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAuthenticationName$str() {
        return unknownAuthenticationName;
    }

    @Override
    public final IllegalArgumentException unknownAuthenticationName(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownAuthenticationName$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownEncryptionName$str() {
        return unknownEncryptionName;
    }

    @Override
    public final IllegalArgumentException unknownEncryptionName(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownEncryptionName$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownKeyExchangeName$str() {
        return unknownKeyExchangeName;
    }

    @Override
    public final IllegalArgumentException unknownKeyExchangeName(String name) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.unknownKeyExchangeName$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidClientMode$str() {
        return invalidClientMode;
    }

    @Override
    public final IllegalArgumentException invalidClientMode(boolean expectedMode, boolean givenMode) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidClientMode$str(), expectedMode, givenMode));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String sslErrorCreatingTrustManager$str() {
        return sslErrorCreatingTrustManager;
    }

    @Override
    public final IllegalStateException sslErrorCreatingTrustManager(String name, Throwable cause) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.sslErrorCreatingTrustManager$str(), name), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String securityDomainOfSSLContextDoesNotSupportX509$str() {
        return securityDomainOfSSLContextDoesNotSupportX509;
    }

    @Override
    public final IllegalArgumentException securityDomainOfSSLContextDoesNotSupportX509() {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.securityDomainOfSSLContextDoesNotSupportX509$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String defaultContextCannotBeNull$str() {
        return defaultContextCannotBeNull;
    }

    @Override
    public final IllegalStateException defaultContextCannotBeNull() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.defaultContextCannotBeNull$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noSNIContextForSslConnection$str() {
        return noSNIContextForSslConnection;
    }

    @Override
    public final SSLException noSNIContextForSslConnection() {
        SSLException result = new SSLException(String.format(this.getLoggingLocale(), this.noSNIContextForSslConnection$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechSelectorUnexpectedChar$str() {
        return mechSelectorUnexpectedChar;
    }

    @Override
    public final IllegalArgumentException mechSelectorUnexpectedChar(int codePoint, long offset, String string) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mechSelectorUnexpectedChar$str(), codePoint, offset, string));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechSelectorUnknownToken$str() {
        return mechSelectorUnknownToken;
    }

    @Override
    public final IllegalArgumentException mechSelectorUnknownToken(String word, String string) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mechSelectorUnknownToken$str(), word, string));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String mechSelectorTokenNotAllowed$str() {
        return mechSelectorTokenNotAllowed;
    }

    @Override
    public final IllegalArgumentException mechSelectorTokenNotAllowed(String token, long offset, String string) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.mechSelectorTokenNotAllowed$str(), token, offset, string));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

