/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.authz.RoleDecoder;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.authz.SourceAddressRoleDecoder;
import org.wildfly.security.permission.PermissionVerifier;

public class SourceAddressRuntimeAttributesTest {
    @Test
    public void testRoleDecodingWithSourceAddressMatch() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = this.createSecurityRealm();
        String sourceAddress = "10.12.14.16";
        SourceAddressRoleDecoder roleDecoder = new SourceAddressRoleDecoder(sourceAddress, Roles.of((String)"Admin"));
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> roles.contains("Admin") ? LoginPermission.getInstance() : PermissionVerifier.NONE).setRoleDecoder((RoleDecoder)roleDecoder).build();
        ServerAuthenticationContext sac = securityDomain.createNewAuthenticationContext();
        sac.setAuthenticationName("bob");
        Assert.assertFalse((boolean)sac.authorize());
        sac = securityDomain.createNewAuthenticationContext();
        sac.addRuntimeAttributes(this.createRuntimeAttributes(sourceAddress));
        sac.setAuthenticationName("bob");
        Assert.assertTrue((boolean)sac.authorize());
        sac = securityDomain.createNewAuthenticationContext();
        sac.addRuntimeAttributes(this.createRuntimeAttributes(null));
        sac.setAuthenticationName("bob");
        Assert.assertFalse((boolean)sac.authorize());
        sac = securityDomain.createNewAuthenticationContext();
        sac.setAuthenticationName("alice");
        Assert.assertTrue((boolean)sac.authorize());
        sac = securityDomain.createNewAuthenticationContext();
        sac.addRuntimeAttributes(this.createRuntimeAttributes(sourceAddress));
        sac.setAuthenticationName("alice");
        Assert.assertTrue((boolean)sac.authorize());
        sac = securityDomain.createNewAuthenticationContext();
        sac.addRuntimeAttributes(this.createRuntimeAttributes(null));
        sac.setAuthenticationName("alice");
        Assert.assertTrue((boolean)sac.authorize());
    }

    @Test
    public void testRoleDecodingWithSourceAddressMismatch() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = this.createSecurityRealm();
        String sourceAddress = "10.12.14.16";
        SourceAddressRoleDecoder roleDecoder = new SourceAddressRoleDecoder(sourceAddress, Roles.of((String)"Admin"));
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> roles.contains("Admin") ? LoginPermission.getInstance() : PermissionVerifier.NONE).setRoleDecoder((RoleDecoder)roleDecoder).build();
        ServerAuthenticationContext sac = securityDomain.createNewAuthenticationContext();
        sac.setAuthenticationName("bob");
        Assert.assertFalse((boolean)sac.authorize());
        sac = securityDomain.createNewAuthenticationContext();
        sac.addRuntimeAttributes(this.createRuntimeAttributes("10.12.16.16"));
        sac.setAuthenticationName("bob");
        Assert.assertFalse((boolean)sac.authorize());
        sac = securityDomain.createNewAuthenticationContext();
        sac.setAuthenticationName("alice");
        Assert.assertTrue((boolean)sac.authorize());
        sac = securityDomain.createNewAuthenticationContext();
        sac.addRuntimeAttributes(this.createRuntimeAttributes("10.12.16.16"));
        sac.setAuthenticationName("alice");
        Assert.assertTrue((boolean)sac.authorize());
    }

    private FileSystemSecurityRealm createSecurityRealm() throws Exception {
        FileSystemSecurityRealm realm = new FileSystemSecurityRealm(this.getRootPath(true));
        this.addUser((ModifiableSecurityRealm)realm, "alice", "Admin");
        this.addUser((ModifiableSecurityRealm)realm, "bob", "Employee");
        return realm;
    }

    private Path getRootPath(boolean deleteIfExists) throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource(File.separator).toURI()).resolve("filesystem-realm");
        if (rootPath.toFile().exists() && !deleteIfExists) {
            return rootPath;
        }
        return Files.walkFileTree(Files.createDirectories(rootPath, new FileAttribute[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void addUser(ModifiableSecurityRealm realm, String userName, String roles) throws RealmUnavailableException {
        MapAttributes attributes = new MapAttributes();
        attributes.addAll("Roles", Collections.singletonList(roles));
        ModifiableRealmIdentity realmIdentity = realm.getRealmIdentityForUpdate((Principal)new NamePrincipal(userName));
        realmIdentity.create();
        realmIdentity.setAttributes((Attributes)attributes);
        realmIdentity.dispose();
    }

    private Attributes createRuntimeAttributes(String actualSourceAddress) {
        MapAttributes runtimeAttributes = new MapAttributes();
        if (actualSourceAddress != null) {
            runtimeAttributes.addFirst("Source-Address", actualSourceAddress);
        }
        return runtimeAttributes;
    }
}

