/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.apacheds;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.api.ldap.model.password.PasswordUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.interfaces.UnixDESCryptPassword;
import org.wildfly.security.password.util.ModularCrypt;

public class CryptCompatibilityTest {
    private static final Provider provider = WildFlyElytronPasswordProvider.getInstance();
    private static final String PASSWORD = "cryptIt";
    private static final String LONG_PASSWORD = "cryptPassword";

    @BeforeClass
    public static void register() {
        Security.addProvider(provider);
    }

    @AfterClass
    public static void remove() {
        Security.removeProvider(provider.getName());
    }

    @Test
    public void testComparison() throws InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException {
        byte[] forStorage = PasswordUtil.createStoragePassword((byte[])PASSWORD.getBytes(StandardCharsets.UTF_8), (LdapSecurityConstants)LdapSecurityConstants.HASH_METHOD_CRYPT);
        System.out.println(new String(forStorage, StandardCharsets.UTF_8));
        UnixDESCryptPassword testPass = (UnixDESCryptPassword)ModularCrypt.createPassword((byte[])forStorage, (String)"crypt-des");
        PasswordFactory pf = PasswordFactory.getInstance((String)"crypt-des");
        Assert.assertTrue((boolean)pf.verify(pf.translate((Password)testPass), PASSWORD.toCharArray()));
        System.out.println("Have something split out.");
    }

    @Test
    public void testComparisonWithLongPassword() throws InvalidKeySpecException, NoSuchAlgorithmException, InvalidKeyException {
        byte[] forStorage = PasswordUtil.createStoragePassword((byte[])LONG_PASSWORD.getBytes(StandardCharsets.UTF_8), (LdapSecurityConstants)LdapSecurityConstants.HASH_METHOD_CRYPT);
        System.out.println(new String(forStorage, StandardCharsets.UTF_8));
        UnixDESCryptPassword testPass = (UnixDESCryptPassword)ModularCrypt.createPassword((byte[])forStorage, (String)"crypt-des");
        PasswordFactory pf = PasswordFactory.getInstance((String)"crypt-des");
        Assert.assertTrue((boolean)pf.verify(pf.translate((Password)testPass), LONG_PASSWORD.toCharArray()));
    }
}

