/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.keystore;

import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.function.Predicate;
import javax.security.auth.x500.X500Principal;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.keystore.AliasFilter;
import org.wildfly.security.keystore.FilteringKeyStore;
import org.wildfly.security.x500.cert.SelfSignedX509CertificateAndSigningKey;

public class FilteringKeyStoreTest {
    private static KeyStore baseKeyStore;
    private static final char[] PASSWORD;

    private static void createFilteredKeyStore(KeyStore filteredKeyStore) throws Exception {
        X500Principal DN = new X500Principal("CN=Elytron, OU=Elytron, O=Elytron, L=Elytron, ST=Elytron, C=GB");
        SelfSignedX509CertificateAndSigningKey selfSignedX509CertificateAndSigningKey = SelfSignedX509CertificateAndSigningKey.builder().setDn(DN).setKeyAlgorithmName("RSA").setSignatureAlgorithmName("SHA256withRSA").build();
        X509Certificate certificate = selfSignedX509CertificateAndSigningKey.getSelfSignedCertificate();
        filteredKeyStore.setKeyEntry("alias1", selfSignedX509CertificateAndSigningKey.getSigningKey(), PASSWORD, new X509Certificate[]{certificate});
        filteredKeyStore.setKeyEntry("alias2", selfSignedX509CertificateAndSigningKey.getSigningKey(), PASSWORD, new X509Certificate[]{certificate});
        filteredKeyStore.setKeyEntry("alias3", selfSignedX509CertificateAndSigningKey.getSigningKey(), PASSWORD, new X509Certificate[]{certificate});
        filteredKeyStore.setKeyEntry("alias4", selfSignedX509CertificateAndSigningKey.getSigningKey(), PASSWORD, new X509Certificate[]{certificate});
    }

    @BeforeClass
    public static void setUp() throws Exception {
        baseKeyStore = KeyStore.getInstance("JKS");
        baseKeyStore.load(null, null);
        FilteringKeyStoreTest.createFilteredKeyStore(baseKeyStore);
    }

    public void performTest(Predicate<String> aliasPredicate, String ... expectedAlias) throws Exception {
        HashSet<String> expectedSet = new HashSet<String>(Arrays.asList(expectedAlias));
        Enumeration<String> baseAliases = baseKeyStore.aliases();
        Assert.assertEquals((String)"Base KeyStore Alias Count", (long)4L, (long)baseKeyStore.size());
        while (baseAliases.hasMoreElements()) {
            String currentAlias = baseAliases.nextElement();
            System.out.println("Testing Alias " + currentAlias);
            Assert.assertEquals((String)String.format("Alias '%s'", currentAlias), (Object)expectedSet.contains(currentAlias), (Object)aliasPredicate.test(currentAlias));
        }
        KeyStore testStore = FilteringKeyStore.filteringKeyStore((KeyStore)baseKeyStore, aliasPredicate);
        Assert.assertEquals((String)"Expected number of aliases", (long)expectedSet.size(), (long)testStore.size());
        baseAliases = baseKeyStore.aliases();
        while (baseAliases.hasMoreElements()) {
            String currentAlias = baseAliases.nextElement();
            Assert.assertEquals((String)String.format("Alias '%s'", currentAlias), (Object)expectedSet.contains(currentAlias), (Object)testStore.containsAlias(currentAlias));
        }
    }

    @Test
    public void testAll() throws Exception {
        this.performTest((Predicate<String>)AliasFilter.ALL, "alias1", "alias2", "alias3", "alias4");
    }

    @Test
    public void testAllFilter() throws Exception {
        this.performTest((Predicate<String>)AliasFilter.fromString((String)"ALL"), "alias1", "alias2", "alias3", "alias4");
    }

    @Test
    public void testCommaFilter() throws Exception {
        this.performTest((Predicate<String>)AliasFilter.fromString((String)"alias1,alias2,alias3"), "alias1", "alias2", "alias3");
    }

    @Test
    public void testAllMinusOne() throws Exception {
        this.performTest((Predicate<String>)AliasFilter.ALL.remove("alias4"), "alias1", "alias2", "alias3");
    }

    @Test
    public void testAllMinusOneFilter() throws Exception {
        this.performTest((Predicate<String>)AliasFilter.fromString((String)"ALL:-alias4"), "alias1", "alias2", "alias3");
    }

    @Test
    public void testNone() throws Exception {
        this.performTest((Predicate<String>)AliasFilter.NONE, new String[0]);
    }

    @Test
    public void testNoneFilter() throws Exception {
        this.performTest((Predicate<String>)AliasFilter.fromString((String)"NONE"), new String[0]);
    }

    @Test
    public void testNonePlusOne() throws Exception {
        this.performTest((Predicate<String>)AliasFilter.NONE.add("alias2"), "alias2");
    }

    @Test
    public void testNonePlusOneFilter() throws Exception {
        this.performTest((Predicate<String>)AliasFilter.fromString((String)"NONE:+alias2"), "alias2");
    }

    @Test
    public void testJustOneFilter() throws Exception {
        this.performTest((Predicate<String>)AliasFilter.fromString((String)"alias2"), "alias2");
    }

    @Test
    public void testAmbiguousFilter() throws Exception {
        this.performTest((Predicate<String>)AliasFilter.fromString((String)"ALL:-alias4:+alias4"), "alias1", "alias2", "alias3", "alias4");
    }

    static {
        PASSWORD = "Elytron".toCharArray();
    }
}

