/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.gssapi;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;

public class JaasUtil {
    private static Logger log = Logger.getLogger(JaasUtil.class);
    private static final boolean IS_IBM = System.getProperty("java.vendor").contains("IBM");

    public static Subject loginClient() throws LoginException {
        log.debug((Object)"loginClient");
        return JaasUtil.login("jduke", "theduke".toCharArray(), false, null);
    }

    public static Subject loginServer(String keyTabFile, boolean unbound) throws LoginException {
        log.debug((Object)"loginServer");
        return JaasUtil.login(unbound ? "*" : "sasl/test_server_1", "servicepwd".toCharArray(), true, keyTabFile);
    }

    static Subject login(String userName, char[] password, boolean server, String keyTabFile) throws LoginException {
        Subject theSubject = new Subject();
        UsernamePasswordCBH cbh = new UsernamePasswordCBH(userName, password);
        Configuration config = server ? JaasUtil.createGssProxyConfiguration(userName, keyTabFile) : JaasUtil.createJaasConfiguration(false);
        LoginContext lc = new LoginContext("KDC", theSubject, cbh, config);
        lc.login();
        return theSubject;
    }

    private static Configuration createJaasConfiguration(final boolean server) {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                if (!"KDC".equals(name)) {
                    throw new IllegalArgumentException(String.format("Unexpected name '%s'", name));
                }
                AppConfigurationEntry[] entries = new AppConfigurationEntry[1];
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("debug", "true");
                options.put("refreshKrb5Config", "true");
                if (IS_IBM) {
                    options.put("noAddress", "true");
                    options.put("credsType", server ? "acceptor" : "initiator");
                    entries[0] = new AppConfigurationEntry("com.ibm.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                } else {
                    options.put("storeKey", "true");
                    options.put("isInitiator", server ? "false" : "true");
                    entries[0] = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                }
                return entries;
            }
        };
    }

    private static Configuration createGssProxyConfiguration(final String principal, final String keyTabFile) {
        return new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                if (!"KDC".equals(name)) {
                    throw new IllegalArgumentException(String.format("Unexpected name '%s'", name));
                }
                AppConfigurationEntry[] entries = new AppConfigurationEntry[1];
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("debug", "true");
                options.put("refreshKrb5Config", "true");
                options.put("principal", principal);
                if (IS_IBM) {
                    options.put("useKeytab", keyTabFile);
                    options.put("noAddress", "true");
                    options.put("credsType", "acceptor");
                    entries[0] = new AppConfigurationEntry("com.ibm.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                } else {
                    options.put("useKeyTab", "true");
                    options.put("keyTab", keyTabFile);
                    options.put("doNotPrompt", "true");
                    options.put("storeKey", "true");
                    options.put("isInitiator", "false");
                    entries[0] = new AppConfigurationEntry("com.sun.security.auth.module.Krb5LoginModule", AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                }
                return entries;
            }
        };
    }

    private static class UsernamePasswordCBH
    implements CallbackHandler {
        private final String username;
        private final char[] password;

        private UsernamePasswordCBH(String username, char[] password) {
            this.username = username;
            this.password = password;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (current instanceof NameCallback) {
                    NameCallback ncb = (NameCallback)current;
                    ncb.setName(this.username);
                    continue;
                }
                if (current instanceof PasswordCallback) {
                    PasswordCallback pcb = (PasswordCallback)current;
                    pcb.setPassword(this.password);
                    continue;
                }
                throw new UnsupportedCallbackException(current);
            }
        }
    }
}

