/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.realm.cache;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.CacheableSecurityRealm;
import org.wildfly.security.auth.realm.CachingModifiableSecurityRealm;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableRealmIdentityIterator;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.server.ServerUtils;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.cache.LRURealmIdentityCache;
import org.wildfly.security.cache.RealmIdentityCache;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.Encoding;

public class ModifiableSecurityRealmIdentityCacheTest {
    private AtomicInteger realmHitCount = new AtomicInteger();

    @Test
    public void testInvalidateEntryAfterChangingAttributes() throws Exception {
        ModifiableSecurityRealm securityRealm = this.createSecurityRealm();
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)securityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        SecurityIdentity securityIdentity = this.assertAuthenticationAndAuthorization("joe", "password", securityDomain);
        Assert.assertTrue((boolean)securityIdentity.getAttributes().get("someAttribute").isEmpty());
        Assert.assertEquals((long)1L, (long)this.realmHitCount.get());
        ModifiableRealmIdentity joe = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("joe"));
        MapAttributes newAttributes = new MapAttributes();
        newAttributes.addFirst("someAttribute", "value");
        joe.setAttributes((Attributes)newAttributes);
        joe.dispose();
        securityIdentity = this.assertAuthenticationAndAuthorization("joe", "password", securityDomain);
        Assert.assertEquals((long)2L, (long)this.realmHitCount.get());
        Assert.assertFalse((boolean)securityIdentity.getAttributes().get("someAttribute").isEmpty());
    }

    @Test
    public void testInvalidateEntryAfterChangingCredentials() throws Exception {
        List<PasswordCredential> credentials;
        ModifiableSecurityRealm securityRealm = this.createSecurityRealm();
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)securityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        this.assertAuthenticationAndAuthorization("joe", "password", securityDomain);
        Assert.assertEquals((long)1L, (long)this.realmHitCount.get());
        ModifiableRealmIdentity joe = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("joe"));
        try {
            credentials = Collections.singletonList(new PasswordCredential(PasswordFactory.getInstance((String)"clear", ServerUtils.ELYTRON_PASSWORD_PROVIDERS).generatePassword((KeySpec)new ClearPasswordSpec("password_changed".toCharArray()))));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        joe.setCredentials(credentials);
        joe.dispose();
        this.assertAuthenticationAndAuthorization("joe", "password_changed", securityDomain);
        Assert.assertEquals((long)2L, (long)this.realmHitCount.get());
    }

    @Test
    public void testInvalidateEntryAfterChangingCredentialsFromIterator() throws Exception {
        List<PasswordCredential> credentials;
        ModifiableSecurityRealm securityRealm = this.createSecurityRealm();
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)securityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        this.assertAuthenticationAndAuthorization("joe", "password", securityDomain);
        Assert.assertEquals((long)1L, (long)this.realmHitCount.get());
        ModifiableRealmIdentityIterator iterator = securityRealm.getRealmIdentityIterator();
        ModifiableRealmIdentity joe = (ModifiableRealmIdentity)iterator.next();
        try {
            credentials = Collections.singletonList(new PasswordCredential(PasswordFactory.getInstance((String)"clear", ServerUtils.ELYTRON_PASSWORD_PROVIDERS).generatePassword((KeySpec)new ClearPasswordSpec("password_changed".toCharArray()))));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        joe.setCredentials(credentials);
        joe.dispose();
        this.assertAuthenticationAndAuthorization("joe", "password_changed", securityDomain);
        Assert.assertEquals((long)2L, (long)this.realmHitCount.get());
    }

    private ModifiableSecurityRealm createSecurityRealm() throws Exception {
        FileSystemSecurityRealm realm = new FileSystemSecurityRealm(this.getRootPath(true), NameRewriter.IDENTITY_REWRITER, 2, true, Encoding.BASE64, StandardCharsets.UTF_8, ServerUtils.ELYTRON_PASSWORD_PROVIDERS, null);
        this.addUser((ModifiableSecurityRealm)realm, "joe", "User");
        return new CachingModifiableSecurityRealm((CacheableSecurityRealm)new MockCacheableModifiableSecurityRealm(realm), this.createRealmIdentitySimpleJavaMapCache(), ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
    }

    private void addUser(ModifiableSecurityRealm realm, String userName, String roles) throws RealmUnavailableException {
        List<PasswordCredential> credentials;
        try {
            credentials = Collections.singletonList(new PasswordCredential(PasswordFactory.getInstance((String)"clear", ServerUtils.ELYTRON_PASSWORD_PROVIDERS).generatePassword((KeySpec)new ClearPasswordSpec("password".toCharArray()))));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MapAttributes attributes = new MapAttributes();
        attributes.addAll("Roles", Collections.singletonList(roles));
        ModifiableRealmIdentity realmIdentity = realm.getRealmIdentityForUpdate((Principal)new NamePrincipal(userName));
        realmIdentity.create();
        realmIdentity.setAttributes((Attributes)attributes);
        realmIdentity.setCredentials(credentials);
        realmIdentity.dispose();
    }

    private SecurityIdentity assertAuthenticationAndAuthorization(String username, String password, SecurityDomain securityDomain) throws Exception {
        ServerAuthenticationContext sac = securityDomain.createNewAuthenticationContext();
        sac.setAuthenticationName(username);
        Assert.assertTrue((boolean)sac.verifyEvidence((Evidence)new PasswordGuessEvidence(password.toCharArray())));
        Assert.assertTrue((boolean)sac.authorize(username));
        sac.succeed();
        SecurityIdentity securityIdentity = sac.getAuthorizedIdentity();
        Assert.assertNotNull((Object)securityIdentity);
        Assert.assertEquals((Object)username, (Object)securityIdentity.getPrincipal().getName());
        return securityIdentity;
    }

    private RealmIdentityCache createRealmIdentitySimpleJavaMapCache() {
        return new LRURealmIdentityCache(16);
    }

    private Path getRootPath(boolean deleteIfExists) throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource(File.separator).toURI()).resolve("filesystem-realm-cache");
        boolean exists = rootPath.toFile().exists();
        if (exists) {
            if (!deleteIfExists) {
                return rootPath;
            }
        } else {
            rootPath = Files.createDirectory(rootPath, new FileAttribute[0]);
        }
        return Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private class MockCacheableModifiableSecurityRealm
    implements ModifiableSecurityRealm,
    CacheableSecurityRealm {
        private final FileSystemSecurityRealm realm;

        public MockCacheableModifiableSecurityRealm(FileSystemSecurityRealm realm) {
            this.realm = realm;
        }

        public void registerIdentityChangeListener(Consumer<Principal> listener) {
            this.realm.registerIdentityChangeListener(listener);
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            ModifiableSecurityRealmIdentityCacheTest.this.realmHitCount.incrementAndGet();
            return this.realm.getRealmIdentity(principal);
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return this.realm.getCredentialAcquireSupport(credentialType, algorithmName, parameterSpec);
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return this.realm.getEvidenceVerifySupport(evidenceType, algorithmName);
        }

        public ModifiableRealmIdentity getRealmIdentityForUpdate(Principal principal) throws RealmUnavailableException {
            return this.realm.getRealmIdentityForUpdate(principal);
        }

        public ModifiableRealmIdentityIterator getRealmIdentityIterator() throws RealmUnavailableException {
            return this.realm.getRealmIdentityIterator();
        }
    }
}

