/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.digest;

import java.net.URI;
import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import mockit.integration.junit4.JMockit;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.security.http.HttpConstants;
import org.wildfly.security.http.HttpServerAuthenticationMechanism;
import org.wildfly.security.http.HttpServerRequest;
import org.wildfly.security.http.digest.WildFlyElytronHttpDigestProvider;
import org.wildfly.security.http.impl.AbstractBaseHttpTest;

@RunWith(value=JMockit.class)
public class DigestAuthenticationMechanismTest
extends AbstractBaseHttpTest {
    private static final Provider provider = WildFlyElytronHttpDigestProvider.getInstance();

    @BeforeClass
    public static void registerPasswordProvider() {
        Security.insertProviderAt(provider, 1);
    }

    @AfterClass
    public static void removePasswordProvider() {
        Security.removeProvider(provider.getName());
    }

    @Test
    public void testRfc2617() throws Exception {
        this.mockDigestNonce("AAAAAQABsxiWa25/kpFxsPCrpDCFsjkTzs/Xr7RPsi/VVN6faYp21Hia3h4=");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(HttpConstants.CONFIG_REALM, "testrealm@host.com");
        props.put("org.wildfly.security.http.validate-digest-uri", "false");
        HttpServerAuthenticationMechanism mechanism = this.digestFactory.createAuthenticationMechanism("DIGEST", props, this.getCallbackHandler("Mufasa", "testrealm@host.com", "Circle Of Life"));
        AbstractBaseHttpTest.TestingHttpServerRequest request1 = new AbstractBaseHttpTest.TestingHttpServerRequest(null);
        mechanism.evaluateRequest((HttpServerRequest)request1);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.NO_AUTH), (Object)((Object)request1.getResult()));
        AbstractBaseHttpTest.TestingHttpServerResponse response = request1.getResponse();
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"Digest realm=\"testrealm@host.com\", nonce=\"AAAAAQABsxiWa25/kpFxsPCrpDCFsjkTzs/Xr7RPsi/VVN6faYp21Hia3h4=\", opaque=\"00000000000000000000000000000000\", algorithm=MD5, qop=auth", (Object)response.getAuthenticateHeader());
        AbstractBaseHttpTest.TestingHttpServerRequest request2 = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[]{"Digest username=\"Mufasa\",\n                 realm=\"testrealm@host.com\",\n                 nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",\n                 uri=\"/dir/index.html\",\n                 qop=auth,\n                 nc=00000001,\n                 cnonce=\"0a4f113b\",\n                 response=\"6629fae49393a05397450978507c4ef1\",\n                 opaque=\"00000000000000000000000000000000\",\n                 algorithm=MD5"});
        mechanism.evaluateRequest((HttpServerRequest)request2);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)request2.getResult()));
    }

    @Test
    public void testRfc2617EncodedQuery() throws Exception {
        this.mockDigestNonce("AAAAAQABsxiWa25/kpFxsPCrpDCFsjkTzs/Xr7RPsi/VVN6faYp21Hia3h4=");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(HttpConstants.CONFIG_REALM, "testrealm@host.com");
        props.put("org.wildfly.security.http.validate-digest-uri", "true");
        HttpServerAuthenticationMechanism mechanism = this.digestFactory.createAuthenticationMechanism("DIGEST", props, this.getCallbackHandler("Mufasa", "testrealm@host.com", "Circle Of Life"));
        String path = "/dir/index.html?foo=b%2Fr";
        String uri = "http://localhost" + path;
        AbstractBaseHttpTest.TestingHttpServerRequest request2 = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[]{"Digest username=\"Mufasa\",\n                 realm=\"testrealm@host.com\",\n                 nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",\n                 uri=\"" + path + "\",\n                 qop=auth,\n                 nc=00000001,\n                 cnonce=\"0a4f113b\",\n                 response=\"9f4c595c275c13d41d65043d3a509abe\",\n                 opaque=\"00000000000000000000000000000000\",\n                 algorithm=MD5"}, new URI(uri));
        mechanism.evaluateRequest((HttpServerRequest)request2);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)request2.getResult()));
    }

    @Test
    public void testRfc2617EncodedPath() throws Exception {
        this.mockDigestNonce("AAAAAQABsxiWa25/kpFxsPCrpDCFsjkTzs/Xr7RPsi/VVN6faYp21Hia3h4=");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(HttpConstants.CONFIG_REALM, "testrealm@host.com");
        props.put("org.wildfly.security.http.validate-digest-uri", "true");
        HttpServerAuthenticationMechanism mechanism = this.digestFactory.createAuthenticationMechanism("DIGEST", props, this.getCallbackHandler("Mufasa", "testrealm@host.com", "Circle Of Life"));
        String path = "/dir/foo%2Fr/index.html?foo=b%2Fr";
        String uri = "http://localhost" + path;
        AbstractBaseHttpTest.TestingHttpServerRequest request2 = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[]{"Digest username=\"Mufasa\",\n                 realm=\"testrealm@host.com\",\n                 nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",\n                 uri=\"" + path + "\",\n                 qop=auth,\n                 nc=00000001,\n                 cnonce=\"0a4f113b\",\n                 response=\"cc3261565007973c9d647333822091ad\",\n                 opaque=\"00000000000000000000000000000000\",\n                 algorithm=MD5"}, new URI(uri));
        mechanism.evaluateRequest((HttpServerRequest)request2);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)request2.getResult()));
    }

    @Test
    public void testRfc7616sha256() throws Exception {
        this.mockDigestNonce("7ypf/xlj9XXwfDPEoM4URrv/xwf94BcCAzFZH4GiTo0v");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(HttpConstants.CONFIG_REALM, "http-auth@example.org");
        props.put("org.wildfly.security.http.validate-digest-uri", "false");
        HttpServerAuthenticationMechanism mechanism = this.digestFactory.createAuthenticationMechanism("DIGEST-SHA-256", props, this.getCallbackHandler("Mufasa", "http-auth@example.org", "Circle of Life"));
        AbstractBaseHttpTest.TestingHttpServerRequest request1 = new AbstractBaseHttpTest.TestingHttpServerRequest(null);
        mechanism.evaluateRequest((HttpServerRequest)request1);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.NO_AUTH), (Object)((Object)request1.getResult()));
        AbstractBaseHttpTest.TestingHttpServerResponse response = request1.getResponse();
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"Digest realm=\"http-auth@example.org\", nonce=\"7ypf/xlj9XXwfDPEoM4URrv/xwf94BcCAzFZH4GiTo0v\", opaque=\"00000000000000000000000000000000\", algorithm=SHA-256, qop=auth", (Object)response.getAuthenticateHeader());
        AbstractBaseHttpTest.TestingHttpServerRequest request2 = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[]{"Digest username=\"Mufasa\",\n       realm=\"http-auth@example.org\",\n       uri=\"/dir/index.html\",\n       algorithm=SHA-256,\n       nonce=\"7ypf/xlj9XXwfDPEoM4URrv/xwf94BcCAzFZH4GiTo0v\",\n       nc=00000001,\n       cnonce=\"f2/wE4q74E6zIJEtWaHKaf5wv/H5QzzpXusqGemxURZJ\",\n       qop=auth,\n       response=\"753927fa0e85d155564e2e272a28d1802ca10daf4496794697cf8db5856cb6c1\",\n       opaque=\"FQhe/qaU925kfnzjCev0ciny7QMkPqMAFRtzCUYo5tdS\""});
        mechanism.evaluateRequest((HttpServerRequest)request2);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)request2.getResult()));
    }

    @Test
    public void testSha512_256() throws Exception {
        this.mockDigestNonce("5TsQWLVdgBdmrQ0XsxbDODV+57QdFR34I9HAbC/RVvkK");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(HttpConstants.CONFIG_REALM, "api@example.org");
        props.put("org.wildfly.security.http.validate-digest-uri", "false");
        HttpServerAuthenticationMechanism mechanism = this.digestFactory.createAuthenticationMechanism("DIGEST-SHA-512-256", props, this.getCallbackHandler("J\u00e4s\u00f8n Doe", "api@example.org", "Secret, or not?"));
        AbstractBaseHttpTest.TestingHttpServerRequest request1 = new AbstractBaseHttpTest.TestingHttpServerRequest(null);
        mechanism.evaluateRequest((HttpServerRequest)request1);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.NO_AUTH), (Object)((Object)request1.getResult()));
        AbstractBaseHttpTest.TestingHttpServerResponse response = request1.getResponse();
        Assert.assertEquals((long)401L, (long)response.getStatusCode());
        Assert.assertEquals((Object)"Digest realm=\"api@example.org\", nonce=\"5TsQWLVdgBdmrQ0XsxbDODV+57QdFR34I9HAbC/RVvkK\", opaque=\"00000000000000000000000000000000\", algorithm=SHA-512-256, qop=auth", (Object)response.getAuthenticateHeader());
        AbstractBaseHttpTest.TestingHttpServerRequest request2 = new AbstractBaseHttpTest.TestingHttpServerRequest(new String[]{"Digest username*=UTF-8''J%C3%A4s%C3%B8n%20Doe,\n       realm=\"api@example.org\",\n       uri=\"/doe.json\",\n       algorithm=SHA-512-256,\n       nonce=\"5TsQWLVdgBdmrQ0XsxbDODV+57QdFR34I9HAbC/RVvkK\",\n       nc=00000001,\n       cnonce=\"NTg6RKcb9boFIAS3KrFK9BGeh+iDa/sm6jUMp2wds69v\",\n       qop=auth,\n       response=\"3798d4131c277846293534c3edc11bd8a5e4cdcbff78b05db9d95eeb1cec68a5\",\n       opaque=\"00000000000000000000000000000000\",\n       userhash=false"});
        mechanism.evaluateRequest((HttpServerRequest)request2);
        Assert.assertEquals((Object)((Object)AbstractBaseHttpTest.Status.COMPLETE), (Object)((Object)request2.getResult()));
    }
}

