/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.server.ServerUtils;
import org.wildfly.security.auth.util.RegexNameValidatingRewriter;

public class RegexNameValidatingRewriterTest {
    private static final String ANONYMOUS = "anonymous";
    private static final String MATCHING_USER_NAME = ".user.";
    private static final String NOT_MATCHING_USER_NAME = "user.";
    private Pattern pattern = Pattern.compile("^\\.[a-zA-Z0-9.-]+\\.$");

    @Test
    public void testMatchingRegexNameValidatingRewriter() {
        RegexNameValidatingRewriter regexNameValidatingRewriter = new RegexNameValidatingRewriter(this.pattern, true);
        String adjustedName = regexNameValidatingRewriter.rewriteName(MATCHING_USER_NAME);
        Assert.assertEquals((Object)MATCHING_USER_NAME, (Object)adjustedName);
        regexNameValidatingRewriter = new RegexNameValidatingRewriter(this.pattern, false);
        adjustedName = regexNameValidatingRewriter.rewriteName(MATCHING_USER_NAME);
        Assert.assertEquals(null, (Object)adjustedName);
    }

    @Test
    public void testNotMatchingRegexNameValidatingRewriter() {
        RegexNameValidatingRewriter regexNameValidatingRewriter = new RegexNameValidatingRewriter(this.pattern, true);
        String adjustedName = regexNameValidatingRewriter.rewriteName(NOT_MATCHING_USER_NAME);
        Assert.assertEquals(null, (Object)adjustedName);
        regexNameValidatingRewriter = new RegexNameValidatingRewriter(this.pattern, false);
        adjustedName = regexNameValidatingRewriter.rewriteName(NOT_MATCHING_USER_NAME);
        Assert.assertEquals((Object)NOT_MATCHING_USER_NAME, (Object)adjustedName);
    }

    @Test
    public void testMatchingRegexNameValidatingRewriterExistingUser() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = new FileSystemSecurityRealm(ServerUtils.getRootPath(true, this.getClass()));
        ServerUtils.addUser((ModifiableSecurityRealm)fileSystemSecurityRealm, MATCHING_USER_NAME);
        RegexNameValidatingRewriter regexNameValidatingRewriter = new RegexNameValidatingRewriter(this.pattern, true);
        SecurityDomain domainWithRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).setPreRealmRewriter((NameRewriter)regexNameValidatingRewriter).build();
        ServerAuthenticationContext sac1 = domainWithRewriter.createNewAuthenticationContext();
        sac1.setAuthenticationName(MATCHING_USER_NAME);
        Assert.assertTrue((boolean)sac1.authorize());
        Assert.assertEquals((Object)MATCHING_USER_NAME, (Object)sac1.getAuthorizedIdentity().getPrincipal().getName());
    }

    @Test
    public void testNotMatchingRegexNameValidatingRewriterExistingUser() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = new FileSystemSecurityRealm(ServerUtils.getRootPath(true, this.getClass()));
        ServerUtils.addUser((ModifiableSecurityRealm)fileSystemSecurityRealm, NOT_MATCHING_USER_NAME);
        RegexNameValidatingRewriter regexNameValidatingRewriter = new RegexNameValidatingRewriter(this.pattern, true);
        SecurityDomain domainWithRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).setPreRealmRewriter((NameRewriter)regexNameValidatingRewriter).build();
        ServerAuthenticationContext sac1 = domainWithRewriter.createNewAuthenticationContext();
        sac1.setAuthenticationName(NOT_MATCHING_USER_NAME);
        Assert.assertTrue((boolean)sac1.authorize());
        Assert.assertEquals((Object)ANONYMOUS, (Object)sac1.getAuthorizedIdentity().getPrincipal().getName());
    }
}

