/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.wildfly.common.iteration.CodePointIterator;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.realm.FileSystemSecurityRealmBuilder;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableRealmIdentityIterator;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.ServerUtils;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.AuthorizationIdentity;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.encryption.SecretKeyUtil;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.PasswordFactory;
import org.wildfly.security.password.interfaces.BCryptPassword;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.password.interfaces.OneTimePassword;
import org.wildfly.security.password.interfaces.SaltedSimpleDigestPassword;
import org.wildfly.security.password.interfaces.ScramDigestPassword;
import org.wildfly.security.password.interfaces.SimpleDigestPassword;
import org.wildfly.security.password.spec.ClearPasswordSpec;
import org.wildfly.security.password.spec.DigestPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.Encoding;
import org.wildfly.security.password.spec.EncryptablePasswordSpec;
import org.wildfly.security.password.spec.IteratedSaltedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.OneTimePasswordSpec;
import org.wildfly.security.password.spec.SaltedPasswordAlgorithmSpec;
import org.xipki.common.util.Base64;
import org.xml.sax.SAXException;

public class FileSystemSecurityRealmTest {
    SecretKey secretKey = SecretKeyUtil.generateSecretKey((int)128);
    KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
    KeyPair pair = this.keyPairGen.generateKeyPair();
    PrivateKey privateKey = this.pair.getPrivate();
    PublicKey publicKey = this.pair.getPublic();

    @Test
    public void testCreateIdentityWithNoLevels() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 0, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity identity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertFalse((boolean)identity.exists());
        identity.create();
        Assert.assertTrue((boolean)identity.exists());
    }

    @Test
    public void testCreateIdentityWithLevels() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity identity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        identity.create();
        Assert.assertTrue((boolean)identity.exists());
        identity.dispose();
    }

    @Test
    public void testCreateIdentityWithLevelsEncryption() throws Exception {
        FileSystemSecurityRealm securityRealm = FileSystemSecurityRealm.builder().setRoot(this.getRootPath()).setLevels(3).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).setSecretKey(this.secretKey).build();
        ModifiableRealmIdentity identity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertFalse((boolean)identity.exists());
        identity.create();
        Assert.assertTrue((boolean)identity.exists());
        identity.dispose();
    }

    @Test
    public void testCreateIdentityWithLevelsIntegrity() throws Exception {
        FileSystemSecurityRealm securityRealm = FileSystemSecurityRealm.builder().setRoot(this.getRootPath()).setLevels(3).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).setPrivateKey(this.privateKey).setPublicKey(this.publicKey).build();
        ModifiableRealmIdentity identity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertFalse((boolean)identity.exists());
        identity.create();
        Assert.assertTrue((boolean)identity.exists());
        identity.dispose();
    }

    @Test
    public void testCreateAndLoadIdentity() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.dispose();
        securityRealm = new FileSystemSecurityRealm(this.getRootPath(false), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        existingIdentity.dispose();
    }

    @Test
    public void testCreateAndLoadIdentityEncryption() throws Exception {
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.secretKey).build();
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.dispose();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        existingIdentity.dispose();
    }

    @Test
    public void testCreateAndLoadIdentityIntegrity() throws Exception {
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.privateKey, this.publicKey).build();
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.dispose();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        existingIdentity.dispose();
    }

    @Test
    public void testInvalidSignature() throws Exception {
        FileSystemSecurityRealm securityRealm = FileSystemSecurityRealm.builder().setRoot(Paths.get("./target/test-classes/filesystem-realm-exists/", new String[0])).setLevels(3).setPublicKey(this.publicKey).setPrivateKey(this.privateKey).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).build();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("user"));
        char[] actualPassword = "secretPassword".toCharArray();
        Assert.assertFalse((boolean)existingIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence(actualPassword)));
        existingIdentity.dispose();
    }

    @Test
    public void testInvalidIdentityVersion() throws Exception {
        FileSystemSecurityRealm securityRealm = FileSystemSecurityRealm.builder().setRoot(Paths.get("./target/test-classes/filesystem-realm-exists/", new String[0])).setLevels(3).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).build();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("user2"));
        MapAttributes newAttributes = new MapAttributes();
        newAttributes.addFirst("name", "plainUser");
        newAttributes.addAll("roles", Arrays.asList("Employee", "Manager", "Admin"));
        Assert.assertThrows(RealmUnavailableException.class, () -> existingIdentity.setAttributes((Attributes)newAttributes));
        existingIdentity.dispose();
    }

    @Test
    public void testShortUsername() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        this.shortUsername(securityRealm);
    }

    @Test
    public void testShortUsernameEncryption() throws Exception {
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.secretKey).build();
        this.shortUsername(securityRealm);
    }

    @Test
    public void testShortUsernameIntegrity() throws Exception {
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.privateKey, this.publicKey).build();
        this.shortUsername(securityRealm);
    }

    @Test
    public void testSpecialCharacters() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        this.specialCharacters(securityRealm);
    }

    @Test
    public void testSpecialCharactersEncryption() throws Exception {
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.secretKey).build();
        this.specialCharacters(securityRealm);
    }

    @Test
    public void testSpecialCharactersIntegrity() throws Exception {
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.privateKey, this.publicKey).build();
        this.specialCharacters(securityRealm);
    }

    @Test
    public void testCaseSensitive() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 3, ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        this.caseSensitive(securityRealm);
    }

    @Test
    public void testCaseSensitiveEncryption() throws Exception {
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.privateKey, this.publicKey).build();
        this.caseSensitive(securityRealm);
    }

    @Test
    public void testCaseSensitiveIntegrity() throws Exception {
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.privateKey, this.publicKey).build();
        this.caseSensitive(securityRealm);
    }

    @Test
    public void testCreateAndLoadAndDeleteIdentity() throws Exception {
        this.createAndLoadAndDeleteIdentity(null, null, null);
    }

    @Test
    public void testCreateAndLoadAndDeleteIdentityEncryption() throws Exception {
        this.createAndLoadAndDeleteIdentity(this.secretKey, null, null);
    }

    @Test
    public void testCreateAndLoadAndDeleteIdentityIntegrity() throws Exception {
        this.createAndLoadAndDeleteIdentity(null, this.privateKey, this.publicKey);
    }

    @Test
    public void testCreateIdentityWithAttributes() throws Exception {
        this.createIdentityWithAttributes(null, null, null);
    }

    @Test
    public void testCreateIdentityWithAttributesEncryption() throws Exception {
        this.createIdentityWithAttributes(this.secretKey, null, null);
    }

    @Test
    public void testCreateIdentityWithAttributesIntegrity() throws Exception {
        this.createIdentityWithAttributes(null, this.privateKey, this.publicKey);
    }

    @Test
    public void testCreateIdentityWithClearPassword() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"clear", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ClearPassword clearPassword = (ClearPassword)factory.generatePassword((KeySpec)new ClearPasswordSpec(actualPassword));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)clearPassword);
    }

    @Test
    public void testCreateIdentityWithClearPasswordEncryption() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"clear", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ClearPassword clearPassword = (ClearPassword)factory.generatePassword((KeySpec)new ClearPasswordSpec(actualPassword));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)clearPassword, this.secretKey);
    }

    @Test
    public void testCreateIdentityWithClearPasswordIntegrity() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"clear", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ClearPassword clearPassword = (ClearPassword)factory.generatePassword((KeySpec)new ClearPasswordSpec(actualPassword));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)clearPassword, this.publicKey, this.privateKey);
    }

    @Test
    public void testCreateIdentityWithBcryptCredential() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "secretPassword".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword);
    }

    @Test
    public void testCreateIdentityWithBcryptCredentialEncryption() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "secretPassword".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword, this.secretKey);
    }

    @Test
    public void testCreateIdentityWithBcryptCredentialIntegrity() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "secretPassword".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword, this.publicKey, this.privateKey);
    }

    @Test
    public void testCreateIdentityWithBcryptCredentialHexEncoded() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "secretPassword".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword, Encoding.HEX, StandardCharsets.UTF_8);
    }

    @Test
    public void testCreateIdentityWithBcryptCredentialHexEncodedEncryption() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "secretPassword".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword, Encoding.HEX, StandardCharsets.UTF_8, this.secretKey);
    }

    @Test
    public void testCreateIdentityWithBcryptCredentialHexEncodedIntegrity() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "secretPassword".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword, Encoding.HEX, StandardCharsets.UTF_8, this.publicKey, this.privateKey);
    }

    @Test
    public void testCreateIdentityWithBcryptCredentialBase64AndCharset() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "password\u5bc6\u7801".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16)), Charset.forName("gb2312")));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword, Encoding.BASE64, Charset.forName("gb2312"));
    }

    @Test
    public void testCreateIdentityWithBcryptCredentialBase64AndCharsetEncryption() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "password\u5bc6\u7801".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16)), Charset.forName("gb2312")));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword, Encoding.BASE64, Charset.forName("gb2312"), this.secretKey);
    }

    @Test
    public void testCreateIdentityWithBcryptCredentialBase64AndCharsetIntegrity() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "password\u5bc6\u7801".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16)), Charset.forName("gb2312")));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword, Encoding.BASE64, Charset.forName("gb2312"), this.publicKey, this.privateKey);
    }

    @Test
    public void testCreateIdentityWithBcryptCredentialHexEncodedAndCharset() throws Exception {
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        char[] actualPassword = "password\u5bc6\u7801".toCharArray();
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16)), Charset.forName("gb2312")));
        this.assertCreateIdentityWithPassword(actualPassword, (Password)bCryptPassword, Encoding.HEX, Charset.forName("gb2312"));
    }

    @Test
    public void testCreateIdentityWithScramCredential() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        PasswordFactory factory = PasswordFactory.getInstance((String)"scram-sha-256", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        EncryptablePasswordSpec encSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(4096, salt));
        ScramDigestPassword scramPassword = (ScramDigestPassword)factory.generatePassword((KeySpec)encSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)scramPassword);
    }

    @Test
    public void testCreateIdentityWithScramCredentialEncryption() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        PasswordFactory factory = PasswordFactory.getInstance((String)"scram-sha-256", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        EncryptablePasswordSpec encSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(4096, salt));
        ScramDigestPassword scramPassword = (ScramDigestPassword)factory.generatePassword((KeySpec)encSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)scramPassword, this.secretKey);
    }

    @Test
    public void testCreateIdentityWithScramCredentialIntegrity() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        PasswordFactory factory = PasswordFactory.getInstance((String)"scram-sha-256", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        EncryptablePasswordSpec encSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(4096, salt));
        ScramDigestPassword scramPassword = (ScramDigestPassword)factory.generatePassword((KeySpec)encSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)scramPassword, this.secretKey);
    }

    @Test
    public void testCreateIdentityWithScramCredentialHexEncoded() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        PasswordFactory factory = PasswordFactory.getInstance((String)"scram-sha-256", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        EncryptablePasswordSpec encSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(4096, salt));
        ScramDigestPassword scramPassword = (ScramDigestPassword)factory.generatePassword((KeySpec)encSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)scramPassword, Encoding.HEX, StandardCharsets.UTF_8);
    }

    @Test
    public void testCreateIdentityWithScramCredentialHexEncodedAndCharset() throws Exception {
        char[] actualPassword = "passwordHyv\u00e4\u00e4\u00e4".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        PasswordFactory factory = PasswordFactory.getInstance((String)"scram-sha-256", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        EncryptablePasswordSpec encSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(4096, salt), Charset.forName("ISO-8859-1"));
        ScramDigestPassword scramPassword = (ScramDigestPassword)factory.generatePassword((KeySpec)encSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)scramPassword, Encoding.HEX, Charset.forName("ISO-8859-1"));
    }

    @Test
    public void testCreateIdentityWithDigest() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        DigestPasswordAlgorithmSpec dpas = new DigestPasswordAlgorithmSpec("jsmith", "elytron");
        EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)dpas);
        DigestPassword digestPassword = (DigestPassword)factory.generatePassword((KeySpec)encryptableSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)digestPassword);
    }

    @Test
    public void testCreateIdentityWithDigestEncryption() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        DigestPasswordAlgorithmSpec dpas = new DigestPasswordAlgorithmSpec("jsmith", "elytron");
        EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)dpas);
        DigestPassword digestPassword = (DigestPassword)factory.generatePassword((KeySpec)encryptableSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)digestPassword, this.secretKey);
    }

    @Test
    public void testCreateIdentityWithDigestIntegrity() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        DigestPasswordAlgorithmSpec dpas = new DigestPasswordAlgorithmSpec("jsmith", "elytron");
        EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)dpas);
        DigestPassword digestPassword = (DigestPassword)factory.generatePassword((KeySpec)encryptableSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)digestPassword, this.publicKey, this.privateKey);
    }

    @Test
    public void testCreateIdentityWithDigestHexEncoded() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        DigestPasswordAlgorithmSpec dpas = new DigestPasswordAlgorithmSpec("jsmith", "elytron");
        EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)dpas);
        DigestPassword digestPassword = (DigestPassword)factory.generatePassword((KeySpec)encryptableSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)digestPassword, Encoding.HEX, StandardCharsets.UTF_8);
    }

    @Test
    public void testCreateIdentityWithDigestHexEncodedAndCharset() throws Exception {
        char[] actualPassword = "\u043f\u0430\u0440\u043e\u043b\u044c".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        DigestPasswordAlgorithmSpec dpas = new DigestPasswordAlgorithmSpec("jsmith", "elytron");
        EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)dpas, Charset.forName("KOI8-R"));
        DigestPassword digestPassword = (DigestPassword)factory.generatePassword((KeySpec)encryptableSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)digestPassword, Encoding.HEX, Charset.forName("KOI8-R"));
    }

    @Test
    public void testCreateIdentityWithDigestHexEncodedAndCharsetEncryption() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        DigestPasswordAlgorithmSpec dpas = new DigestPasswordAlgorithmSpec("jsmith", "elytron");
        EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)dpas);
        DigestPassword digestPassword = (DigestPassword)factory.generatePassword((KeySpec)encryptableSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)digestPassword, Encoding.HEX, Charset.forName("KOI8-R"), this.secretKey);
    }

    @Test
    public void testCreateIdentityWithDigestHexEncodedAndCharsetIntegrity() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        DigestPasswordAlgorithmSpec dpas = new DigestPasswordAlgorithmSpec("jsmith", "elytron");
        EncryptablePasswordSpec encryptableSpec = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)dpas);
        DigestPassword digestPassword = (DigestPassword)factory.generatePassword((KeySpec)encryptableSpec);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)digestPassword, Encoding.HEX, Charset.forName("KOI8-R"), this.publicKey, this.privateKey);
    }

    @Test
    public void testCreateIdentityWithSimpleDigest() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, null);
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"simple-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SimpleDigestPassword tsdp = (SimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp);
    }

    @Test
    public void testCreateIdentityWithSimpleDigestHexEncoded() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, null);
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"simple-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SimpleDigestPassword tsdp = (SimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp, Encoding.HEX, StandardCharsets.UTF_8);
    }

    @Test
    public void testCreateIdentityWithSimpleDigestHexEncodedAndCharset() throws Exception {
        char[] actualPassword = "password\u5bc6\u7801".toCharArray();
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, null, Charset.forName("gb2312"));
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"simple-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SimpleDigestPassword tsdp = (SimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp, Encoding.HEX, Charset.forName("gb2312"));
    }

    @Test
    public void testCreateIdentityWithSimpleSaltedDigest() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        SaltedPasswordAlgorithmSpec spac = new SaltedPasswordAlgorithmSpec(salt);
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)spac);
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"password-salt-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SaltedSimpleDigestPassword tsdp = (SaltedSimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp);
    }

    @Test
    public void testCreateIdentityWithSimpleSaltedDigestHexEncoded() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        SaltedPasswordAlgorithmSpec spac = new SaltedPasswordAlgorithmSpec(salt);
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)spac);
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"password-salt-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SaltedSimpleDigestPassword tsdp = (SaltedSimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp, Encoding.HEX, StandardCharsets.UTF_8);
    }

    @Test
    public void testCreateIdentityWithSimpleSaltedDigestHexEncodedAndCharset() throws Exception {
        char[] actualPassword = "password\u5bc6\u7801".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        SaltedPasswordAlgorithmSpec spac = new SaltedPasswordAlgorithmSpec(salt);
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)spac, Charset.forName("gb2312"));
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"password-salt-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SaltedSimpleDigestPassword tsdp = (SaltedSimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp, Encoding.HEX, Charset.forName("gb2312"));
    }

    @Test
    public void testCreateIdentityWithSimpleSaltedDigestHexEncodedAndCharsetEncryption() throws Exception {
        char[] actualPassword = "password\u5bc6\u7801".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        SaltedPasswordAlgorithmSpec spac = new SaltedPasswordAlgorithmSpec(salt);
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)spac, Charset.forName("gb2312"));
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"password-salt-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SaltedSimpleDigestPassword tsdp = (SaltedSimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp, Encoding.HEX, Charset.forName("gb2312"), this.secretKey);
    }

    @Test
    public void testCreateIdentityWithSimpleSaltedDigestHexEncodedAndCharsetIntegrity() throws Exception {
        char[] actualPassword = "password\u5bc6\u7801".toCharArray();
        byte[] salt = FileSystemSecurityRealmTest.generateRandomSalt(16);
        SaltedPasswordAlgorithmSpec spac = new SaltedPasswordAlgorithmSpec(salt);
        EncryptablePasswordSpec eps = new EncryptablePasswordSpec(actualPassword, (AlgorithmParameterSpec)spac, Charset.forName("gb2312"));
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"password-salt-digest-sha-512", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        SaltedSimpleDigestPassword tsdp = (SaltedSimpleDigestPassword)passwordFactory.generatePassword((KeySpec)eps);
        this.assertCreateIdentityWithPassword(actualPassword, (Password)tsdp, Encoding.HEX, Charset.forName("gb2312"), this.publicKey, this.privateKey);
    }

    @Test
    public void testCreateIdentityWithEverything() throws Exception {
        this.createIdentityWithEverything(null, null, null);
    }

    @Test
    public void testCreateIdentityWithEverythingEncryption() throws Exception {
        this.createIdentityWithEverything(this.secretKey, null, null);
    }

    @Test
    public void testCreateIdentityWithEverythingIntegrity() throws Exception {
        this.createIdentityWithEverything(null, this.privateKey, this.publicKey);
    }

    @Test
    public void testCreateIdentityWithEverythingEncryptionAndIntegrity() throws Exception {
        this.createIdentityWithEverything(this.secretKey, this.privateKey, this.publicKey);
    }

    @Test
    public void testVerifyCredentialsPreExistingIdentity() throws Exception {
        byte[] aesByte = Base64.decode((String)"3fMEsUHKCn3GZQXcHCyuhQ==");
        SecretKeySpec staticKey = new SecretKeySpec(aesByte, "AES");
        FileSystemSecurityRealm securityRealm = FileSystemSecurityRealm.builder().setRoot(Paths.get("./target/test-classes/filesystem-realm-exists/", new String[0])).setLevels(1).setHashEncoding(Encoding.BASE64).setHashCharset(Charset.defaultCharset()).setSecretKey((SecretKey)staticKey).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).build();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        Assert.assertTrue((boolean)existingIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("secretPassword".toCharArray())));
        Attributes identityAttributes = existingIdentity.getAttributes();
        MapAttributes newAttributes = new MapAttributes();
        newAttributes.addFirst("firstName", "John");
        newAttributes.addFirst("lastName", "Smith");
        newAttributes.addAll("roles", Arrays.asList("Employee", "Manager", "Admin"));
        Assert.assertEquals((long)newAttributes.size(), (long)identityAttributes.size());
        Assert.assertTrue((boolean)newAttributes.get("firstName").containsAll((Collection)identityAttributes.get("firstName")));
        Assert.assertTrue((boolean)newAttributes.get("lastName").containsAll((Collection)identityAttributes.get("lastName")));
        Assert.assertTrue((boolean)newAttributes.get("roles").containsAll((Collection)identityAttributes.get("roles")));
        existingIdentity.dispose();
    }

    @Test
    public void testCredentialReplacing() throws Exception {
        this.credentialReplacing(null, null, null);
    }

    @Test
    public void testCredentialReplacingEncryption() throws Exception {
        this.credentialReplacing(this.secretKey, null, null);
    }

    @Test
    public void testCredentialReplacingIntegrity() throws Exception {
        this.credentialReplacing(null, this.privateKey, this.publicKey);
    }

    @Test
    public void testIterating() throws Exception {
        FileSystemSecurityRealm securityRealm = this.createRealmWithTwoIdentities();
        ModifiableRealmIdentityIterator iterator = securityRealm.getRealmIdentityIterator();
        int count = 0;
        while (iterator.hasNext()) {
            Assert.assertTrue((boolean)((ModifiableRealmIdentity)iterator.next()).exists());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        this.getRootPath();
    }

    @Test
    public void testIteratingEncryption() throws Exception {
        FileSystemSecurityRealm securityRealm = this.createRealmWithTwoIdentities(this.secretKey);
        ModifiableRealmIdentityIterator iterator = securityRealm.getRealmIdentityIterator();
        int count = 0;
        while (iterator.hasNext()) {
            Assert.assertTrue((boolean)((ModifiableRealmIdentity)iterator.next()).exists());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        this.getRootPath();
    }

    @Test
    public void testIteratingIntegrity() throws Exception {
        FileSystemSecurityRealm securityRealm = this.createRealmWithTwoIdentities(this.publicKey, this.privateKey);
        ModifiableRealmIdentityIterator iterator = securityRealm.getRealmIdentityIterator();
        int count = 0;
        while (iterator.hasNext()) {
            Assert.assertTrue((boolean)((ModifiableRealmIdentity)iterator.next()).exists());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        this.getRootPath();
    }

    @Test
    public void testIteratingNeedlessClose() throws Exception {
        FileSystemSecurityRealm securityRealm = this.createRealmWithTwoIdentities();
        ModifiableRealmIdentityIterator iterator = securityRealm.getRealmIdentityIterator();
        int count = 0;
        while (iterator.hasNext()) {
            Assert.assertTrue((boolean)((ModifiableRealmIdentity)iterator.next()).exists());
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        iterator.close();
        this.getRootPath();
    }

    @Test
    public void testPartialIterating() throws Exception {
        FileSystemSecurityRealm securityRealm = this.createRealmWithTwoIdentities();
        ModifiableRealmIdentityIterator iterator = securityRealm.getRealmIdentityIterator();
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertTrue((boolean)((ModifiableRealmIdentity)iterator.next()).exists());
        iterator.close();
        this.getRootPath();
    }

    @Test
    public void testPartialIteratingTryWithResource() throws Exception {
        FileSystemSecurityRealm securityRealm = this.createRealmWithTwoIdentities();
        try (ModifiableRealmIdentityIterator iterator = securityRealm.getRealmIdentityIterator();){
            Assert.assertTrue((boolean)iterator.hasNext());
            Assert.assertTrue((boolean)((ModifiableRealmIdentity)iterator.next()).exists());
        }
        this.getRootPath();
    }

    @Test
    public void testMismatchSecretKey() throws Exception {
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"clear", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ClearPassword clearPassword = (ClearPassword)factory.generatePassword((KeySpec)new ClearPasswordSpec(actualPassword));
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.secretKey).build();
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.setCredentials(Collections.singleton(new PasswordCredential((Password)clearPassword)));
        securityRealm = this.getBuilder(SecretKeyUtil.generateSecretKey((int)192)).build();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        try {
            existingIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence(actualPassword));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getCause().getMessage().contains("unable to decrypt identity"));
        }
        existingIdentity.dispose();
    }

    @Test
    public void testMismatchKeyPair() throws Exception {
        PrivateKey falsePrivateKey = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPrivate();
        PublicKey falsePublicKey = KeyPairGenerator.getInstance("RSA").generateKeyPair().getPublic();
        char[] actualPassword = "secretPassword".toCharArray();
        PasswordFactory factory = PasswordFactory.getInstance((String)"clear", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        ClearPassword clearPassword = (ClearPassword)factory.generatePassword((KeySpec)new ClearPasswordSpec(actualPassword));
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.privateKey, this.publicKey).build();
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.setCredentials(Collections.singleton(new PasswordCredential((Password)clearPassword)));
        securityRealm = this.getBuilder(falsePrivateKey, falsePublicKey).build();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertFalse((boolean)existingIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence(actualPassword)));
        existingIdentity.dispose();
    }

    @Test
    public void encodedIfNotEncrypted() throws Exception {
        File file = new File(this.getRootPath().toString() + "/p/l/plainuser-OBWGC2LOKVZWK4Q.xml");
        FileSystemSecurityRealm securityRealm = FileSystemSecurityRealm.builder().setRoot(this.getRootPath(false)).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).setEncoded(true).build();
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        Assert.assertTrue((boolean)file.isFile());
        newIdentity.dispose();
        securityRealm = FileSystemSecurityRealm.builder().setRoot(this.getRootPath(true)).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).setSecretKey(this.secretKey).build();
        newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        Assert.assertFalse((boolean)file.isFile());
        newIdentity.dispose();
    }

    @Test
    public void testNewKeyPairRewrite() throws Exception {
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.privateKey, this.publicKey).build();
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        MapAttributes newAttributes = new MapAttributes();
        newAttributes.addFirst("name", "plainUser");
        newAttributes.addAll("roles", Arrays.asList("Employee", "Manager", "Admin"));
        newIdentity.setAttributes((Attributes)newAttributes);
        newIdentity.dispose();
        String identityPath = this.getRootPath(false) + File.separator + "p" + File.separator + "l" + File.separator + "plainuser-OBWGC2LOKVZWK4Q.xml";
        Assert.assertTrue((boolean)this.validateDigitalSignature(identityPath, "plainUser", this.publicKey));
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        KeyPair pair = keyPairGen.generateKeyPair();
        PrivateKey newPrivateKey = pair.getPrivate();
        PublicKey newPublicKey = pair.getPublic();
        securityRealm = this.getBuilder(newPrivateKey, newPublicKey).build();
        Assert.assertFalse((boolean)this.validateDigitalSignature(identityPath, "plainUser", newPublicKey));
        securityRealm.updateRealmKeyPair();
        Assert.assertTrue((boolean)this.validateDigitalSignature(identityPath, "plainUser", newPublicKey));
        newIdentity.dispose();
    }

    @Test
    public void testIdentityPrincipalTampered() throws Exception {
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.privateKey, this.publicKey).build();
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.dispose();
        Path identityFile = Paths.get(this.getRootPath(false).toString(), "p", "l", "plainuser-OBWGC2LOKVZWK4Q.xml");
        String identityFileString = new String(Files.readAllBytes(identityFile));
        identityFileString = identityFileString.replace("plainUser", "TAMPERED_PRINCIPAL");
        PrintWriter out = new PrintWriter(identityFile.toString());
        out.println(identityFileString);
        out.close();
        Assert.assertFalse((boolean)securityRealm.verifyRealmIntegrity().isValid());
    }

    @Test
    public void testIdentityCredentialsTampered() throws Exception {
        FileSystemSecurityRealm securityRealm = this.getBuilder(this.privateKey, this.publicKey).build();
        ArrayList<PasswordCredential> credentials = new ArrayList<PasswordCredential>();
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec("secretPassword".toCharArray(), (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        credentials.add(new PasswordCredential((Password)bCryptPassword));
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.setCredentials(credentials);
        newIdentity.dispose();
        Path identityFile = Paths.get(this.getRootPath(false).toString(), "p", "l", "plainuser-OBWGC2LOKVZWK4Q.xml");
        String identityFileString = new String(Files.readAllBytes(identityFile));
        identityFileString = identityFileString.replace("plainUser", "TAMPERED_PRINCIPAL");
        String start = "\\<password algorithm=\"bcrypt\" format=\"base64\">";
        String end = "\\</password>";
        identityFileString = identityFileString.replaceAll(start + ".*" + end, "FAKE_PASSWORD");
        PrintWriter out = new PrintWriter(identityFile.toString());
        out.println(identityFileString);
        out.close();
        Assert.assertFalse((boolean)securityRealm.verifyRealmIntegrity().isValid());
    }

    private void credentialReplacing(SecretKey secretKey, PrivateKey privateKey, PublicKey publicKey) throws Exception {
        Assert.assertFalse((boolean)(privateKey != null ^ publicKey != null));
        FileSystemSecurityRealmBuilder securityRealmBuilder = FileSystemSecurityRealm.builder().setRoot(this.getRootPath()).setLevels(1).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        if (secretKey != null) {
            securityRealmBuilder.setSecretKey(secretKey);
        } else if (privateKey != null) {
            securityRealmBuilder.setPrivateKey(privateKey);
            securityRealmBuilder.setPublicKey(publicKey);
        }
        FileSystemSecurityRealm securityRealm = securityRealmBuilder.build();
        ModifiableRealmIdentity identity1 = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("testingUser"));
        identity1.create();
        ArrayList<PasswordCredential> credentials = new ArrayList<PasswordCredential>();
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec("secretPassword".toCharArray(), (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        credentials.add(new PasswordCredential((Password)bCryptPassword));
        byte[] hash = CodePointIterator.ofString((String)"505d889f90085847").hexDecode().drain();
        String seed = "ke1234";
        PasswordFactory otpFactory = PasswordFactory.getInstance((String)"otp-sha1", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        OneTimePassword otpPassword = (OneTimePassword)otpFactory.generatePassword((KeySpec)new OneTimePasswordSpec(hash, seed, 500));
        credentials.add(new PasswordCredential((Password)otpPassword));
        identity1.setCredentials(credentials);
        identity1.dispose();
        securityRealmBuilder = FileSystemSecurityRealm.builder().setRoot(this.getRootPath(false)).setLevels(1).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        if (secretKey != null) {
            securityRealmBuilder.setSecretKey(secretKey);
        } else if (privateKey != null) {
            securityRealmBuilder.setPrivateKey(privateKey);
            securityRealmBuilder.setPublicKey(publicKey);
        }
        securityRealm = securityRealmBuilder.build();
        ModifiableRealmIdentity identity3 = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("testingUser"));
        Assert.assertTrue((boolean)identity3.exists());
        Assert.assertTrue((boolean)identity3.verifyEvidence((Evidence)new PasswordGuessEvidence("secretPassword".toCharArray())));
        identity3.dispose();
    }

    private void createIdentityWithEverything(SecretKey secretKey, PrivateKey privateKey, PublicKey publicKey) throws Exception {
        Assert.assertFalse((boolean)(privateKey != null ^ publicKey != null));
        FileSystemSecurityRealmBuilder securityRealmBuilder = FileSystemSecurityRealm.builder().setRoot(this.getRootPath()).setLevels(1).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        if (secretKey != null) {
            securityRealmBuilder.setSecretKey(secretKey);
        }
        if (privateKey != null) {
            securityRealmBuilder.setPrivateKey(privateKey);
            securityRealmBuilder.setPublicKey(publicKey);
        }
        FileSystemSecurityRealm securityRealm = securityRealmBuilder.build();
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        MapAttributes newAttributes = new MapAttributes();
        newAttributes.addFirst("firstName", "John");
        newAttributes.addFirst("lastName", "Smith");
        newAttributes.addAll("roles", Arrays.asList("Employee", "Manager", "Admin"));
        newIdentity.setAttributes((Attributes)newAttributes);
        ArrayList<PasswordCredential> credentials = new ArrayList<PasswordCredential>();
        PasswordFactory passwordFactory = PasswordFactory.getInstance((String)"bcrypt", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        BCryptPassword bCryptPassword = (BCryptPassword)passwordFactory.generatePassword((KeySpec)new EncryptablePasswordSpec("secretPassword".toCharArray(), (AlgorithmParameterSpec)new IteratedSaltedPasswordAlgorithmSpec(10, FileSystemSecurityRealmTest.generateRandomSalt(16))));
        credentials.add(new PasswordCredential((Password)bCryptPassword));
        byte[] hash = CodePointIterator.ofString((String)"505d889f90085847").hexDecode().drain();
        String seed = "ke1234";
        PasswordFactory otpFactory = PasswordFactory.getInstance((String)"otp-sha1", ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        OneTimePassword otpPassword = (OneTimePassword)otpFactory.generatePassword((KeySpec)new OneTimePasswordSpec(hash, seed, 500));
        credentials.add(new PasswordCredential((Password)otpPassword));
        newIdentity.setCredentials(credentials);
        newIdentity.dispose();
        securityRealmBuilder = FileSystemSecurityRealm.builder().setRoot(this.getRootPath(false)).setLevels(1).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        if (secretKey != null) {
            securityRealmBuilder.setSecretKey(secretKey);
        }
        if (privateKey != null) {
            securityRealmBuilder.setPrivateKey(privateKey);
            securityRealmBuilder.setPublicKey(publicKey);
        }
        securityRealm = securityRealmBuilder.build();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        Assert.assertTrue((boolean)existingIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence("secretPassword".toCharArray())));
        OneTimePassword otp = (OneTimePassword)((PasswordCredential)existingIdentity.getCredential(PasswordCredential.class, "otp-sha1")).getPassword(OneTimePassword.class);
        Assert.assertNotNull((Object)otp);
        Assert.assertEquals((Object)"otp-sha1", (Object)otp.getAlgorithm());
        Assert.assertArrayEquals((byte[])hash, (byte[])otp.getHash());
        Assert.assertEquals((Object)seed, (Object)otp.getSeed());
        Assert.assertEquals((long)500L, (long)otp.getSequenceNumber());
        AuthorizationIdentity authorizationIdentity = existingIdentity.getAuthorizationIdentity();
        Attributes existingAttributes = authorizationIdentity.getAttributes();
        existingIdentity.dispose();
        Assert.assertEquals((long)newAttributes.size(), (long)existingAttributes.size());
        Assert.assertTrue((boolean)newAttributes.get("firstName").containsAll((Collection)existingAttributes.get("firstName")));
        Assert.assertTrue((boolean)newAttributes.get("lastName").containsAll((Collection)existingAttributes.get("lastName")));
        Assert.assertTrue((boolean)newAttributes.get("roles").containsAll((Collection)existingAttributes.get("roles")));
    }

    private void createIdentityWithAttributes(SecretKey secretKey, PrivateKey privateKey, PublicKey publicKey) throws Exception {
        Assert.assertFalse((boolean)(privateKey != null ^ publicKey != null));
        FileSystemSecurityRealmBuilder securityRealmBuilder = FileSystemSecurityRealm.builder().setRoot(this.getRootPath()).setLevels(1).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        if (secretKey != null) {
            securityRealmBuilder.setSecretKey(secretKey);
        }
        if (privateKey != null) {
            securityRealmBuilder.setPrivateKey(privateKey);
            securityRealmBuilder.setPublicKey(publicKey);
        }
        FileSystemSecurityRealm securityRealm = securityRealmBuilder.build();
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        MapAttributes newAttributes = new MapAttributes();
        newAttributes.addFirst("name", "plainUser");
        newAttributes.addAll("roles", Arrays.asList("Employee", "Manager", "Admin"));
        newIdentity.setAttributes((Attributes)newAttributes);
        newIdentity.dispose();
        securityRealmBuilder = FileSystemSecurityRealm.builder().setRoot(this.getRootPath(false)).setLevels(1).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        if (secretKey != null) {
            securityRealmBuilder.setSecretKey(secretKey);
        }
        if (privateKey != null) {
            securityRealmBuilder.setPrivateKey(privateKey);
            securityRealmBuilder.setPublicKey(publicKey);
        }
        securityRealm = securityRealmBuilder.build();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        AuthorizationIdentity authorizationIdentity = existingIdentity.getAuthorizationIdentity();
        Attributes existingAttributes = authorizationIdentity.getAttributes();
        existingIdentity.dispose();
        Assert.assertEquals((long)newAttributes.size(), (long)existingAttributes.size());
        Assert.assertTrue((boolean)newAttributes.get("name").containsAll((Collection)existingAttributes.get("name")));
        Assert.assertTrue((boolean)newAttributes.get("roles").containsAll((Collection)existingAttributes.get("roles")));
    }

    private void createAndLoadAndDeleteIdentity(SecretKey secretKey, PrivateKey privateKey, PublicKey publicKey) throws Exception {
        Assert.assertFalse((boolean)(privateKey != null ^ publicKey != null));
        FileSystemSecurityRealmBuilder securityRealmBuilder = FileSystemSecurityRealm.builder().setRoot(this.getRootPath()).setLevels(3).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        if (secretKey != null) {
            securityRealmBuilder.setSecretKey(secretKey);
        }
        if (privateKey != null) {
            securityRealmBuilder.setPrivateKey(privateKey);
            securityRealmBuilder.setPublicKey(publicKey);
        }
        FileSystemSecurityRealm securityRealm = securityRealmBuilder.build();
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.dispose();
        securityRealmBuilder = FileSystemSecurityRealm.builder().setRoot(this.getRootPath(false)).setLevels(3).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        if (secretKey != null) {
            securityRealmBuilder.setSecretKey(secretKey);
        }
        if (privateKey != null) {
            securityRealmBuilder.setPrivateKey(privateKey);
            securityRealmBuilder.setPublicKey(publicKey);
        }
        securityRealm = securityRealmBuilder.build();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        existingIdentity.delete();
        Assert.assertFalse((boolean)existingIdentity.exists());
        existingIdentity.dispose();
        securityRealmBuilder = FileSystemSecurityRealm.builder().setRoot(this.getRootPath(false)).setLevels(3).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        if (secretKey != null) {
            securityRealmBuilder.setSecretKey(secretKey);
        }
        if (privateKey != null) {
            securityRealmBuilder.setPrivateKey(privateKey);
            securityRealmBuilder.setPublicKey(publicKey);
        }
        securityRealm = securityRealmBuilder.build();
        existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertFalse((boolean)existingIdentity.exists());
        existingIdentity.dispose();
    }

    private void specialCharacters(FileSystemSecurityRealm securityRealm) throws Exception {
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("special*.\"/\\[]:;|=,\u7528\u6236 "));
        newIdentity.create();
        newIdentity.dispose();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("special*.\"/\\[]:;|=,\u7528\u6236 "));
        Assert.assertTrue((boolean)existingIdentity.exists());
        existingIdentity.dispose();
    }

    private void shortUsername(FileSystemSecurityRealm securityRealm) throws Exception {
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("p"));
        newIdentity.create();
        newIdentity.dispose();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("p"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        existingIdentity.dispose();
    }

    private void caseSensitive(FileSystemSecurityRealm securityRealm) throws Exception {
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        Assert.assertTrue((boolean)newIdentity.exists());
        newIdentity.dispose();
        ModifiableRealmIdentity differentIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("PLAINUSER"));
        Assert.assertFalse((boolean)differentIdentity.exists());
        differentIdentity.dispose();
    }

    private FileSystemSecurityRealm createRealmWithTwoIdentities() throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), 1);
        ModifiableRealmIdentity identity1 = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("firstUser"));
        identity1.create();
        identity1.dispose();
        ModifiableRealmIdentity identity2 = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("secondUser"));
        identity2.create();
        identity2.dispose();
        return securityRealm;
    }

    private FileSystemSecurityRealm createRealmWithTwoIdentities(SecretKey secretKey) throws Exception {
        FileSystemSecurityRealm securityRealm = FileSystemSecurityRealm.builder().setRoot(this.getRootPath()).setLevels(1).setSecretKey(secretKey).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).build();
        ModifiableRealmIdentity identity1 = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("firstUser"));
        identity1.create();
        identity1.dispose();
        ModifiableRealmIdentity identity2 = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("secondUser"));
        identity2.create();
        identity2.dispose();
        return securityRealm;
    }

    private FileSystemSecurityRealm createRealmWithTwoIdentities(PublicKey publicKey, PrivateKey privateKey) throws Exception {
        FileSystemSecurityRealm securityRealm = FileSystemSecurityRealm.builder().setRoot(this.getRootPath()).setLevels(1).setPublicKey(publicKey).setPrivateKey(privateKey).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).build();
        ModifiableRealmIdentity identity1 = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("firstUser"));
        identity1.create();
        identity1.dispose();
        ModifiableRealmIdentity identity2 = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("secondUser"));
        identity2.create();
        identity2.dispose();
        return securityRealm;
    }

    private FileSystemSecurityRealmBuilder getBuilder(SecretKey secretKey, PrivateKey privateKey, PublicKey publicKey) throws Exception {
        FileSystemSecurityRealmBuilder securityRealmBuilder = FileSystemSecurityRealm.builder().setRoot(this.getRootPath(false)).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS);
        if (secretKey != null) {
            securityRealmBuilder.setSecretKey(secretKey);
        }
        if (privateKey != null && publicKey != null) {
            securityRealmBuilder.setPrivateKey(privateKey).setPublicKey(publicKey);
        }
        return securityRealmBuilder;
    }

    private FileSystemSecurityRealmBuilder getBuilder(SecretKey secretKey) throws Exception {
        return this.getBuilder(secretKey, null, null);
    }

    private FileSystemSecurityRealmBuilder getBuilder(PrivateKey privateKey, PublicKey publicKey) throws Exception {
        return this.getBuilder(null, privateKey, publicKey);
    }

    private FileSystemSecurityRealmBuilder getBuilder() throws Exception {
        return this.getBuilder(null, null, null);
    }

    private void assertCreateIdentityWithPassword(char[] actualPassword, Password credential) throws Exception {
        this.assertCreateIdentityWithPassword(actualPassword, credential, Encoding.BASE64, StandardCharsets.UTF_8);
    }

    private void assertCreateIdentityWithPassword(char[] actualPassword, Password credential, SecretKey secretKey) throws Exception {
        this.assertCreateIdentityWithPassword(actualPassword, credential, Encoding.BASE64, StandardCharsets.UTF_8, secretKey);
    }

    private void assertCreateIdentityWithPassword(char[] actualPassword, Password credential, PublicKey publicKey, PrivateKey privateKey) throws Exception {
        this.assertCreateIdentityWithPassword(actualPassword, credential, Encoding.BASE64, StandardCharsets.UTF_8, publicKey, privateKey);
    }

    private void assertCreateIdentityWithPassword(char[] actualPassword, Password credential, Encoding hashEncoding, Charset hashCharset) throws Exception {
        FileSystemSecurityRealm securityRealm = new FileSystemSecurityRealm(this.getRootPath(), NameRewriter.IDENTITY_REWRITER, 1, true, hashEncoding, hashCharset, ServerUtils.ELYTRON_PASSWORD_PROVIDERS, null, null, null);
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.setCredentials(Collections.singleton(new PasswordCredential(credential)));
        newIdentity.dispose();
        securityRealm = new FileSystemSecurityRealm(this.getRootPath(false), NameRewriter.IDENTITY_REWRITER, 1, true, hashEncoding, hashCharset, ServerUtils.ELYTRON_PASSWORD_PROVIDERS, null, null, null);
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        Assert.assertTrue((boolean)existingIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence(actualPassword)));
        existingIdentity.dispose();
    }

    private void assertCreateIdentityWithPassword(char[] actualPassword, Password credential, Encoding hashEncoding, Charset hashCharset, SecretKey secretKey) throws Exception {
        FileSystemSecurityRealm securityRealm = FileSystemSecurityRealm.builder().setRoot(this.getRootPath()).setLevels(1).setHashEncoding(hashEncoding).setHashCharset(hashCharset).setSecretKey(secretKey).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).build();
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.setCredentials(Collections.singleton(new PasswordCredential(credential)));
        newIdentity.dispose();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        Assert.assertTrue((boolean)existingIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence(actualPassword)));
        existingIdentity.dispose();
    }

    private void assertCreateIdentityWithPassword(char[] actualPassword, Password credential, Encoding hashEncoding, Charset hashCharset, PublicKey publicKey, PrivateKey privateKey) throws Exception {
        FileSystemSecurityRealm securityRealm = FileSystemSecurityRealm.builder().setRoot(this.getRootPath()).setLevels(1).setHashEncoding(hashEncoding).setHashCharset(hashCharset).setProviders(ServerUtils.ELYTRON_PASSWORD_PROVIDERS).setPublicKey(publicKey).setPrivateKey(privateKey).build();
        ModifiableRealmIdentity newIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        newIdentity.create();
        newIdentity.setCredentials(Collections.singleton(new PasswordCredential(credential)));
        newIdentity.dispose();
        ModifiableRealmIdentity existingIdentity = securityRealm.getRealmIdentityForUpdate((Principal)new NamePrincipal("plainUser"));
        Assert.assertTrue((boolean)existingIdentity.exists());
        Assert.assertTrue((boolean)existingIdentity.verifyEvidence((Evidence)new PasswordGuessEvidence(actualPassword)));
        existingIdentity.dispose();
    }

    private static byte[] generateRandomSalt(int saltSize) {
        byte[] randomSalt = new byte[saltSize];
        ThreadLocalRandom.current().nextBytes(randomSalt);
        return randomSalt;
    }

    private Path getRootPath(boolean deleteIfExists) throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource(File.separator).toURI()).resolve("filesystem-realm");
        if (rootPath.toFile().exists() && !deleteIfExists) {
            return rootPath;
        }
        return Files.walkFileTree(Files.createDirectories(rootPath, new FileAttribute[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private Path getRootPath() throws Exception {
        return this.getRootPath(true);
    }

    private boolean validateDigitalSignature(String path, String name, PublicKey publicKey) throws IllegalStateException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(path);
            NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (nl.getLength() == 0) {
                throw new RealmUnavailableException("Cannot find Signature element");
            }
            XMLSignatureFactory fac = XMLSignatureFactory.getInstance("DOM");
            DOMValidateContext valContext = new DOMValidateContext(publicKey, nl.item(0));
            XMLSignature signature = fac.unmarshalXMLSignature(valContext);
            return signature.validate(valContext);
        }
        catch (IOException | MarshalException | XMLSignatureException | ParserConfigurationException | SAXException e) {
            throw new IllegalStateException(String.format("Signature for the following identity is invalid: %s.", name));
        }
    }
}

