/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.util.regex.Pattern;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.server.ServerUtils;
import org.wildfly.security.auth.util.CaseNameRewriter;
import org.wildfly.security.auth.util.MutableNameRewriter;
import org.wildfly.security.auth.util.RegexNameRewriter;

public class MutableNameRewriterTest {
    private static final String LOWER_CASE_USER_NAME = "user";
    private static final String UPPER_CASE_USER_NAME = "USER";
    private static final String BEFORE_REPLACE_USER_NAME = ".user.";
    private static final String AFTER_REPLACE_ALL_USER_NAME = "dotuserdot";
    private static final String AFTER_REPLACE_USER_NAME = "dotuser.";

    @Test
    public void testMutableNameRewriterWithCaseNameRewriter() {
        CaseNameRewriter caseNameRewriter = new CaseNameRewriter(true);
        MutableNameRewriter rewriter = new MutableNameRewriter((NameRewriter)caseNameRewriter);
        String adjustedName = rewriter.rewriteName(LOWER_CASE_USER_NAME);
        Assert.assertEquals((Object)UPPER_CASE_USER_NAME, (Object)adjustedName);
        caseNameRewriter = new CaseNameRewriter(false);
        rewriter.setTarget((NameRewriter)caseNameRewriter);
        adjustedName = rewriter.rewriteName(UPPER_CASE_USER_NAME);
        Assert.assertEquals((Object)LOWER_CASE_USER_NAME, (Object)adjustedName);
        caseNameRewriter = new CaseNameRewriter();
        rewriter.setTarget((NameRewriter)caseNameRewriter);
        adjustedName = rewriter.rewriteName(LOWER_CASE_USER_NAME);
        Assert.assertEquals((Object)UPPER_CASE_USER_NAME, (Object)adjustedName);
    }

    @Test
    public void testMutableNameRewriterWithRegexNameRewriter() {
        Pattern pattern = Pattern.compile("\\.");
        RegexNameRewriter regexNameRewriter = new RegexNameRewriter(pattern, "dot", true);
        MutableNameRewriter rewriter = new MutableNameRewriter((NameRewriter)regexNameRewriter);
        String adjustedName = rewriter.rewriteName(BEFORE_REPLACE_USER_NAME);
        Assert.assertEquals((Object)AFTER_REPLACE_ALL_USER_NAME, (Object)adjustedName);
        regexNameRewriter = new RegexNameRewriter(pattern, "dot", false);
        rewriter.setTarget((NameRewriter)regexNameRewriter);
        adjustedName = rewriter.rewriteName(BEFORE_REPLACE_USER_NAME);
        Assert.assertEquals((Object)AFTER_REPLACE_USER_NAME, (Object)adjustedName);
    }

    @Test
    public void testMutableNameRewriterExistingUser() throws Exception {
        FileSystemSecurityRealm fileSystemSecurityRealm = new FileSystemSecurityRealm(ServerUtils.getRootPath(true, this.getClass()));
        ServerUtils.addUser((ModifiableSecurityRealm)fileSystemSecurityRealm, UPPER_CASE_USER_NAME);
        CaseNameRewriter caseNameRewriter = new CaseNameRewriter(true);
        MutableNameRewriter mutableNameRewriter = new MutableNameRewriter((NameRewriter)caseNameRewriter);
        SecurityDomain domainWithRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).setPreRealmRewriter((NameRewriter)mutableNameRewriter).build();
        ServerAuthenticationContext sac1 = domainWithRewriter.createNewAuthenticationContext();
        sac1.setAuthenticationName(LOWER_CASE_USER_NAME);
        Assert.assertTrue((boolean)sac1.authorize());
        SecurityDomain domainWithoutRewriter = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> LoginPermission.getInstance()).build();
        ServerAuthenticationContext sac2 = domainWithoutRewriter.createNewAuthenticationContext();
        sac2.setAuthenticationName(LOWER_CASE_USER_NAME);
        Assert.assertFalse((boolean)sac2.authorize());
    }
}

