/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.spec.AlgorithmParameterSpec;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.WildFlyElytronProvider;
import org.wildfly.security.password.WildFlyElytronPasswordProvider;
import org.wildfly.security.password.spec.MaskedPasswordAlgorithmSpec;
import org.wildfly.security.password.spec.OneTimePasswordAlgorithmSpec;

public class AbstractAlgorithmParametersSpiImplTest {
    @Test
    public void shouldRoundTripParameterSpecs() throws GeneralSecurityException, IOException {
        OneTimePasswordAlgorithmSpec start = new OneTimePasswordAlgorithmSpec("otp-sha1", this.generateRandomOTPSeed(16), 14);
        AlgorithmParameters oneWay = AlgorithmParameters.getInstance("otp-sha1", (Provider)WildFlyElytronPasswordProvider.getInstance());
        oneWay.init((AlgorithmParameterSpec)start);
        byte[] encoded = oneWay.getEncoded();
        AlgorithmParameters orAnother = AlgorithmParameters.getInstance("otp-sha1", (Provider)WildFlyElytronPasswordProvider.getInstance());
        orAnother.init(encoded);
        OneTimePasswordAlgorithmSpec end = orAnother.getParameterSpec(OneTimePasswordAlgorithmSpec.class);
        Assert.assertEquals((Object)start.getAlgorithm(), (Object)end.getAlgorithm());
        Assert.assertEquals((Object)start.getSeed(), (Object)end.getSeed());
        Assert.assertEquals((long)start.getSequenceNumber(), (long)end.getSequenceNumber());
    }

    @Test
    public void maskedPasswordParameterSpecWithoutIvEncoding() throws GeneralSecurityException, IOException {
        MaskedPasswordAlgorithmSpec start = new MaskedPasswordAlgorithmSpec("key".toCharArray(), 5, "salt".getBytes(StandardCharsets.UTF_8));
        AlgorithmParameters oneWay = AlgorithmParameters.getInstance("masked-HMAC-SHA1-AES-256", (Provider)new WildFlyElytronProvider());
        oneWay.init((AlgorithmParameterSpec)start);
        byte[] encoded = oneWay.getEncoded();
        Assert.assertEquals((Object)"MA4EA2tleQIBBQQEc2FsdA==", (Object)ByteIterator.ofBytes((byte[])encoded).base64Encode().drainToString());
        AlgorithmParameters orAnother = AlgorithmParameters.getInstance("masked-HMAC-SHA1-AES-256", (Provider)new WildFlyElytronProvider());
        orAnother.init(encoded);
        MaskedPasswordAlgorithmSpec end = orAnother.getParameterSpec(MaskedPasswordAlgorithmSpec.class);
        Assert.assertArrayEquals((char[])start.getInitialKeyMaterial(), (char[])end.getInitialKeyMaterial());
        Assert.assertEquals((long)start.getIterationCount(), (long)end.getIterationCount());
        Assert.assertArrayEquals((byte[])start.getSalt(), (byte[])end.getSalt());
        Assert.assertArrayEquals((byte[])start.getInitializationVector(), (byte[])end.getInitializationVector());
    }

    @Test
    public void maskedPasswordParameterSpecWithIvEncoding() throws GeneralSecurityException, IOException {
        MaskedPasswordAlgorithmSpec start = new MaskedPasswordAlgorithmSpec("key".toCharArray(), 5, "salt".getBytes(StandardCharsets.UTF_8), "iv".getBytes(StandardCharsets.UTF_8));
        AlgorithmParameters oneWay = AlgorithmParameters.getInstance("masked-HMAC-SHA1-AES-256", (Provider)new WildFlyElytronProvider());
        oneWay.init((AlgorithmParameterSpec)start);
        byte[] encoded = oneWay.getEncoded();
        Assert.assertEquals((Object)"MBIEA2tleQIBBQQEc2FsdAQCaXY=", (Object)ByteIterator.ofBytes((byte[])encoded).base64Encode().drainToString());
        AlgorithmParameters orAnother = AlgorithmParameters.getInstance("masked-HMAC-SHA1-AES-256", (Provider)new WildFlyElytronProvider());
        orAnother.init(encoded);
        MaskedPasswordAlgorithmSpec end = orAnother.getParameterSpec(MaskedPasswordAlgorithmSpec.class);
        Assert.assertArrayEquals((char[])start.getInitialKeyMaterial(), (char[])end.getInitialKeyMaterial());
        Assert.assertEquals((long)start.getIterationCount(), (long)end.getIterationCount());
        Assert.assertArrayEquals((byte[])start.getSalt(), (byte[])end.getSalt());
        Assert.assertArrayEquals((byte[])start.getInitializationVector(), (byte[])end.getInitializationVector());
    }

    private String generateRandomOTPSeed(int saltSize) {
        byte[] salt = new byte[saltSize];
        int i = 0;
        int len = salt.length;
        while (i < len) {
            int rnd = ThreadLocalRandom.current().nextInt(0, 128);
            int n = Math.min(len - i, 4);
            while (n-- > 0) {
                salt[i++] = (byte)rnd;
                rnd >>= 8;
            }
        }
        return new String(salt, StandardCharsets.US_ASCII);
    }
}

