/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.asn1.ASN1Encodable;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.FileSystemSecurityRealm;
import org.wildfly.security.auth.server.EvidenceDecoder;
import org.wildfly.security.auth.server.ModifiableRealmIdentity;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.NameRewriter;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.auth.util.RegexNameRewriter;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.PasswordGuessEvidence;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.x500.GeneralName;
import org.wildfly.security.x500.X500AttributeTypeAndValue;
import org.wildfly.security.x500.X500PrincipalBuilder;
import org.wildfly.security.x500.cert.SubjectAlternativeNamesExtension;
import org.wildfly.security.x500.cert.X509CertificateBuilder;
import org.wildfly.security.x500.cert.X509CertificateExtension;
import org.wildfly.security.x500.principal.X500AttributePrincipalDecoder;
import org.wildfly.security.x500.principal.X500SubjectEvidenceDecoder;
import org.wildfly.security.x500.principal.X509SubjectAltNameEvidenceDecoder;

public class X509PeerCertificateChainEvidenceDecoderTest {
    @Test
    public void testDecodeX500Subject() throws Exception {
        X509PeerCertificateChainEvidence evidence = new X509PeerCertificateChainEvidence(X509PeerCertificateChainEvidenceDecoderTest.populateCertificateChain());
        X500SubjectEvidenceDecoder decoder = new X500SubjectEvidenceDecoder();
        Assert.assertEquals((Object)"CN=bob0", (Object)decoder.getPrincipal((Evidence)evidence).getName());
    }

    @Test
    public void testDecodeX509SubjectAltName() throws Exception {
        X509PeerCertificateChainEvidence evidence = new X509PeerCertificateChainEvidence(X509PeerCertificateChainEvidenceDecoderTest.populateCertificateChain());
        X509SubjectAltNameEvidenceDecoder decoder = new X509SubjectAltNameEvidenceDecoder(2);
        Assert.assertEquals((Object)"bob0.example.com", (Object)decoder.getPrincipal((Evidence)evidence).getName());
        decoder = new X509SubjectAltNameEvidenceDecoder(1);
        Assert.assertEquals((Object)"bob0@example.com", (Object)decoder.getPrincipal((Evidence)evidence).getName());
        decoder = new X509SubjectAltNameEvidenceDecoder(1, 1);
        Assert.assertEquals((Object)"bob0@anotherexample.com", (Object)decoder.getPrincipal((Evidence)evidence).getName());
        decoder = new X509SubjectAltNameEvidenceDecoder(4, 1);
        Assert.assertEquals(null, (Object)decoder.getPrincipal((Evidence)evidence));
    }

    @Test
    public void testAggregateDecoder() throws Exception {
        X509PeerCertificateChainEvidence evidence = new X509PeerCertificateChainEvidence(X509PeerCertificateChainEvidenceDecoderTest.populateCertificateChain());
        X509SubjectAltNameEvidenceDecoder dnsDecoder = new X509SubjectAltNameEvidenceDecoder(1, 1);
        X509SubjectAltNameEvidenceDecoder directoryNameDecoder = new X509SubjectAltNameEvidenceDecoder(4);
        X500SubjectEvidenceDecoder subjectDecoder = new X500SubjectEvidenceDecoder();
        EvidenceDecoder aggregateDecoder = EvidenceDecoder.aggregate((EvidenceDecoder[])new EvidenceDecoder[]{directoryNameDecoder, subjectDecoder, dnsDecoder});
        Assert.assertEquals((Object)"CN=bob0", (Object)aggregateDecoder.getPrincipal((Evidence)evidence).getName());
        aggregateDecoder = EvidenceDecoder.aggregate((EvidenceDecoder[])new EvidenceDecoder[]{directoryNameDecoder, dnsDecoder, subjectDecoder});
        Assert.assertEquals((Object)"bob0@anotherexample.com", (Object)aggregateDecoder.getPrincipal((Evidence)evidence).getName());
        aggregateDecoder = EvidenceDecoder.aggregate((EvidenceDecoder[])new EvidenceDecoder[]{directoryNameDecoder});
        Assert.assertEquals(null, (Object)aggregateDecoder.getPrincipal((Evidence)evidence));
    }

    @Test
    public void testDecodeWrongEvidenceType() {
        X509SubjectAltNameEvidenceDecoder dnsDecoder = new X509SubjectAltNameEvidenceDecoder(1, 1);
        PasswordGuessEvidence passwordGuessEvidence = new PasswordGuessEvidence("secret".toCharArray());
        Assert.assertEquals(null, (Object)dnsDecoder.getPrincipal((Evidence)passwordGuessEvidence));
    }

    @Test
    public void testEvidenceDecoderWithRewriting() throws Exception {
        X509SubjectAltNameEvidenceDecoder dnsDecoder = new X509SubjectAltNameEvidenceDecoder(1, 1);
        X509SubjectAltNameEvidenceDecoder directoryNameDecoder = new X509SubjectAltNameEvidenceDecoder(4);
        X500SubjectEvidenceDecoder subjectDecoder = new X500SubjectEvidenceDecoder();
        EvidenceDecoder aggregateDecoder = EvidenceDecoder.aggregate((EvidenceDecoder[])new EvidenceDecoder[]{directoryNameDecoder, dnsDecoder, subjectDecoder});
        X500AttributePrincipalDecoder cnDecoder = new X500AttributePrincipalDecoder("2.5.4.3");
        RegexNameRewriter cnValueRegex = new RegexNameRewriter(Pattern.compile(".*([0-9]+)$"), "$1", true);
        RegexNameRewriter dnsRegex = new RegexNameRewriter(Pattern.compile("(.*)@.*\\.com"), "$1", true);
        FileSystemSecurityRealm fileSystemSecurityRealm = this.createSecurityRealm();
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> roles.contains("Admin") ? LoginPermission.getInstance() : PermissionVerifier.NONE).setEvidenceDecoder(aggregateDecoder).setPrincipalDecoder((PrincipalDecoder)cnDecoder).setPreRealmRewriter(NameRewriter.chain((NameRewriter)cnValueRegex, (NameRewriter)dnsRegex)).build();
        X509PeerCertificateChainEvidence evidence = new X509PeerCertificateChainEvidence(X509PeerCertificateChainEvidenceDecoderTest.populateCertificateChain(true));
        ServerAuthenticationContext sac = securityDomain.createNewAuthenticationContext();
        Assert.assertFalse((boolean)sac.verifyEvidence((Evidence)evidence));
        sac.setDecodedEvidencePrincipal((Evidence)evidence);
        Assert.assertEquals((Object)"bob0@anotherexample.com", (Object)evidence.getDecodedPrincipal().getName());
        sac.setAuthenticationPrincipal(evidence.getDecodedPrincipal());
        Assert.assertEquals((Object)"bob0", (Object)sac.getAuthenticationPrincipal().getName());
        Assert.assertFalse((boolean)sac.authorize());
        evidence = new X509PeerCertificateChainEvidence(X509PeerCertificateChainEvidenceDecoderTest.populateCertificateChain(false));
        sac = securityDomain.createNewAuthenticationContext();
        Assert.assertFalse((boolean)sac.verifyEvidence((Evidence)evidence));
        sac.setDecodedEvidencePrincipal((Evidence)evidence);
        Assert.assertEquals((Object)"CN=bob0", (Object)evidence.getDecodedPrincipal().getName());
        sac.setAuthenticationPrincipal(evidence.getDecodedPrincipal());
        Assert.assertEquals((Object)"0", (Object)sac.getAuthenticationPrincipal().getName());
        Assert.assertTrue((boolean)sac.authorize());
    }

    @Test
    public void testDefaultEvidenceDecoder() throws Exception {
        X500AttributePrincipalDecoder cnDecoder = new X500AttributePrincipalDecoder("2.5.4.3");
        RegexNameRewriter cnValueRegex = new RegexNameRewriter(Pattern.compile(".*([0-9]+)$"), "$1", true);
        FileSystemSecurityRealm fileSystemSecurityRealm = this.createSecurityRealm();
        SecurityDomain securityDomain = SecurityDomain.builder().setDefaultRealmName("default").addRealm("default", (SecurityRealm)fileSystemSecurityRealm).build().setPermissionMapper((permissionMappable, roles) -> roles.contains("Admin") ? LoginPermission.getInstance() : PermissionVerifier.NONE).setPrincipalDecoder((PrincipalDecoder)cnDecoder).setPreRealmRewriter(NameRewriter.chain((NameRewriter[])new NameRewriter[]{cnValueRegex})).build();
        ServerAuthenticationContext sac = securityDomain.createNewAuthenticationContext();
        X509PeerCertificateChainEvidence evidence = new X509PeerCertificateChainEvidence(X509PeerCertificateChainEvidenceDecoderTest.populateCertificateChain(false));
        Assert.assertFalse((boolean)sac.verifyEvidence((Evidence)evidence));
        sac.setDecodedEvidencePrincipal((Evidence)evidence);
        Assert.assertEquals((Object)"CN=bob0", (Object)evidence.getDecodedPrincipal().getName());
        sac.setAuthenticationPrincipal(evidence.getDecodedPrincipal());
        Assert.assertEquals((Object)"0", (Object)sac.getAuthenticationPrincipal().getName());
        Assert.assertTrue((boolean)sac.authorize());
    }

    private static X509Certificate[] populateCertificateChain() throws Exception {
        return X509PeerCertificateChainEvidenceDecoderTest.populateCertificateChain(true);
    }

    private static X509Certificate[] populateCertificateChain(boolean includeSubjectAltNames) throws Exception {
        KeyPairGenerator keyPairGenerator;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        KeyPair[] keyPairs = new KeyPair[5];
        for (int i = 0; i < keyPairs.length; ++i) {
            keyPairs[i] = keyPairGenerator.generateKeyPair();
        }
        X509Certificate[] orderedCertificates = new X509Certificate[5];
        for (int i = 0; i < orderedCertificates.length; ++i) {
            X509CertificateBuilder builder = new X509CertificateBuilder();
            X500PrincipalBuilder principalBuilder = new X500PrincipalBuilder();
            principalBuilder.addItem(X500AttributeTypeAndValue.create((String)"2.5.4.3", (ASN1Encodable)ASN1Encodable.ofUtf8String((String)("bob" + i))));
            X500Principal dn = principalBuilder.build();
            builder.setSubjectDn(dn);
            if (i == orderedCertificates.length - 1) {
                builder.setIssuerDn(dn);
                builder.setSigningKey(keyPairs[i].getPrivate());
            } else {
                principalBuilder = new X500PrincipalBuilder();
                principalBuilder.addItem(X500AttributeTypeAndValue.create((String)"2.5.4.3", (ASN1Encodable)ASN1Encodable.ofUtf8String((String)("bob" + (i + 1)))));
                X500Principal issuerDn = principalBuilder.build();
                builder.setIssuerDn(issuerDn);
                builder.setSigningKey(keyPairs[i + 1].getPrivate());
                if (includeSubjectAltNames) {
                    builder.addExtension((X509CertificateExtension)new SubjectAlternativeNamesExtension(true, Arrays.asList(new GeneralName.RFC822Name("bob" + i + "@example.com"), new GeneralName.DNSName("bob" + i + ".example.com"), new GeneralName.RFC822Name("bob" + i + "@anotherexample.com"))));
                }
            }
            builder.setSignatureAlgorithmName("SHA256withRSA");
            builder.setPublicKey(keyPairs[i].getPublic());
            orderedCertificates[i] = builder.build();
        }
        return orderedCertificates;
    }

    private FileSystemSecurityRealm createSecurityRealm() throws Exception {
        FileSystemSecurityRealm realm = new FileSystemSecurityRealm(this.getRootPath(true));
        this.addUser((ModifiableSecurityRealm)realm, "0", "Admin");
        this.addUser((ModifiableSecurityRealm)realm, "bob0", "Employee");
        return realm;
    }

    private Path getRootPath(boolean deleteIfExists) throws Exception {
        Path rootPath = Paths.get(this.getClass().getResource(File.separator).toURI()).resolve("filesystem-realm");
        if (rootPath.toFile().exists() && !deleteIfExists) {
            return rootPath;
        }
        return Files.walkFileTree(Files.createDirectories(rootPath, new FileAttribute[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private Path getRootPath() throws Exception {
        return this.getRootPath(true);
    }

    private void addUser(ModifiableSecurityRealm realm, String userName, String roles) throws RealmUnavailableException {
        MapAttributes attributes = new MapAttributes();
        attributes.addAll("Roles", Collections.singletonList(roles));
        ModifiableRealmIdentity realmIdentity = realm.getRealmIdentityForUpdate((Principal)new NamePrincipal(userName));
        realmIdentity.create();
        realmIdentity.setAttributes((Attributes)attributes);
        realmIdentity.dispose();
    }
}

