/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.HashSet;
import mockit.Mock;
import mockit.MockUp;
import mockit.integration.junit4.JMockit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.security.audit.AuditEndpoint;
import org.wildfly.security.audit.EventPriority;
import org.wildfly.security.audit.FileAuditEndpoint;
import org.wildfly.security.util.TestClock;

@RunWith(value=JMockit.class)
public class FileAuditEndpointTest {
    static File logDirFile;
    static Path logFile;
    static ZoneId UTC;
    static TestClock clock;

    @BeforeClass
    public static void init() throws Exception {
        logDirFile = new File(FileAuditEndpointTest.class.getResource(".").getFile(), "audit");
        logFile = Paths.get(logDirFile.getPath(), "audit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFileEncoding() throws Exception {
        Charset charset = StandardCharsets.UTF_16;
        AuditEndpoint endpoint = FileAuditEndpoint.builder().setLocation(logFile).setClock((Clock)clock).setCharset(charset).build();
        endpoint.accept((Object)EventPriority.CRITICAL, (Object)"testing log message");
        endpoint.close();
        this.assertFiles("audit");
        FileInputStream fis = null;
        BufferedReader br = null;
        try {
            fis = new FileInputStream(logFile.toFile());
            br = new BufferedReader(new InputStreamReader((InputStream)fis, charset));
            Assert.assertTrue((boolean)br.readLine().contains("testing log message"));
            this.safeClose(fis);
            this.safeClose(br);
        }
        catch (Throwable throwable) {
            this.safeClose(fis);
            this.safeClose(br);
            throw throwable;
        }
    }

    @Before
    public void initDir() {
        logDirFile.mkdirs();
        Assert.assertTrue((boolean)logDirFile.isDirectory());
        for (File file : logDirFile.listFiles()) {
            file.delete();
        }
        this.assertFiles(new String[0]);
    }

    @Before
    public void mockTime() {
        clock = new TestClock(Instant.EPOCH.truncatedTo(ChronoUnit.DAYS));
        new MockUp<File>(){

            @Mock
            public long lastModified() {
                return clock.millis();
            }
        };
    }

    private void assertFiles(String ... files) {
        HashSet<String> expected = new HashSet<String>(Arrays.asList(files));
        for (File file : logDirFile.listFiles()) {
            if (expected.remove(file.getName())) continue;
            Assert.fail((String)("Unexpected file " + file.getName()));
        }
        for (String missing : expected) {
            Assert.fail((String)("Missing file " + missing));
        }
    }

    private void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        UTC = ZoneId.of("UTC");
    }
}

