/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.server;

import java.security.Permission;
import java.security.Principal;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.realm.SimpleRealmEntry;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.auth.server.RealmUnavailableException;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityIdentity;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.ServerAuthenticationContext;
import org.wildfly.security.authz.Attributes;
import org.wildfly.security.authz.MapAttributes;
import org.wildfly.security.authz.Roles;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.permission.PermissionVerifier;

public class IdentityPropagationTest {
    private static SecurityDomain domain1;
    private static SecurityDomain domain2;
    private static SecurityDomain domain3;
    private static SecurityDomain domain4;
    private static SecurityDomain domain5;

    @BeforeClass
    public static void setupSecurityDomains() {
        SimpleMapBackedSecurityRealm realm1 = new SimpleMapBackedSecurityRealm();
        HashMap<String, Object> users = new HashMap<String, SimpleRealmEntry>();
        IdentityPropagationTest.addUser(users, "joe", "User");
        IdentityPropagationTest.addUser(users, "bob", "User");
        realm1.setIdentityMap(users);
        SimpleMapBackedSecurityRealm realm2 = new SimpleMapBackedSecurityRealm();
        users = new HashMap();
        IdentityPropagationTest.addUser(users, "sam", "Manager");
        IdentityPropagationTest.addUser(users, "bob", "Manager");
        realm2.setIdentityMap(users);
        SecurityDomain.Builder builder = SecurityDomain.builder();
        builder.addRealm("users", (SecurityRealm)realm1).build();
        builder.addRealm("managers", (SecurityRealm)realm2).build();
        builder.setDefaultRealmName("users");
        builder.setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        domain1 = builder.build();
        builder = SecurityDomain.builder();
        builder.addRealm("usersRealm", (SecurityRealm)realm1).setRoleMapper(rolesToMap -> Roles.of((String)"UserRole")).build();
        builder.setDefaultRealmName("usersRealm");
        builder.setPermissionMapper((permissionMappable, roles) -> {
            if (permissionMappable.getPrincipal().getName().equals("joe")) {
                return PermissionVerifier.from((Permission)new LoginPermission());
            }
            return PermissionVerifier.NONE;
        });
        domain2 = builder.build();
        builder = SecurityDomain.builder();
        builder.addRealm("managersRealm", (SecurityRealm)realm2).setRoleMapper(rolesToMap -> Roles.of((String)"ManagerRole")).build();
        builder.setDefaultRealmName("managersRealm");
        builder.setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        HashSet<SecurityDomain> trustedSecurityDomains = new HashSet<SecurityDomain>();
        trustedSecurityDomains.add(domain2);
        builder.setTrustedSecurityDomainPredicate(trustedSecurityDomains::contains);
        domain3 = builder.build();
        builder = SecurityDomain.builder();
        builder.addRealm("customRealm", (SecurityRealm)new CustomRealm()).build();
        builder.setDefaultRealmName("customRealm");
        builder.setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        domain4 = builder.build();
        builder = SecurityDomain.builder();
        builder.addRealm("usersRealm", (SecurityRealm)realm1).setRoleMapper(rolesToMap -> Roles.of((String)"UserRole")).build();
        builder.setDefaultRealmName("usersRealm");
        trustedSecurityDomains = new HashSet();
        trustedSecurityDomains.add(domain4);
        builder.setTrustedSecurityDomainPredicate(trustedSecurityDomains::contains);
        builder.setPermissionMapper((permissionMappable, roles) -> PermissionVerifier.from((Permission)new LoginPermission()));
        domain5 = builder.build();
    }

    @Test
    public void testInflowFromTrustedIdentityWithCommonRealm() throws Exception {
        ServerAuthenticationContext context = domain2.createNewAuthenticationContext();
        SecurityIdentity establishedIdentity = this.getIdentityFromDomain(domain1, "joe");
        Assert.assertTrue((boolean)context.importIdentity(establishedIdentity));
        SecurityIdentity inflowedIdentity = context.getAuthorizedIdentity();
        Assert.assertEquals((Object)"joe", (Object)inflowedIdentity.getPrincipal().getName());
        Assert.assertEquals((Object)domain2, (Object)inflowedIdentity.getSecurityDomain());
        Assert.assertTrue((boolean)inflowedIdentity.getRoles().contains("UserRole"));
    }

    @Test
    public void testInflowFromTrustedIdentityWithoutCommonRealm() throws Exception {
        ServerAuthenticationContext context = domain3.createNewAuthenticationContext();
        SecurityIdentity establishedIdentity = this.getIdentityFromDomain(domain2, "bob");
        Assert.assertTrue((boolean)context.importIdentity(establishedIdentity));
        SecurityIdentity inflowedIdentity = context.getAuthorizedIdentity();
        Assert.assertEquals((Object)"bob", (Object)inflowedIdentity.getPrincipal().getName());
        Assert.assertEquals((Object)domain3, (Object)inflowedIdentity.getSecurityDomain());
        Assert.assertTrue((boolean)inflowedIdentity.getRoles().contains("ManagerRole"));
    }

    @Test
    public void testInflowFromUntrustedIdentity() throws Exception {
        ServerAuthenticationContext context = domain2.createNewAuthenticationContext();
        SecurityIdentity establishedIdentity = this.getIdentityFromDomain(domain3, "bob");
        Assert.assertFalse((boolean)context.importIdentity(establishedIdentity));
        try {
            context.getAuthorizedIdentity();
            Assert.fail((String)"Expected IllegalStateException not thrown");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testInflowFromAnonymousIdentity() throws Exception {
        ServerAuthenticationContext context = domain2.createNewAuthenticationContext();
        SecurityIdentity establishedIdentity = domain1.getCurrentSecurityIdentity();
        Assert.assertTrue((boolean)context.importIdentity(establishedIdentity));
        SecurityIdentity inflowedIdentity = context.getAuthorizedIdentity();
        Assert.assertEquals((Object)domain2.getAnonymousSecurityIdentity(), (Object)inflowedIdentity);
    }

    @Test
    public void testInflowFromSameDomain() throws Exception {
        ServerAuthenticationContext context = domain2.createNewAuthenticationContext();
        SecurityIdentity establishedIdentity = this.getIdentityFromDomain(domain2, "joe");
        Assert.assertTrue((boolean)context.importIdentity(establishedIdentity));
        SecurityIdentity inflowedIdentity = context.getAuthorizedIdentity();
        Assert.assertEquals((Object)establishedIdentity.getSecurityDomain(), (Object)inflowedIdentity.getSecurityDomain());
        Assert.assertEquals((Object)establishedIdentity.getPrincipal().getName(), (Object)inflowedIdentity.getPrincipal().getName());
        Assert.assertEquals((Object)establishedIdentity.getRealmInfo(), (Object)inflowedIdentity.getRealmInfo());
        Assert.assertTrue((boolean)inflowedIdentity.getAttributes().get("roles").containsAll((Collection)establishedIdentity.getAttributes().get("roles")));
    }

    @Test
    public void testInflowSecurityIdentityWithCustomPrincipal() throws Exception {
        ServerAuthenticationContext context = domain4.createNewAuthenticationContext();
        Assert.assertTrue((boolean)context.verifyEvidence(new Evidence(){

            public Principal getPrincipal() {
                return new CustomRealm.CustomPrincipal("joe");
            }
        }));
        Assert.assertTrue((boolean)context.authorize());
        SecurityIdentity establishedIdentity = context.getAuthorizedIdentity();
        context = domain5.createNewAuthenticationContext();
        Assert.assertTrue((boolean)context.importIdentity(establishedIdentity));
        SecurityIdentity inflowedIdentity = context.getAuthorizedIdentity();
        Assert.assertEquals((Object)"joe", (Object)inflowedIdentity.getPrincipal().getName());
        Assert.assertEquals((Object)domain5, (Object)inflowedIdentity.getSecurityDomain());
        Assert.assertTrue((boolean)inflowedIdentity.getRoles().contains("UserRole"));
    }

    private static void addUser(Map<String, SimpleRealmEntry> securityRealm, String userName, String roles) {
        MapAttributes attributes = new MapAttributes();
        attributes.addAll("Roles", Collections.singletonList(roles));
        securityRealm.put(userName, new SimpleRealmEntry(Collections.emptyList(), (Attributes)attributes));
    }

    private SecurityIdentity getIdentityFromDomain(SecurityDomain securityDomain, String userName) {
        return securityDomain.getAnonymousSecurityIdentity().createRunAsIdentity(userName, false);
    }

    private static class CustomRealm
    implements SecurityRealm {
        private CustomRealm() {
        }

        public RealmIdentity getRealmIdentity(Principal principal) throws RealmUnavailableException {
            return new CustomRealmIdentity(new CustomPrincipal(principal.getName()));
        }

        public RealmIdentity getRealmIdentity(Evidence evidence) throws RealmUnavailableException {
            throw new RealmUnavailableException();
        }

        public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
            return SupportLevel.UNSUPPORTED;
        }

        private static class CustomPrincipal
        implements Principal {
            private final String name;

            public CustomPrincipal(String name) {
                this.name = name;
            }

            @Override
            public String getName() {
                return this.name;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                CustomPrincipal that = (CustomPrincipal)o;
                return this.name.equals(that.name);
            }

            @Override
            public int hashCode() {
                return this.name.hashCode();
            }

            @Override
            public String toString() {
                return this.name;
            }
        }

        private class CustomRealmIdentity
        implements RealmIdentity {
            CustomPrincipal principal;

            public CustomRealmIdentity(CustomPrincipal principal) {
                this.principal = principal;
            }

            public Principal getRealmIdentityPrincipal() {
                return this.principal;
            }

            public SupportLevel getCredentialAcquireSupport(Class<? extends Credential> credentialType, String algorithmName, AlgorithmParameterSpec parameterSpec) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }

            public <C extends Credential> C getCredential(Class<C> credentialType) throws RealmUnavailableException {
                return null;
            }

            public SupportLevel getEvidenceVerifySupport(Class<? extends Evidence> evidenceType, String algorithmName) throws RealmUnavailableException {
                return SupportLevel.UNSUPPORTED;
            }

            public boolean verifyEvidence(Evidence evidence) throws RealmUnavailableException {
                return this.principal != null;
            }

            public boolean exists() throws RealmUnavailableException {
                return this.principal != null;
            }
        }
    }
}

