/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.audit;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import java.io.FilePermission;
import java.io.Reader;
import java.io.StringReader;
import java.security.Permission;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.wildfly.security.audit.JsonSecurityEventFormatter;
import org.wildfly.security.auth.realm.SimpleMapBackedSecurityRealm;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.auth.server.event.Rfc3164SyslogEvent;
import org.wildfly.security.auth.server.event.Rfc5424SyslogEvent;
import org.wildfly.security.auth.server.event.SecurityAuthenticationSuccessfulEvent;
import org.wildfly.security.auth.server.event.SecurityEvent;
import org.wildfly.security.auth.server.event.SecurityEventVisitor;
import org.wildfly.security.auth.server.event.SecurityPermissionCheckFailedEvent;

public class JsonSecurityEventFormatterTest {
    private static SecurityEventVisitor<?, String> jsonFormatter;
    private static SecurityDomain securityDomain;

    @BeforeClass
    public static void createDomain() {
        jsonFormatter = JsonSecurityEventFormatter.builder().build();
        securityDomain = SecurityDomain.builder().addRealm("Simple", (SecurityRealm)new SimpleMapBackedSecurityRealm()).build().setDefaultRealmName("Simple").build();
    }

    private JsonObject baseTest(SecurityEvent event) {
        String formatted = (String)event.accept(jsonFormatter, null);
        System.out.println(formatted);
        JsonReader reader = Json.createReader((Reader)new StringReader(formatted));
        JsonObject jsonObject = reader.readObject();
        Assert.assertNotNull((String)"Event Time", (Object)jsonObject.getString("event-time"));
        JsonObject securityIdentity = jsonObject.getJsonObject("security-identity");
        Assert.assertEquals((String)"Name", (Object)"anonymous", (Object)securityIdentity.getString("name"));
        Assert.assertNotNull((String)"Creation Time", (Object)securityIdentity.getString("creation-time"));
        return jsonObject;
    }

    @Test
    public void testRfc3164SyslogEvent() {
        JsonObject jsonObject = this.baseTest((SecurityEvent)new Rfc3164SyslogEvent(securityDomain.getCurrentSecurityIdentity()));
        Assert.assertEquals((String)"Expected Event", (Object)"Rfc3164SyslogEvent", (Object)jsonObject.getString("event"));
        Assert.assertEquals((String)"Expected Format", (Object)"RFC3164", (Object)jsonObject.getString("syslog-format"));
    }

    @Test
    public void testRfc5424SyslogEvent() {
        JsonObject jsonObject = this.baseTest((SecurityEvent)new Rfc5424SyslogEvent(securityDomain.getCurrentSecurityIdentity()));
        Assert.assertEquals((String)"Expected Event", (Object)"Rfc5424SyslogEvent", (Object)jsonObject.getString("event"));
        Assert.assertEquals((String)"Expected Format", (Object)"RFC5424", (Object)jsonObject.getString("syslog-format"));
    }

    @Test
    public void testAuthenticationSuccessful() {
        JsonObject jsonObject = this.baseTest((SecurityEvent)new SecurityAuthenticationSuccessfulEvent(securityDomain.getCurrentSecurityIdentity()));
        Assert.assertEquals((String)"Expected Event", (Object)"SecurityAuthenticationSuccessfulEvent", (Object)jsonObject.getString("event"));
        Assert.assertEquals((String)"Success", (Object)true, (Object)jsonObject.getBoolean("success"));
    }

    @Test
    public void testPermissionCheckFailed() {
        JsonObject jsonObject = this.baseTest((SecurityEvent)new SecurityPermissionCheckFailedEvent(securityDomain.getCurrentSecurityIdentity(), (Permission)new FilePermission("/etc", "read")));
        Assert.assertEquals((String)"Expected Event", (Object)"SecurityPermissionCheckFailedEvent", (Object)jsonObject.getString("event"));
        Assert.assertEquals((String)"Success", (Object)false, (Object)jsonObject.getBoolean("success"));
        JsonObject permission = jsonObject.getJsonObject("permission");
        Assert.assertEquals((String)"Permission Type", (Object)"java.io.FilePermission", (Object)permission.getString("type"));
        Assert.assertEquals((String)"Permission Actions", (Object)"read", (Object)permission.getString("actions"));
        Assert.assertEquals((String)"Permission Name", (Object)"/etc", (Object)permission.getString("name"));
    }
}

