/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ldap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.SupportLevel;
import org.wildfly.security.auth.principal.NamePrincipal;
import org.wildfly.security.auth.realm.ldap.LdapSecurityRealmBuilder;
import org.wildfly.security.auth.server.ModifiableSecurityRealm;
import org.wildfly.security.auth.server.RealmIdentity;
import org.wildfly.security.evidence.Evidence;
import org.wildfly.security.evidence.X509PeerCertificateChainEvidence;
import org.wildfly.security.ldap.LdapTestSuite;

public class X509EvidenceVerificationSuiteChild {
    private static final String LDAP_DIRECTORY_LOCATION = "./target/test-classes/ldap";
    private static final String LDIF_LOCATION = "/elytron-x509-verification.ldif";

    @After
    public void cleanUpLdapFiles() throws Exception {
        File workingDirLDIF = new File(LDAP_DIRECTORY_LOCATION);
        if (workingDirLDIF.exists()) {
            Files.copy(Paths.get(workingDirLDIF + LDIF_LOCATION + ".bak", new String[0]), Paths.get(workingDirLDIF + LDIF_LOCATION, new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Test
    public void testX509Auth() throws Exception {
        this.testX509AuthInternal("scarab");
    }

    @Test
    public void testX509AuthBinary() throws Exception {
        this.testX509AuthInternal("scarab_binary");
    }

    private void testX509AuthInternal(String name) throws Exception {
        ModifiableSecurityRealm securityRealm = LdapSecurityRealmBuilder.builder().setDirContextSupplier(LdapTestSuite.dirContextFactory.create()).identityMapping().setSearchDn("dc=elytron,dc=wildfly,dc=org").setRdnIdentifier("uid").build().x509EvidenceVerifier().addSerialNumberCertificateVerifier("x509serialNumber").addSubjectDnCertificateVerifier("x509subject").addDigestCertificateVerifier("x509digest", "SHA-1").addEncodedCertificateVerifier("usercertificate").build().build();
        RealmIdentity realmIdentity = securityRealm.getRealmIdentity((Principal)new NamePrincipal(name));
        SupportLevel credentialSupport = realmIdentity.getEvidenceVerifySupport(X509PeerCertificateChainEvidence.class, null);
        Assert.assertEquals((String)"Identity verification level support", (Object)SupportLevel.POSSIBLY_SUPPORTED, (Object)credentialSupport);
        X509Certificate scarab = this.loadCertificate("scarab", "/ca/jks/scarab.keystore");
        X509Certificate ca = this.loadCertificate("ca", "/ca/jks/ca.keystore");
        X509PeerCertificateChainEvidence evidence = new X509PeerCertificateChainEvidence(new X509Certificate[]{scarab, ca});
        Assert.assertTrue((boolean)realmIdentity.verifyEvidence((Evidence)evidence));
    }

    private X509Certificate loadCertificate(String alias, String storePath) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        try (InputStream in = X509EvidenceVerificationSuiteChild.class.getResourceAsStream(storePath);){
            ks.load(in, "Elytron".toCharArray());
            Certificate result = ks.getCertificate(alias);
            X509Certificate x509Certificate = (X509Certificate)result;
            return x509Certificate;
        }
    }
}

