/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.x500;

import java.security.Principal;
import javax.security.auth.x500.X500Principal;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.security.auth.server.PrincipalDecoder;
import org.wildfly.security.x500.principal.X500AttributePrincipalDecoder;

public class X500AttributePrincipalDecoderTest {
    @Test
    public void testDecodeInReverse() {
        X500Principal principal = new X500Principal("dc=com,dc=redhat,dc=example,ou=people,cn=bob.smith");
        X500AttributePrincipalDecoder decoder = new X500AttributePrincipalDecoder("0.9.2342.19200300.100.1.25", true);
        Assert.assertEquals((Object)"example.redhat.com", (Object)decoder.getName((Principal)principal));
        decoder = new X500AttributePrincipalDecoder("0.9.2342.19200300.100.1.25", 1, true);
        Assert.assertEquals((Object)"example", (Object)decoder.getName((Principal)principal));
    }

    @Test
    public void testDecodeAttributeWithSubrange() {
        X500Principal principal = new X500Principal("cn=bob.smith,dc=example,dc=redhat,dc=com");
        X500AttributePrincipalDecoder decoder = new X500AttributePrincipalDecoder("0.9.2342.19200300.100.1.25", 1, 1);
        Assert.assertEquals((Object)"redhat", (Object)decoder.getName((Principal)principal));
        decoder = new X500AttributePrincipalDecoder("0.9.2342.19200300.100.1.25", 1, 2);
        Assert.assertEquals((Object)"redhat.com", (Object)decoder.getName((Principal)principal));
        principal = new X500Principal("dc=com,dc=redhat,dc=jboss,dc=example,ou=people,cn=bob.smith");
        decoder = new X500AttributePrincipalDecoder("0.9.2342.19200300.100.1.25", 1, 3, true);
        Assert.assertEquals((Object)"jboss.redhat.com", (Object)decoder.getName((Principal)principal));
    }

    @Test
    public void testDecodeWithAggregation() {
        X500Principal principal = new X500Principal("cn=bob.smith,cn=bob,ou=people,dc=example,dc=redhat,dc=com");
        X500AttributePrincipalDecoder dcDecoder = new X500AttributePrincipalDecoder("0.9.2342.19200300.100.1.25");
        X500AttributePrincipalDecoder cnDecoder = new X500AttributePrincipalDecoder("2.5.4.3", 1);
        PrincipalDecoder aggregateDecoder = PrincipalDecoder.aggregate((PrincipalDecoder[])new PrincipalDecoder[]{cnDecoder, dcDecoder});
        Assert.assertEquals((Object)"bob.smith", (Object)aggregateDecoder.getName((Principal)principal));
        aggregateDecoder = PrincipalDecoder.aggregate((PrincipalDecoder[])new PrincipalDecoder[]{dcDecoder, cnDecoder});
        Assert.assertEquals((Object)"example.redhat.com", (Object)aggregateDecoder.getName((Principal)principal));
        principal = new X500Principal("cn=bob.smith,ou=people,dc=example,dc=redhat");
        cnDecoder = new X500AttributePrincipalDecoder("2.5.4.3");
        X500AttributePrincipalDecoder ouDecoder = new X500AttributePrincipalDecoder("2.5.4.11", 1);
        dcDecoder = new X500AttributePrincipalDecoder("0.9.2342.19200300.100.1.25", 1);
        X500AttributePrincipalDecoder dcDecoder1 = new X500AttributePrincipalDecoder("0.9.2342.19200300.100.1.25", 1, 1);
        aggregateDecoder = PrincipalDecoder.aggregate((PrincipalDecoder[])new PrincipalDecoder[]{dcDecoder1, dcDecoder, ouDecoder, cnDecoder});
        Assert.assertEquals((Object)"redhat", (Object)aggregateDecoder.getName((Principal)principal));
        aggregateDecoder = PrincipalDecoder.aggregate((PrincipalDecoder[])new PrincipalDecoder[]{dcDecoder, dcDecoder1, ouDecoder, cnDecoder});
        Assert.assertEquals((Object)"example", (Object)aggregateDecoder.getName((Principal)principal));
        aggregateDecoder = PrincipalDecoder.aggregate((PrincipalDecoder[])new PrincipalDecoder[]{cnDecoder, dcDecoder1, dcDecoder, ouDecoder});
        Assert.assertEquals((Object)"bob.smith", (Object)aggregateDecoder.getName((Principal)principal));
        principal = new X500Principal("cn=bob.smith,dc=example,dc=redhat");
        aggregateDecoder = PrincipalDecoder.aggregate((PrincipalDecoder[])new PrincipalDecoder[]{ouDecoder});
        Assert.assertNull((Object)aggregateDecoder.getName((Principal)principal));
        aggregateDecoder = PrincipalDecoder.aggregate((PrincipalDecoder[])new PrincipalDecoder[]{dcDecoder, ouDecoder});
        Assert.assertEquals((Object)"example", (Object)aggregateDecoder.getName((Principal)principal));
        aggregateDecoder = PrincipalDecoder.aggregate((PrincipalDecoder[])new PrincipalDecoder[]{dcDecoder, ouDecoder, dcDecoder1});
        Assert.assertEquals((Object)"example", (Object)aggregateDecoder.getName((Principal)principal));
    }

    @Test
    public void testDecodeWithConcatenation() {
        X500Principal principal = new X500Principal("cn=bob.smith,cn=bob,ou=people,dc=example,dc=redhat,dc=com");
        X500AttributePrincipalDecoder dcDecoder = new X500AttributePrincipalDecoder("0.9.2342.19200300.100.1.25");
        X500AttributePrincipalDecoder cnDecoder = new X500AttributePrincipalDecoder("2.5.4.3", 1);
        PrincipalDecoder concatenatingDecoder = PrincipalDecoder.concatenating((PrincipalDecoder)cnDecoder, (String)"@", (PrincipalDecoder)dcDecoder);
        Assert.assertEquals((Object)"bob.smith@example.redhat.com", (Object)concatenatingDecoder.getName((Principal)principal));
        principal = new X500Principal("cn=bob.smith,ou=people,dc=example,dc=redhat");
        cnDecoder = PrincipalDecoder.concatenating((PrincipalDecoder)PrincipalDecoder.constant((String)"cn"), (String)"=", (PrincipalDecoder)new X500AttributePrincipalDecoder("2.5.4.3"));
        PrincipalDecoder ouDecoder = PrincipalDecoder.concatenating((PrincipalDecoder)PrincipalDecoder.constant((String)"ou"), (String)"=", (PrincipalDecoder)new X500AttributePrincipalDecoder("2.5.4.11", 1));
        dcDecoder = PrincipalDecoder.concatenating((PrincipalDecoder)PrincipalDecoder.constant((String)"dc"), (String)"=", (PrincipalDecoder)new X500AttributePrincipalDecoder("0.9.2342.19200300.100.1.25", 1));
        PrincipalDecoder dcDecoder1 = PrincipalDecoder.concatenating((PrincipalDecoder)PrincipalDecoder.constant((String)"dc"), (String)"=", (PrincipalDecoder)new X500AttributePrincipalDecoder("0.9.2342.19200300.100.1.25", 1, 1));
        concatenatingDecoder = PrincipalDecoder.concatenating((String)",", (PrincipalDecoder[])new PrincipalDecoder[]{dcDecoder1, dcDecoder, ouDecoder, cnDecoder});
        Assert.assertEquals((Object)"dc=redhat,dc=example,ou=people,cn=bob.smith", (Object)concatenatingDecoder.getName((Principal)principal));
    }

    @Test
    public void testDecodeWithRequiredAttributes() {
        X500AttributePrincipalDecoder decoder = new X500AttributePrincipalDecoder("2.5.4.3", ",", 0, 2, false, false, new String[]{"2.5.4.3", "2.5.4.11"});
        X500Principal principal = new X500Principal("cn=bob.smith,cn=bsmith,dc=example,dc=redhat,dc=com");
        Assert.assertEquals(null, (Object)decoder.getName((Principal)principal));
        principal = new X500Principal("cn=bob.smith,cn=bsmith,ou=people,dc=example,dc=redhat,dc=com");
        Assert.assertEquals((Object)"bob.smith,bsmith", (Object)decoder.getName((Principal)principal));
    }
}

