/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.pem;

import java.io.Serializable;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.wildfly.security.asn1.ASN1Exception;
import org.wildfly.security.pem.ElytronMessages;

public class ElytronMessages_$logger
extends DelegatingBasicLogger
implements ElytronMessages,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ElytronMessages_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String malformedPemContent = "ELY03010: Malformed PEM content at offset %d";
    private static final String invalidPemType = "ELY03011: Invalid PEM type (expected \"%s\", got \"%s\"";
    private static final String certificateParseError = "ELY03012: Certificate parse error";
    private static final String publicKeyParseError = "ELY03023: PublicKey parse error";
    private static final String privateKeyParseError = "ELY03033: PrivateKey parse error";
    private static final String asnUnrecognisedAlgorithm = "ELY07001: Unrecognized encoding algorithm [%s]";
    private static final String asnUnexpectedTag = "ELY07004: Unexpected ASN.1 tag encountered";

    public ElytronMessages_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String malformedPemContent$str() {
        return malformedPemContent;
    }

    @Override
    public final IllegalArgumentException malformedPemContent(long offset) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.malformedPemContent$str(), offset));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPemType$str() {
        return invalidPemType;
    }

    @Override
    public final IllegalArgumentException invalidPemType(String expected, String actual) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidPemType$str(), expected, actual));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String certificateParseError$str() {
        return certificateParseError;
    }

    @Override
    public final IllegalArgumentException certificateParseError(CertificateException cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.certificateParseError$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String publicKeyParseError$str() {
        return publicKeyParseError;
    }

    @Override
    public final IllegalArgumentException publicKeyParseError(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.publicKeyParseError$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String privateKeyParseError$str() {
        return privateKeyParseError;
    }

    @Override
    public final IllegalArgumentException privateKeyParseError(Throwable cause) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.privateKeyParseError$str(), new Object[0]), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String asnUnrecognisedAlgorithm$str() {
        return asnUnrecognisedAlgorithm;
    }

    @Override
    public final ASN1Exception asnUnrecognisedAlgorithm(String algorithm) {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnUnrecognisedAlgorithm$str(), algorithm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String asnUnexpectedTag$str() {
        return asnUnexpectedTag;
    }

    @Override
    public final ASN1Exception asnUnexpectedTag() {
        ASN1Exception result = new ASN1Exception(String.format(this.getLoggingLocale(), this.asnUnexpectedTag$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

