/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ee.Manager;
import org.wildfly.clustering.ee.cache.ConcurrentManager;

public class ConcurrentManagerTestCase {
    private static final int KEYS = 10;
    private static final int SIZE = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws InterruptedException, ExecutionException {
        ConcurrentManager manager = new ConcurrentManager(ManagedObject::created, ManagedObject::closed);
        ArrayList keyFutures = new ArrayList(10);
        ExecutorService executor = Executors.newFixedThreadPool(10);
        try {
            for (int i = 0; i < 10; ++i) {
                ArrayList<Future<ManagedObject>> arrayList = new ArrayList<Future<ManagedObject>>(100);
                keyFutures.add(arrayList);
                for (int j = 0; j < 100; ++j) {
                    int n = i;
                    Callable<ManagedObject> task = () -> ConcurrentManagerTestCase.lambda$test$0((Manager)manager, n);
                    arrayList.add(executor.submit(task));
                }
            }
            for (List list : keyFutures) {
                for (Future future : list) {
                    future.get();
                }
            }
            for (List list : keyFutures) {
                for (Future future : list) {
                    ManagedObject object = (ManagedObject)future.get();
                    Assert.assertTrue((String)object.toString(), (boolean)object.isCreated());
                    Assert.assertTrue((String)object.toString(), (boolean)object.isClosed());
                }
            }
        }
        finally {
            executor.shutdown();
        }
    }

    private static /* synthetic */ ManagedObject lambda$test$0(Manager manager, int key) throws Exception {
        try (ManagedObject object = (ManagedObject)manager.apply((Object)key, ManagedObject::new);){
            Assert.assertTrue((boolean)object.isCreated());
            Assert.assertFalse((boolean)object.isClosed());
            Thread.sleep(10L);
            ManagedObject managedObject = object;
            return managedObject;
        }
    }

    private static class ManagedObject
    implements AutoCloseable {
        private volatile boolean created = false;
        private volatile boolean closed = false;
        private final Runnable closeTask;

        ManagedObject(Runnable closeTask) {
            this.closeTask = closeTask;
        }

        void created() {
            this.created = true;
        }

        boolean isCreated() {
            return this.created;
        }

        void closed() {
            this.closed = true;
        }

        boolean isClosed() {
            return this.closed;
        }

        @Override
        public void close() {
            this.closeTask.run();
        }
    }
}

