/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.function;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ee.cache.function.MapComputeFunction;
import org.wildfly.clustering.ee.cache.function.MapPutFunction;
import org.wildfly.clustering.ee.cache.function.MapRemoveFunction;
import org.wildfly.clustering.ee.cache.function.SetAddFunction;
import org.wildfly.clustering.ee.cache.function.SetRemoveFunction;

public class FunctionTestCase {
    @Test
    public void set() {
        Set result = (Set)new SetAddFunction((Object)"foo").apply(null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.contains("foo"));
        Set result2 = (Set)new SetAddFunction((Object)"bar").apply(null, (Object)result);
        Assert.assertNotNull((Object)result2);
        Assert.assertNotSame((Object)result, (Object)result2);
        Assert.assertTrue((boolean)result2.contains("foo"));
        Assert.assertTrue((boolean)result2.contains("bar"));
        Set result3 = (Set)new SetAddFunction(Set.of("baz", "qux")).apply(null, (Object)result2);
        Assert.assertNotNull((Object)result3);
        Assert.assertNotSame((Object)result2, (Object)result3);
        Assert.assertTrue((boolean)result3.contains("foo"));
        Assert.assertTrue((boolean)result3.contains("bar"));
        Assert.assertTrue((boolean)result3.contains("baz"));
        Assert.assertTrue((boolean)result3.contains("qux"));
        Set result4 = (Set)new SetRemoveFunction((Object)"foo").apply(null, (Object)result3);
        Assert.assertNotNull((Object)result4);
        Assert.assertNotSame((Object)result3, (Object)result4);
        Assert.assertFalse((boolean)result4.contains("foo"));
        Assert.assertTrue((boolean)result4.contains("bar"));
        Assert.assertTrue((boolean)result4.contains("baz"));
        Assert.assertTrue((boolean)result4.contains("qux"));
        Set result5 = (Set)new SetRemoveFunction(Set.of("bar", "baz")).apply(null, (Object)result4);
        Assert.assertNotNull((Object)result5);
        Assert.assertNotSame((Object)result4, (Object)result5);
        Assert.assertFalse((boolean)result5.contains("foo"));
        Assert.assertFalse((boolean)result5.contains("bar"));
        Assert.assertFalse((boolean)result5.contains("baz"));
        Assert.assertTrue((boolean)result5.contains("qux"));
        Set result6 = (Set)new SetRemoveFunction((Object)"qux").apply(null, (Object)result5);
        Assert.assertNull((Object)result6);
    }

    @Test
    public void map() {
        Map result = (Map)new MapPutFunction((Object)"foo", (Object)"a").apply(null, null);
        Assert.assertNotNull((Object)result);
        Assert.assertTrue((boolean)result.containsKey("foo"));
        Map result2 = (Map)new MapPutFunction((Object)"bar", (Object)"b").apply(null, (Object)result);
        Assert.assertNotNull((Object)result2);
        Assert.assertNotSame((Object)result, (Object)result2);
        Assert.assertTrue((boolean)result2.containsKey("foo"));
        Assert.assertTrue((boolean)result2.containsKey("bar"));
        Map result3 = (Map)new MapRemoveFunction((Object)"foo").apply(null, (Object)result2);
        Assert.assertNotNull((Object)result3);
        Assert.assertNotSame((Object)result2, (Object)result3);
        Assert.assertFalse((boolean)result3.containsKey("foo"));
        Assert.assertTrue((boolean)result3.containsKey("bar"));
        Map result4 = (Map)new MapRemoveFunction((Object)"bar").apply(null, (Object)result3);
        Assert.assertNull((Object)result4);
        Map result5 = (Map)new MapComputeFunction(Map.of("foo", "a", "bar", "b")).apply(null, (Object)result4);
        Assert.assertNotNull((Object)result5);
        Assert.assertEquals((long)2L, (long)result5.size());
        Assert.assertEquals((Object)"a", result5.get("foo"));
        Assert.assertEquals((Object)"b", result5.get("bar"));
        TreeMap<String, String> updates = new TreeMap<String, String>();
        updates.put("foo", null);
        updates.put("bar", "c");
        Map result6 = (Map)new MapComputeFunction(updates).apply(null, (Object)result5);
        Assert.assertNotNull((Object)result6);
        Assert.assertEquals((long)1L, (long)result6.size());
        Assert.assertFalse((boolean)result6.containsKey("foo"));
        Assert.assertEquals((Object)"c", result6.get("bar"));
        Map result7 = (Map)new MapComputeFunction(Collections.singletonMap("bar", null)).apply(null, (Object)result6);
        Assert.assertNull((Object)result7);
    }
}

