/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.offset;

import java.time.Duration;
import java.time.Instant;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ee.cache.offset.OffsetValue;

public class OffsetValueTestCase {
    @Test
    public void duration() {
        Duration forward = Duration.ofSeconds(1L);
        Duration backward = Duration.ofSeconds(-1L);
        OffsetValue value = OffsetValue.from((Duration)Duration.ZERO);
        Assert.assertTrue((boolean)value.getOffset().isZero());
        Assert.assertSame((Object)Duration.ZERO, (Object)value.getBasis());
        Assert.assertSame((Object)Duration.ZERO, (Object)value.get());
        Assert.assertSame((Object)backward, (Object)value.getOffset().apply((Object)backward));
        Assert.assertSame((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)Duration.ZERO));
        Assert.assertSame((Object)forward, (Object)value.getOffset().apply((Object)forward));
        value.set((Object)forward);
        Assert.assertFalse((boolean)value.getOffset().isZero());
        Assert.assertSame((Object)Duration.ZERO, (Object)value.getBasis());
        Assert.assertEquals((Object)forward, (Object)value.get());
        Assert.assertEquals((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)backward));
        Assert.assertEquals((Object)forward, (Object)value.getOffset().apply((Object)Duration.ZERO));
        OffsetValue rebaseValue = value.rebase();
        Assert.assertTrue((boolean)rebaseValue.getOffset().isZero());
        Assert.assertEquals((Object)forward, (Object)rebaseValue.getBasis());
        Assert.assertEquals((Object)forward, (Object)rebaseValue.get());
        Assert.assertEquals((Object)Duration.ZERO, (Object)rebaseValue.getOffset().apply((Object)Duration.ZERO));
        Assert.assertEquals((Object)forward, (Object)rebaseValue.getOffset().apply((Object)forward));
        value.set((Object)backward);
        Assert.assertFalse((boolean)value.getOffset().isZero());
        Assert.assertSame((Object)Duration.ZERO, (Object)value.getBasis());
        Assert.assertEquals((Object)backward, (Object)value.get());
        Assert.assertEquals((Object)backward, (Object)value.getOffset().apply((Object)Duration.ZERO));
        Assert.assertEquals((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)forward));
        Assert.assertTrue((boolean)rebaseValue.getOffset().isZero());
        Assert.assertEquals((Object)value.get(), (Object)rebaseValue.getBasis());
        Assert.assertEquals((Object)value.get(), (Object)rebaseValue.get());
        Assert.assertEquals((Object)Duration.ZERO, (Object)rebaseValue.getOffset().apply((Object)Duration.ZERO));
        Assert.assertEquals((Object)forward, (Object)rebaseValue.getOffset().apply((Object)forward));
        value = OffsetValue.from((Duration)forward);
        Assert.assertTrue((boolean)value.getOffset().isZero());
        Assert.assertSame((Object)forward, (Object)value.getBasis());
        Assert.assertSame((Object)forward, (Object)value.get());
        Assert.assertSame((Object)backward, (Object)value.getOffset().apply((Object)backward));
        Assert.assertSame((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)Duration.ZERO));
        Assert.assertEquals((Object)forward, (Object)value.getOffset().apply((Object)forward));
        value.set((Object)Duration.ZERO);
        Assert.assertFalse((boolean)value.getOffset().isZero());
        Assert.assertSame((Object)forward, (Object)value.getBasis());
        Assert.assertSame((Object)Duration.ZERO, (Object)value.get());
        Assert.assertEquals((Object)backward, (Object)value.getOffset().apply((Object)Duration.ZERO));
        Assert.assertEquals((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)forward));
        value = OffsetValue.from((Duration)backward);
        Assert.assertTrue((boolean)value.getOffset().isZero());
        Assert.assertSame((Object)backward, (Object)value.getBasis());
        Assert.assertSame((Object)backward, (Object)value.get());
        Assert.assertSame((Object)backward, (Object)value.getOffset().apply((Object)backward));
        Assert.assertSame((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)Duration.ZERO));
        Assert.assertEquals((Object)forward, (Object)value.getOffset().apply((Object)forward));
        value.set((Object)Duration.ZERO);
        Assert.assertFalse((boolean)value.getOffset().isZero());
        Assert.assertSame((Object)backward, (Object)value.getBasis());
        Assert.assertSame((Object)Duration.ZERO, (Object)value.get());
        Assert.assertEquals((Object)Duration.ZERO, (Object)value.getOffset().apply((Object)backward));
        Assert.assertEquals((Object)forward, (Object)value.getOffset().apply((Object)Duration.ZERO));
    }

    @Test
    public void instant() {
        Duration forward = Duration.ofSeconds(1L);
        Duration backward = Duration.ofSeconds(-1L);
        Instant present = Instant.now();
        Instant past = present.plus(backward);
        Instant future = present.plus(forward);
        OffsetValue value = OffsetValue.from((Instant)present);
        Assert.assertTrue((boolean)value.getOffset().isZero());
        Assert.assertSame((Object)present, (Object)value.getBasis());
        Assert.assertSame((Object)present, (Object)value.get());
        Assert.assertSame((Object)past, (Object)value.getOffset().apply((Object)past));
        Assert.assertSame((Object)present, (Object)value.getOffset().apply((Object)present));
        Assert.assertSame((Object)future, (Object)value.getOffset().apply((Object)future));
        value.set((Object)future);
        Assert.assertFalse((boolean)value.getOffset().isZero());
        Assert.assertEquals((Object)present, (Object)value.getBasis());
        Assert.assertEquals((Object)future, (Object)value.get());
        Assert.assertEquals((Object)present, (Object)value.getOffset().apply((Object)past));
        Assert.assertEquals((Object)future, (Object)value.getOffset().apply((Object)present));
        OffsetValue rebaseValue = value.rebase();
        Assert.assertTrue((boolean)rebaseValue.getOffset().isZero());
        Assert.assertEquals((Object)future, (Object)rebaseValue.getBasis());
        Assert.assertEquals((Object)future, (Object)rebaseValue.get());
        Assert.assertSame((Object)past, (Object)rebaseValue.getOffset().apply((Object)past));
        Assert.assertSame((Object)present, (Object)rebaseValue.getOffset().apply((Object)present));
        Assert.assertSame((Object)future, (Object)rebaseValue.getOffset().apply((Object)future));
        value.set((Object)past);
        Assert.assertFalse((boolean)value.getOffset().isZero());
        Assert.assertEquals((Object)present, (Object)value.getBasis());
        Assert.assertEquals((Object)past, (Object)value.get());
        Assert.assertEquals((Object)past, (Object)value.getOffset().apply((Object)present));
        Assert.assertEquals((Object)present, (Object)value.getOffset().apply((Object)future));
        Assert.assertTrue((boolean)rebaseValue.getOffset().isZero());
        Assert.assertEquals((Object)past, (Object)rebaseValue.getBasis());
        Assert.assertEquals((Object)past, (Object)rebaseValue.get());
        Assert.assertSame((Object)past, (Object)rebaseValue.getOffset().apply((Object)past));
        Assert.assertSame((Object)present, (Object)rebaseValue.getOffset().apply((Object)present));
        Assert.assertSame((Object)future, (Object)rebaseValue.getOffset().apply((Object)future));
    }
}

