/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.cache.tx;

import jakarta.transaction.Synchronization;
import jakarta.transaction.Transaction;
import jakarta.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.cache.tx.TransactionalBatcher;

public class TransactionalBatcherTestCase {
    private final TransactionManager tm = (TransactionManager)Mockito.mock(TransactionManager.class);
    private final Batcher<TransactionBatch> batcher = new TransactionalBatcher(this.tm, RuntimeException::new);

    @After
    public void destroy() {
        TransactionalBatcher.setCurrentBatch(null);
    }

    @Test
    public void createExistingActiveBatch() throws Exception {
        TransactionBatch existingBatch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        TransactionalBatcher.setCurrentBatch((TransactionBatch)existingBatch);
        Mockito.when((Object)existingBatch.getState()).thenReturn((Object)Batch.State.ACTIVE);
        Mockito.when((Object)existingBatch.interpose()).thenReturn((Object)existingBatch);
        TransactionBatch result = (TransactionBatch)this.batcher.createBatch();
        ((TransactionBatch)Mockito.verify((Object)existingBatch)).interpose();
        Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
        Assert.assertSame((Object)existingBatch, (Object)result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createExistingClosedBatch() throws Exception {
        TransactionBatch existingBatch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        TransactionalBatcher.setCurrentBatch((TransactionBatch)existingBatch);
        Mockito.when((Object)existingBatch.getState()).thenReturn((Object)Batch.State.CLOSED);
        Mockito.when((Object)this.tm.getTransaction()).thenReturn((Object)tx);
        try (TransactionBatch batch = (TransactionBatch)this.batcher.createBatch();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Assert.assertSame((Object)tx, (Object)batch.getTransaction());
            Assert.assertSame((Object)batch, (Object)TransactionalBatcher.getCurrentBatch());
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(3);
        }
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Assert.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createBatchClose() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        Mockito.when((Object)this.tm.getTransaction()).thenReturn((Object)tx);
        try (TransactionBatch batch = (TransactionBatch)this.batcher.createBatch();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Assert.assertSame((Object)tx, (Object)batch.getTransaction());
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(3);
        }
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Assert.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createBatchDiscard() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        Mockito.when((Object)this.tm.getTransaction()).thenReturn((Object)tx);
        try (TransactionBatch batch = (TransactionBatch)this.batcher.createBatch();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Assert.assertSame((Object)tx, (Object)batch.getTransaction());
            batch.discard();
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(4);
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        Assert.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createNestedBatchClose() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        Mockito.when((Object)this.tm.getTransaction()).thenReturn((Object)tx);
        try (TransactionBatch outerBatch = (TransactionBatch)this.batcher.createBatch();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Mockito.reset((Object[])new TransactionManager[]{this.tm});
            Assert.assertSame((Object)tx, (Object)outerBatch.getTransaction());
            Mockito.when((Object)this.tm.getTransaction()).thenReturn((Object)tx);
            try (TransactionBatch innerBatch = (TransactionBatch)this.batcher.createBatch();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.never())).begin();
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.never())).suspend();
            }
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(3);
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Assert.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createNestedBatchDiscard() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        Mockito.when((Object)this.tm.getTransaction()).thenReturn((Object)tx);
        try (TransactionBatch outerBatch = (TransactionBatch)this.batcher.createBatch();){
            ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
            ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
            Mockito.reset((Object[])new TransactionManager[]{this.tm});
            Assert.assertSame((Object)tx, (Object)outerBatch.getTransaction());
            Mockito.when((Object)tx.getStatus()).thenReturn((Object)0);
            Mockito.when((Object)this.tm.getTransaction()).thenReturn((Object)tx);
            try (TransactionBatch innerBatch = (TransactionBatch)this.batcher.createBatch();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.never())).begin();
                innerBatch.discard();
            }
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
            ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(4);
        }
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
        Assert.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createOverlappingBatchClose() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        Mockito.when((Object)this.tm.getTransaction()).thenReturn((Object)tx);
        TransactionBatch batch = (TransactionBatch)this.batcher.createBatch();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
        Mockito.reset((Object[])new TransactionManager[]{this.tm});
        try {
            Assert.assertSame((Object)tx, (Object)batch.getTransaction());
            Mockito.when((Object)this.tm.getTransaction()).thenReturn((Object)tx);
            Mockito.when((Object)tx.getStatus()).thenReturn((Object)0);
            try (TransactionBatch innerBatch = (TransactionBatch)this.batcher.createBatch();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.never())).begin();
                batch.close();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
            }
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(3);
        }
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
        ((Transaction)Mockito.verify((Object)tx)).commit();
        Assert.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createOverlappingBatchDiscard() throws Exception {
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        ArgumentCaptor capturedSync = ArgumentCaptor.forClass(Synchronization.class);
        Mockito.when((Object)this.tm.getTransaction()).thenReturn((Object)tx);
        TransactionBatch batch = (TransactionBatch)this.batcher.createBatch();
        ((TransactionManager)Mockito.verify((Object)this.tm)).begin();
        ((Transaction)Mockito.verify((Object)tx)).registerSynchronization((Synchronization)capturedSync.capture());
        Mockito.reset((Object[])new TransactionManager[]{this.tm});
        try {
            Assert.assertSame((Object)tx, (Object)batch.getTransaction());
            Mockito.when((Object)this.tm.getTransaction()).thenReturn((Object)tx);
            Mockito.when((Object)tx.getStatus()).thenReturn((Object)0);
            try (TransactionBatch innerBatch = (TransactionBatch)this.batcher.createBatch();){
                ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.never())).begin();
                innerBatch.discard();
                batch.close();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
                ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).rollback();
            }
        }
        finally {
            ((Synchronization)capturedSync.getValue()).afterCompletion(4);
        }
        ((Transaction)Mockito.verify((Object)tx)).rollback();
        ((Transaction)Mockito.verify((Object)tx, (VerificationMode)Mockito.never())).commit();
        Assert.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void resumeNullBatch() throws Exception {
        TransactionBatch batch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        TransactionalBatcher.setCurrentBatch((TransactionBatch)batch);
        try (BatchContext context = this.batcher.resumeBatch(null);){
            Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
            Assert.assertNull((Object)TransactionalBatcher.getCurrentBatch());
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
        Assert.assertSame((Object)batch, (Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void resumeNonTxBatch() throws Exception {
        TransactionBatch existingBatch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        TransactionalBatcher.setCurrentBatch((TransactionBatch)existingBatch);
        TransactionBatch batch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        try (BatchContext context = this.batcher.resumeBatch((Batch)batch);){
            Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
            Assert.assertSame((Object)batch, (Object)TransactionalBatcher.getCurrentBatch());
        }
        Mockito.verifyNoInteractions((Object[])new Object[]{this.tm});
        Assert.assertSame((Object)existingBatch, (Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void resumeBatch() throws Exception {
        TransactionBatch batch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)batch.getTransaction()).thenReturn((Object)tx);
        try (BatchContext context = this.batcher.resumeBatch((Batch)batch);){
            ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.never())).suspend();
            ((TransactionManager)Mockito.verify((Object)this.tm)).resume(tx);
            Mockito.reset((Object[])new TransactionManager[]{this.tm});
            Assert.assertSame((Object)batch, (Object)TransactionalBatcher.getCurrentBatch());
        }
        ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
        ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.never())).resume((Transaction)Mockito.any());
        Assert.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void resumeBatchExisting() throws Exception {
        TransactionBatch existingBatch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        Transaction existingTx = (Transaction)Mockito.mock(Transaction.class);
        TransactionalBatcher.setCurrentBatch((TransactionBatch)existingBatch);
        TransactionBatch batch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        Transaction tx = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)existingBatch.getTransaction()).thenReturn((Object)existingTx);
        Mockito.when((Object)batch.getTransaction()).thenReturn((Object)tx);
        Mockito.when((Object)this.tm.suspend()).thenReturn((Object)existingTx);
        try (BatchContext context = this.batcher.resumeBatch((Batch)batch);){
            ((TransactionManager)Mockito.verify((Object)this.tm)).resume(tx);
            Mockito.reset((Object[])new TransactionManager[]{this.tm});
            Assert.assertSame((Object)batch, (Object)TransactionalBatcher.getCurrentBatch());
            Mockito.when((Object)this.tm.suspend()).thenReturn((Object)tx);
        }
        ((TransactionManager)Mockito.verify((Object)this.tm)).resume(existingTx);
        Assert.assertSame((Object)existingBatch, (Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void suspendBatch() throws Exception {
        TransactionBatch batch = (TransactionBatch)Mockito.mock(TransactionBatch.class);
        TransactionalBatcher.setCurrentBatch((TransactionBatch)batch);
        TransactionBatch result = (TransactionBatch)this.batcher.suspendBatch();
        ((TransactionManager)Mockito.verify((Object)this.tm)).suspend();
        Assert.assertSame((Object)batch, (Object)result);
        Assert.assertNull((Object)TransactionalBatcher.getCurrentBatch());
    }

    @Test
    public void suspendNoBatch() throws Exception {
        TransactionBatch result = (TransactionBatch)this.batcher.suspendBatch();
        ((TransactionManager)Mockito.verify((Object)this.tm, (VerificationMode)Mockito.never())).suspend();
        Assert.assertNull((Object)result);
    }
}

