/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan;

import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.ee.BatchContext;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.infinispan.InfinispanBatch;
import org.wildfly.clustering.ee.infinispan.TransactionBatch;

public class InfinispanBatcher
implements Batcher<TransactionBatch> {
    private static final BatchContext PASSIVE_BATCH_CONTEXT = () -> {};
    private static final TransactionBatch NON_TX_BATCH = new TransactionBatch(){

        public void close() {
        }

        public void discard() {
        }

        public Batch.State getState() {
            return Batch.State.ACTIVE;
        }

        @Override
        public Transaction getTransaction() {
            return null;
        }

        @Override
        public TransactionBatch interpose() {
            return this;
        }
    };
    private static final ThreadLocal<TransactionBatch> CURRENT_BATCH = new ThreadLocal();
    private static final Synchronization CURRENT_BATCH_SYNCHRONIZATION = new Synchronization(){

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            InfinispanBatcher.setCurrentBatch(null);
        }
    };
    private final TransactionManager tm;

    static TransactionBatch getCurrentBatch() {
        return CURRENT_BATCH.get();
    }

    static void setCurrentBatch(TransactionBatch batch) {
        if (batch != null) {
            CURRENT_BATCH.set(batch);
        } else {
            CURRENT_BATCH.remove();
        }
    }

    public InfinispanBatcher(Cache<?, ?> cache) {
        this(cache.getAdvancedCache().getTransactionManager());
    }

    public InfinispanBatcher(TransactionManager tm) {
        this.tm = tm;
    }

    public TransactionBatch createBatch() {
        if (this.tm == null) {
            return NON_TX_BATCH;
        }
        TransactionBatch batch = InfinispanBatcher.getCurrentBatch();
        try {
            if (batch != null && batch.getState() == Batch.State.ACTIVE) {
                return batch.interpose();
            }
            this.tm.suspend();
            this.tm.begin();
            Transaction tx = this.tm.getTransaction();
            tx.registerSynchronization(CURRENT_BATCH_SYNCHRONIZATION);
            batch = new InfinispanBatch(tx);
            InfinispanBatcher.setCurrentBatch(batch);
            return batch;
        }
        catch (NotSupportedException | RollbackException | SystemException e) {
            throw new CacheException(e);
        }
    }

    public BatchContext resumeBatch(TransactionBatch batch) {
        Transaction tx;
        TransactionBatch existingBatch = InfinispanBatcher.getCurrentBatch();
        if (batch == existingBatch) {
            return PASSIVE_BATCH_CONTEXT;
        }
        Transaction transaction = tx = batch != null ? batch.getTransaction() : null;
        if (batch == null || tx == null) {
            InfinispanBatcher.setCurrentBatch(batch);
            return () -> InfinispanBatcher.setCurrentBatch(existingBatch);
        }
        try {
            if (existingBatch != null) {
                Transaction existingTx = this.tm.suspend();
                if (existingBatch.getTransaction() != existingTx) {
                    throw new IllegalStateException();
                }
            }
            this.tm.resume(tx);
            InfinispanBatcher.setCurrentBatch(batch);
            return () -> {
                block7: {
                    try {
                        this.tm.suspend();
                        if (existingBatch == null) break block7;
                        try {
                            this.tm.resume(existingBatch.getTransaction());
                        }
                        catch (InvalidTransactionException e) {
                            throw new CacheException((Throwable)e);
                        }
                    }
                    catch (SystemException e) {
                        throw new CacheException((Throwable)e);
                    }
                    finally {
                        InfinispanBatcher.setCurrentBatch(existingBatch);
                    }
                }
            };
        }
        catch (InvalidTransactionException | SystemException e) {
            throw new CacheException(e);
        }
    }

    public TransactionBatch suspendBatch() {
        if (this.tm == null) {
            return NON_TX_BATCH;
        }
        TransactionBatch batch = InfinispanBatcher.getCurrentBatch();
        if (batch != null) {
            try {
                Transaction tx = this.tm.suspend();
                if (batch.getTransaction() != tx) {
                    throw new IllegalStateException();
                }
            }
            catch (SystemException e) {
                throw new CacheException((Throwable)e);
            }
            finally {
                InfinispanBatcher.setCurrentBatch(null);
            }
        }
        return batch;
    }
}

