/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan.retry;

import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;

public class RetryingInvoker
extends org.wildfly.clustering.ee.retry.RetryingInvoker {
    public RetryingInvoker(Cache<?, ?> cache) {
        super(RetryingInvoker.calculateRetryIntervals(cache.getCacheConfiguration()));
    }

    private static List<Duration> calculateRetryIntervals(Configuration config) {
        long timeout = config.locking().lockAcquisitionTimeout();
        LinkedList<Duration> intervals = new LinkedList<Duration>();
        for (long interval = timeout; interval > 1L; interval /= 10L) {
            intervals.add(0, Duration.ofMillis(interval));
        }
        intervals.add(0, Duration.ZERO);
        return intervals;
    }
}

