/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee.infinispan.affinity;

import java.util.UUID;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Address;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.wildfly.clustering.ee.Key;
import org.wildfly.clustering.ee.cache.IdentifierFactory;
import org.wildfly.clustering.ee.infinispan.GroupedKey;
import org.wildfly.clustering.ee.infinispan.affinity.AffinityIdentifierFactory;
import org.wildfly.clustering.infinispan.affinity.KeyAffinityServiceFactory;

public class AffinityIdentifierFactoryTestCase {
    private final Supplier<UUID> factory = (Supplier)Mockito.mock(Supplier.class);
    private final KeyAffinityServiceFactory affinityFactory = (KeyAffinityServiceFactory)Mockito.mock(KeyAffinityServiceFactory.class);
    private final KeyAffinityService<Key<UUID>> affinity = (KeyAffinityService)Mockito.mock(KeyAffinityService.class);
    private final Cache<Key<UUID>, ?> cache = (Cache)Mockito.mock(Cache.class);
    private final Address localAddress = (Address)Mockito.mock(Address.class);
    private IdentifierFactory<UUID> subject;
    @Captor
    private ArgumentCaptor<KeyGenerator<Key<UUID>>> capturedGenerator;

    @Before
    public void init() throws Exception {
        EmbeddedCacheManager manager = (EmbeddedCacheManager)Mockito.mock(EmbeddedCacheManager.class);
        try (AutoCloseable test = MockitoAnnotations.openMocks((Object)this);){
            Mockito.when((Object)this.affinityFactory.createService((Cache)ArgumentMatchers.same(this.cache), (KeyGenerator)this.capturedGenerator.capture())).thenReturn(this.affinity);
            Mockito.when((Object)this.cache.getCacheManager()).thenReturn((Object)manager);
            Mockito.when((Object)manager.getAddress()).thenReturn((Object)this.localAddress);
            this.subject = new AffinityIdentifierFactory(this.factory, this.cache, this.affinityFactory);
            KeyGenerator generator = (KeyGenerator)this.capturedGenerator.getValue();
            Assert.assertSame((Object)generator, this.subject);
            UUID expected = UUID.randomUUID();
            Mockito.when((Object)this.factory.get()).thenReturn((Object)expected);
            Key result = (Key)generator.getKey();
            Assert.assertSame((Object)expected, (Object)result.getId());
        }
    }

    @Test
    public void start() {
        this.subject.start();
        ((KeyAffinityService)Mockito.verify(this.affinity)).start();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.affinity});
    }

    @Test
    public void stop() {
        this.subject.stop();
        ((KeyAffinityService)Mockito.verify(this.affinity)).stop();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.affinity});
    }

    @Test
    public void createIdentifier() {
        UUID expected = UUID.randomUUID();
        Mockito.when((Object)((Key)this.affinity.getKeyForAddress(this.localAddress))).thenReturn((Object)new GroupedKey((Object)expected));
        UUID result = (UUID)this.subject.get();
        Assert.assertSame((Object)expected, (Object)result);
    }
}

