/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ee;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.Assert;
import org.junit.Test;
import org.wildfly.clustering.ee.CompositeIterable;

public class CompositeIterableTestCase {
    @Test
    public void test() {
        Iterable expected = IntStream.range(0, 10).mapToObj(Integer::valueOf).collect(Collectors.toList());
        CompositeIterableTestCase.test(expected, (Iterable<Integer>)new CompositeIterable(new Iterable[]{Arrays.asList(0, 1, 2, 3, 4), Arrays.asList(5, 6, 7, 8, 9)}));
        CompositeIterableTestCase.test(expected, (Iterable<Integer>)new CompositeIterable(new Iterable[]{Arrays.asList(0, 1), Arrays.asList(2, 3), Arrays.asList(4, 5), Arrays.asList(6, 7), Arrays.asList(8, 9)}));
        CompositeIterableTestCase.test(expected, (Iterable<Integer>)new CompositeIterable(new Iterable[]{Collections.emptyList(), expected, Collections.emptyList()}));
    }

    static void test(Iterable<Integer> expected, Iterable<Integer> subject) {
        Assert.assertEquals((long)expected.hashCode(), (long)subject.hashCode());
        Assert.assertEquals((Object)expected.toString(), (Object)subject.toString());
        Iterator<Integer> subjectIterator = subject.iterator();
        Iterator<Integer> expectedIterator = expected.iterator();
        while (expectedIterator.hasNext()) {
            Assert.assertTrue((boolean)subjectIterator.hasNext());
            Assert.assertEquals((Object)expectedIterator.next(), (Object)subjectIterator.next());
        }
        Assert.assertFalse((boolean)subjectIterator.hasNext());
    }
}

