/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.client;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.jboss.ejb.client.SessionID;
import org.jboss.ejb.client.UUIDSessionID;
import org.junit.jupiter.params.ParameterizedTest;
import org.wildfly.clustering.marshalling.MarshallingTesterFactory;
import org.wildfly.clustering.marshalling.Tester;
import org.wildfly.clustering.marshalling.TesterFactory;
import org.wildfly.clustering.marshalling.junit.TesterFactorySource;

public class SessionIDSerializerTestCase {
    @ParameterizedTest
    @TesterFactorySource(value={MarshallingTesterFactory.class})
    public void test(TesterFactory factory) {
        UUID uuid = UUID.randomUUID();
        Tester tester = factory.createTester();
        tester.accept(new UUIDSessionID(uuid));
        ByteBuffer buffer = ByteBuffer.allocate(20);
        buffer.putInt(0x7000000);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        tester.accept(SessionID.createSessionID((byte[])buffer.array()));
        buffer = ByteBuffer.allocate(16);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        tester.accept(SessionID.createSessionID((byte[])buffer.array()));
    }
}

