/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.auth;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Arrays;
import org.jgroups.Message;
import org.jgroups.auth.AuthToken;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.util.Util;

public class BinaryAuthToken
extends AuthToken {
    private volatile byte[] sharedSecret;

    public BinaryAuthToken() {
        this.sharedSecret = null;
    }

    public BinaryAuthToken(byte[] sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    public boolean authenticate(AuthToken token, Message message) {
        if (this.sharedSecret == null || !(token instanceof BinaryAuthToken)) {
            return false;
        }
        return Arrays.equals(this.sharedSecret, ((BinaryAuthToken)token).sharedSecret);
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public int size() {
        return Util.size((byte[])this.sharedSecret);
    }

    public void writeTo(DataOutput output) throws Exception {
        Util.writeByteBuffer((byte[])this.sharedSecret, (DataOutput)output);
    }

    public void readFrom(DataInput input) throws Exception {
        this.sharedSecret = Util.readByteBuffer((DataInput)input);
    }

    static {
        ClassConfigurator.add((short)1100, BinaryAuthToken.class);
    }
}

