/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Objects;
import java.util.stream.Stream;
import javax.management.MBeanServer;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.controller.CommonRequirement;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jgroups.JChannel;
import org.jgroups.jmx.JmxConfigurator;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.JGroupsRequirement;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class ChannelBuilder
extends CapabilityServiceNameProvider
implements ResourceServiceBuilder<JChannel>,
Service<JChannel> {
    private final String name;
    private volatile ValueDependency<ChannelFactory> factory;
    private volatile ValueDependency<MBeanServer> server;
    private volatile ValueDependency<String> cluster;
    private volatile boolean statisticsEnabled = false;
    private volatile JChannel channel;

    public ChannelBuilder(Capability capability, PathAddress address) {
        super(capability, address);
        this.name = address.getLastElement().getValue();
    }

    public ChannelBuilder statisticsEnabled(boolean enabled) {
        this.statisticsEnabled = enabled;
        return this;
    }

    public ServiceBuilder<JChannel> build(ServiceTarget target) {
        ServiceBuilder builder = new AsynchronousServiceBuilder(this.getServiceName(), (Service)this).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
        Stream.of(this.factory, this.cluster, this.server).filter(Objects::nonNull).forEach(dependency -> dependency.register(builder));
        return builder;
    }

    public Builder<JChannel> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.cluster = new InjectedValueDependency(JGroupsRequirement.CHANNEL_CLUSTER.getServiceName(context, this.name), String.class);
        this.factory = new InjectedValueDependency(JGroupsRequirement.CHANNEL_SOURCE.getServiceName(context, this.name), ChannelFactory.class);
        this.server = context.hasOptionalCapability(CommonRequirement.MBEAN_SERVER.getName(), null, null) ? new InjectedValueDependency(CommonRequirement.MBEAN_SERVER.getServiceName(context), MBeanServer.class) : null;
        return this;
    }

    public JChannel getValue() {
        return this.channel;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.channel = ((ChannelFactory)this.factory.getValue()).createChannel(this.name);
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
        if (JGroupsLogger.ROOT_LOGGER.isTraceEnabled()) {
            String output = this.channel.getProtocolStack().printProtocolSpec(true);
            JGroupsLogger.ROOT_LOGGER.tracef("JGroups channel %s created with configuration:%n %s", this.name, output);
        }
        this.channel.stats(this.statisticsEnabled);
        if (this.server != null) {
            try {
                JmxConfigurator.registerChannel((JChannel)this.channel, (MBeanServer)((MBeanServer)this.server.getValue()), (String)this.name);
            }
            catch (Exception e) {
                JGroupsLogger.ROOT_LOGGER.debug(e.getLocalizedMessage(), e);
            }
        }
        try {
            this.channel.connect((String)this.cluster.getValue());
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext context) {
        this.channel.disconnect();
        if (this.server != null) {
            try {
                JmxConfigurator.unregisterChannel((JChannel)this.channel, (MBeanServer)((MBeanServer)this.server.getValue()), (String)this.name);
            }
            catch (Exception e) {
                JGroupsLogger.ROOT_LOGGER.debug(e.getLocalizedMessage(), e);
            }
        }
        this.channel.close();
        this.channel = null;
    }
}

