/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.SocketBindingProtocolResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.protocols.MPING;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.ValueDependency;

public class MulticastSocketProtocolConfigurationBuilder
extends ProtocolConfigurationBuilder<MPING> {
    private volatile ValueDependency<SocketBinding> binding;

    public MulticastSocketProtocolConfigurationBuilder(PathAddress address) {
        super(address);
    }

    @Override
    public ServiceBuilder<ProtocolConfiguration<MPING>> build(ServiceTarget target) {
        return this.binding.register(super.build(target));
    }

    @Override
    public Builder<ProtocolConfiguration<MPING>> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String bindingName = SocketBindingProtocolResourceDefinition.Attribute.SOCKET_BINDING.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.binding = new InjectedValueDependency(CommonUnaryRequirement.SOCKET_BINDING.getServiceName(context, bindingName), SocketBinding.class);
        return super.configure(context, model);
    }

    @Override
    public void accept(MPING protocol) {
        SocketBinding binding = (SocketBinding)this.binding.getValue();
        protocol.setMcastAddr(binding.getMulticastAddress());
        protocol.setMcastPort(binding.getMulticastPort());
    }
}

