/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.CapabilityReference;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.Operations;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.UnaryCapabilityNameResolver;
import org.jboss.as.clustering.controller.WriteAttributeStepHandler;
import org.jboss.as.clustering.controller.WriteAttributeStepHandlerDescriptor;
import org.jboss.as.clustering.controller.transform.ChainedOperationTransformer;
import org.jboss.as.clustering.controller.transform.LegacyPropertyAddOperationTransformer;
import org.jboss.as.clustering.controller.transform.LegacyPropertyMapGetOperationTransformer;
import org.jboss.as.clustering.controller.transform.LegacyPropertyResourceTransformer;
import org.jboss.as.clustering.controller.transform.LegacyPropertyWriteOperationTransformer;
import org.jboss.as.clustering.controller.transform.OperationTransformer;
import org.jboss.as.clustering.controller.transform.PathAddressTransformer;
import org.jboss.as.clustering.controller.transform.RequiredChildResourceDiscardPolicy;
import org.jboss.as.clustering.controller.transform.SimpleDescribeOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimplePathOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleReadAttributeOperationTransformer;
import org.jboss.as.clustering.controller.transform.SimpleRemoveOperationTransformer;
import org.jboss.as.clustering.jgroups.logging.JGroupsLogger;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsModel;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.global.MapOperations;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.DynamicDiscardPolicy;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jgroups.protocols.TP;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.UnaryRequirement;

public class TransportResourceDefinition<T extends TP>
extends AbstractProtocolResourceDefinition<T, TransportConfiguration<T>> {
    static final PathElement LEGACY_PATH = TransportResourceDefinition.pathElement("TRANSPORT");
    static final PathElement WILDCARD_PATH = TransportResourceDefinition.pathElement("*");
    static final PathAddressTransformer LEGACY_ADDRESS_TRANSFORMER = new PathAddressTransformer(){

        public PathAddress transform(PathAddress address) {
            return address.subAddress(0, address.size() - 1).append(new PathElement[]{LEGACY_PATH});
        }
    };

    public static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"transport", (String)name);
    }

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = parent.addChildResource(WILDCARD_PATH);
        AbstractProtocolResourceDefinition.addTransformations(version, builder);
        if (JGroupsModel.VERSION_3_0_0.requiresTransformation(version)) {
            builder.getAttributeBuilder().setValueConverter((AttributeConverter)new AttributeConverter.DefaultValueAttributeConverter(Attribute.SHARED.getDefinition()), new AttributeDefinition[]{Attribute.SHARED.getDefinition()});
            builder.setCustomResourceTransformer(new ResourceTransformer(){

                public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
                    new LegacyPropertyResourceTransformer().transformResource(context, LEGACY_ADDRESS_TRANSFORMER.transform(address), resource);
                }
            });
            builder.addOperationTransformationOverride("add").setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new SimpleOperationTransformer(new OperationTransformer(){

                public ModelNode transformOperation(ModelNode operation) {
                    operation.get("address").set(LEGACY_ADDRESS_TRANSFORMER.transform(Operations.getPathAddress((ModelNode)operation)).toModelNode());
                    return new LegacyPropertyAddOperationTransformer().transformOperation(operation);
                }
            })).inheritResourceAttributeDefinitions();
            builder.addOperationTransformationOverride("remove").setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new SimpleRemoveOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            builder.addOperationTransformationOverride("read-attribute").setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new SimpleReadAttributeOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            builder.addOperationTransformationOverride("describe").setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)new SimpleDescribeOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            LinkedList<Object> getOpTransformerChain = new LinkedList<Object>();
            getOpTransformerChain.add(new SimplePathOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            getOpTransformerChain.add(new SimpleOperationTransformer((OperationTransformer)new LegacyPropertyMapGetOperationTransformer()));
            ChainedOperationTransformer getOpChainedTransformer = new ChainedOperationTransformer(getOpTransformerChain, false);
            builder.addRawOperationTransformationOverride(MapOperations.MAP_GET_DEFINITION.getName(), (org.jboss.as.controller.transform.OperationTransformer)getOpChainedTransformer);
            LinkedList<Object> writeOpTransformerChain = new LinkedList<Object>();
            writeOpTransformerChain.add(new SimplePathOperationTransformer(LEGACY_ADDRESS_TRANSFORMER));
            writeOpTransformerChain.add(new LegacyPropertyWriteOperationTransformer());
            ChainedOperationTransformer writeOpChainedTransformer = new ChainedOperationTransformer(writeOpTransformerChain, false);
            for (String opName : Operations.getAllWriteAttributeOperationNames()) {
                builder.addOperationTransformationOverride(opName).inheritResourceAttributeDefinitions().setCustomOperationTransformer((org.jboss.as.controller.transform.OperationTransformer)writeOpChainedTransformer);
            }
            builder.addChildResource(ThreadPoolResourceDefinition.WILDCARD_PATH, (DynamicDiscardPolicy)RequiredChildResourceDiscardPolicy.REJECT_AND_WARN);
        } else {
            for (ThreadPoolResourceDefinition pool : EnumSet.allOf(ThreadPoolResourceDefinition.class)) {
                pool.buildTransformation(version, parent);
            }
        }
    }

    TransportResourceDefinition(ResourceServiceBuilderFactory<TransportConfiguration<T>> builderFactory, ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        this(new SimpleResourceDefinition.Parameters(WILDCARD_PATH, JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{WILDCARD_PATH, ProtocolResourceDefinition.WILDCARD_PATH})), builderFactory, parentBuilderFactory);
    }

    TransportResourceDefinition(PathElement path, ResourceServiceBuilderFactory<TransportConfiguration<T>> builderFactory, ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        this(new SimpleResourceDefinition.Parameters(path, JGroupsExtension.SUBSYSTEM_RESOLVER.createChildResolver(new PathElement[]{path, WILDCARD_PATH, ProtocolResourceDefinition.WILDCARD_PATH})), builderFactory, parentBuilderFactory);
    }

    private TransportResourceDefinition(SimpleResourceDefinition.Parameters parameters, ResourceServiceBuilderFactory<TransportConfiguration<T>> builderFactory, ResourceServiceBuilderFactory<ChannelFactory> parentBuilderFactory) {
        super(parameters, new ResourceDescriptorConfigurator(), builderFactory, parentBuilderFactory);
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        new WriteAttributeStepHandler(new WriteThreadingAttributeStepHandlerDescriptor()){

            protected void validateUpdatedModel(OperationContext context, Resource model) throws OperationFailedException {
                context.addStep(new OperationStepHandler(){

                    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                        ModelNode conf = context.readResource(PathAddress.EMPTY_ADDRESS).getModel();
                        if (context.getProcessType().isServer()) {
                            for (ThreadingAttribute attribute : EnumSet.allOf(ThreadingAttribute.class)) {
                                if (!conf.hasDefined(attribute.getName())) continue;
                                throw new OperationFailedException(JGroupsLogger.ROOT_LOGGER.threadsAttributesUsedInRuntime());
                            }
                        }
                    }
                }, OperationContext.Stage.MODEL);
            }
        }.register(registration);
        if (registration.getPathAddress().getLastElement().isWildcard()) {
            for (ThreadPoolResourceDefinition pool : EnumSet.allOf(ThreadPoolResourceDefinition.class)) {
                pool.register(registration);
            }
        }
        if (registration.getPathAddress().getLastElement().isWildcard()) {
            parent.registerAlias(LEGACY_PATH, new AliasEntry(registration){

                public PathAddress convertToTargetAddress(PathAddress aliasAddress, AliasEntry.AliasContext aliasContext) {
                    PathAddress target = this.getTargetAddress();
                    ArrayList<PathElement> result = new ArrayList<PathElement>(aliasAddress.size());
                    for (int i = 0; i < aliasAddress.size(); ++i) {
                        PathElement element = aliasAddress.getElement(i);
                        if (i == target.size() - 1) {
                            String stackName;
                            ModelNode operation = aliasContext.getOperation();
                            if ("add".equals(Operations.getName((ModelNode)operation)) && operation.hasDefined("type")) {
                                stackName = operation.get("type").asString();
                            } else {
                                Resource root = null;
                                try {
                                    root = aliasContext.readResourceFromRoot(PathAddress.pathAddress(result));
                                }
                                catch (Resource.NoSuchResourceException noSuchResourceException) {
                                    // empty catch block
                                }
                                if (root == null) {
                                    stackName = "*";
                                } else {
                                    Set names = root.getChildrenNames("transport");
                                    if (names.size() > 1) {
                                        throw new AssertionError((Object)"There should be at most one child");
                                    }
                                    stackName = names.size() == 0 ? "*" : (String)names.iterator().next();
                                }
                            }
                            result.add(PathElement.pathElement((String)"transport", (String)stackName));
                            continue;
                        }
                        if (i < target.size()) {
                            PathElement targetElement = target.getElement(i);
                            result.add(targetElement.isWildcard() ? PathElement.pathElement((String)targetElement.getKey(), (String)element.getValue()) : targetElement);
                            continue;
                        }
                        result.add(element);
                    }
                    return PathAddress.pathAddress(result);
                }
            });
        }
        return registration;
    }

    static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        ResourceDescriptorConfigurator() {
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return descriptor.addAttributes(Attribute.class).addCapabilities(Capability.class).addExtraParameters(ThreadingAttribute.class).addRequiredChildren(ThreadPoolResourceDefinition.class);
        }
    }

    @Deprecated
    static class WriteThreadingAttributeStepHandlerDescriptor
    implements WriteAttributeStepHandlerDescriptor {
        WriteThreadingAttributeStepHandlerDescriptor() {
        }

        public Collection<AttributeDefinition> getAttributes() {
            EnumSet<ThreadingAttribute> attributes = EnumSet.allOf(ThreadingAttribute.class);
            ArrayList<AttributeDefinition> result = new ArrayList<AttributeDefinition>(attributes.size());
            for (ThreadingAttribute attribute : attributes) {
                result.add(attribute.getDefinition());
            }
            return result;
        }
    }

    @Deprecated
    static enum ThreadingAttribute implements org.jboss.as.clustering.controller.Attribute
    {
        DEFAULT_EXECUTOR("default-executor"),
        OOB_EXECUTOR("oob-executor"),
        TIMER_EXECUTOR("timer-executor"),
        THREAD_FACTORY("thread-factory");

        private final AttributeDefinition definition;

        private ThreadingAttribute(String name) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, ModelType.STRING).setAllowExpression(false)).setRequired(false)).setDeprecated(JGroupsModel.VERSION_3_0_0.getVersion())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        SHARED("shared", ModelType.BOOLEAN){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setDefaultValue(new ModelNode(false))).setDeprecated(JGroupsModel.VERSION_4_0_0.getVersion());
            }
        }
        ,
        SOCKET_BINDING("socket-binding", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(false)).setRequired(true)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF})).setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.TRANSPORT, (UnaryRequirement)CommonUnaryRequirement.SOCKET_BINDING));
            }
        }
        ,
        DIAGNOSTICS_SOCKET_BINDING("diagnostics-socket-binding", ModelType.STRING){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)builder.setAllowExpression(false)).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.SOCKET_BINDING_REF})).setCapabilityReference((CapabilityReferenceRecorder)new CapabilityReference((org.jboss.as.clustering.controller.Capability)Capability.TRANSPORT, (UnaryRequirement)CommonUnaryRequirement.SOCKET_BINDING));
            }
        }
        ,
        SITE("site", ModelType.STRING),
        RACK("rack", ModelType.STRING),
        MACHINE("machine", ModelType.STRING);

        private final AttributeDefinition definition;

        private Attribute(String name, ModelType type) {
            this.definition = this.apply((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    static enum Capability implements org.jboss.as.clustering.controller.Capability
    {
        TRANSPORT("org.wildfly.clustering.jgroups.transport");

        private final RuntimeCapability<Void> definition;

        private Capability(String name) {
            this.definition = RuntimeCapability.Builder.of((String)name, (boolean)true).setDynamicNameMapper((Function)UnaryCapabilityNameResolver.PARENT).build();
        }

        public RuntimeCapability<Void> getDefinition() {
            return this.definition;
        }
    }
}

