/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.jgroups.auth.BinaryAuthToken;
import org.jboss.as.clustering.jgroups.auth.CipherAuthToken;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.AuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.CipherAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.DigestAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.PlainAuthTokenResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolResourceDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.RequirementServiceBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jgroups.auth.AuthToken;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.AUTH;
import org.wildfly.clustering.jgroups.spi.ProtocolConfiguration;
import org.wildfly.clustering.jgroups.spi.ProtocolStackConfiguration;
import org.wildfly.subsystem.resource.capability.ResourceCapabilityReferenceRecorder;
import org.wildfly.subsystem.service.ResourceServiceConfigurator;
import org.wildfly.subsystem.service.ServiceDependency;

public class AuthProtocolResourceDefinition
extends ProtocolResourceDefinition<AUTH> {
    AuthProtocolResourceDefinition(String name, UnaryOperator<ResourceDescriptor> configurator, ResourceServiceConfigurator parentServiceConfigurator) {
        super(AuthProtocolResourceDefinition.pathElement(name), new ResourceDescriptorConfigurator(configurator), parentServiceConfigurator);
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        new PlainAuthTokenResourceDefinition().register(registration);
        new DigestAuthTokenResourceDefinition().register(registration);
        new CipherAuthTokenResourceDefinition().register(registration);
        return registration;
    }

    @Override
    public Map.Entry<Function<ProtocolConfiguration<AUTH>, ProtocolConfiguration<AUTH>>, Consumer<RequirementServiceBuilder<?>>> resolve(OperationContext context, ModelNode model) throws OperationFailedException {
        final ServiceDependency token = ServiceDependency.on(AuthTokenResourceDefinition.SERVICE_DESCRIPTOR, (String)context.getCurrentAddress().getParent().getLastElement().getValue(), (String)context.getCurrentAddressValue());
        return Map.entry(new UnaryOperator<ProtocolConfiguration<AUTH>>(){

            @Override
            public ProtocolConfiguration<AUTH> apply(ProtocolConfiguration<AUTH> configuration) {
                return new AbstractProtocolResourceDefinition.ProtocolConfigurationDecorator<AUTH>(configuration){

                    @Override
                    public AUTH createProtocol(ProtocolStackConfiguration stackConfiguration) {
                        return ((AUTH)super.createProtocol(stackConfiguration)).setAuthToken((AuthToken)token.get());
                    }
                };
            }
        }, token);
    }

    static {
        ClassConfigurator.add((short)1100, BinaryAuthToken.class);
        ClassConfigurator.add((short)1101, CipherAuthToken.class);
    }

    private static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        private final UnaryOperator<ResourceDescriptor> configurator;

        ResourceDescriptorConfigurator(UnaryOperator<ResourceDescriptor> configurator) {
            this.configurator = configurator;
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return ((ResourceDescriptor)this.configurator.apply(descriptor)).setAddOperationTransformation((UnaryOperator)new ProtocolResourceDefinition.LegacyAddOperationTransformation("auth_class")).setOperationTransformation(ProtocolResourceDefinition.LEGACY_OPERATION_TRANSFORMER).addResourceCapabilityReference((CapabilityReferenceRecorder)ResourceCapabilityReferenceRecorder.builder(ProtocolResourceDefinition.CAPABILITY, AuthTokenResourceDefinition.SERVICE_DESCRIPTOR).build());
        }
    }
}

