/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.InputStream;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemSchema;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.xml.VersionedFeature;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.network.OutboundSocketBinding;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.subsystem.test.AbstractSubsystemSchemaTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JGroupsSubsystemTestCase
extends AbstractSubsystemSchemaTest<JGroupsSubsystemSchema> {
    private final JGroupsSubsystemSchema schema;

    @Parameterized.Parameters
    public static Iterable<JGroupsSubsystemSchema> parameters() {
        return EnumSet.allOf(JGroupsSubsystemSchema.class);
    }

    public JGroupsSubsystemTestCase(JGroupsSubsystemSchema schema) {
        super(JGroupsSubsystemResourceDefinitionRegistrar.REGISTRATION.getName(), (Extension)new JGroupsExtension(), (SubsystemSchema)schema, (SubsystemSchema)JGroupsSubsystemSchema.CURRENT);
        this.schema = schema;
    }

    protected String getSubsystemXsdPathPattern() {
        return "schema/jboss-as-%s_%d_%d.xsd";
    }

    private KernelServices buildKernelServices() throws Exception {
        return this.buildKernelServices(this.getSubsystemXml());
    }

    private KernelServices buildKernelServices(String xml) throws Exception {
        return this.createKernelServicesBuilder(xml).build();
    }

    private KernelServicesBuilder createKernelServicesBuilder() {
        return this.createKernelServicesBuilder((AdditionalInitialization)this.createAdditionalInitialization());
    }

    private KernelServicesBuilder createKernelServicesBuilder(String xml) throws XMLStreamException {
        return this.createKernelServicesBuilder().setSubsystemXml(xml);
    }

    protected org.jboss.as.clustering.subsystem.AdditionalInitialization createAdditionalInitialization() {
        return new org.jboss.as.clustering.subsystem.AdditionalInitialization((SubsystemSchema)this.schema).require(SocketBinding.SERVICE_DESCRIPTOR, List.of("jgroups-tcp", "jgroups-udp", "some-binding", "some-other-binding", "jgroups-diagnostics", "jgroups-mping", "jgroups-tcp-fd", "jgroups-client-fd")).require(OutboundSocketBinding.SERVICE_DESCRIPTOR, List.of("node1", "node2")).require(CommonServiceDescriptor.KEY_STORE, "my-key-store").require(CommonServiceDescriptor.CREDENTIAL_STORE, "my-credential-store").require(CommonServiceDescriptor.DATA_SOURCE, "ExampleDS");
    }

    @Test
    public void testIndexedAdds() throws Exception {
        if (!this.schema.since((VersionedFeature)JGroupsSubsystemSchema.VERSION_3_0)) {
            return;
        }
        KernelServices services = this.buildKernelServices();
        ModelNode originalSubsystemModel = services.readWholeModel().get(JGroupsSubsystemResourceDefinitionRegistrar.REGISTRATION.getPathElement().getKeyValuePair());
        ModelNode originalChannelModel = originalSubsystemModel.get(JGroupsResourceRegistration.CHANNEL.pathElement("ee").getKeyValuePair());
        ModelNode originalForkModel = originalChannelModel.get(JGroupsResourceRegistration.FORK.pathElement("web").getKeyValuePair());
        Assert.assertTrue((boolean)originalForkModel.isDefined());
        originalForkModel.protect();
        Assert.assertTrue((0 < originalForkModel.get(StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement().getKey()).keys().size() ? 1 : 0) != 0);
        ModelNode originalStackModel = originalSubsystemModel.get(JGroupsResourceRegistration.STACK.pathElement("maximal").getKeyValuePair());
        Assert.assertTrue((boolean)originalStackModel.isDefined());
        originalStackModel.protect();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinitionRegistrar.REGISTRATION.getPathElement()});
        PathAddress forkAddress = subsystemAddress.append(new PathElement[]{JGroupsResourceRegistration.CHANNEL.pathElement("ee")}).append(new PathElement[]{JGroupsResourceRegistration.FORK.pathElement("web")});
        PathAddress stackAddress = subsystemAddress.append(new PathElement[]{JGroupsResourceRegistration.STACK.pathElement("maximal")});
        ModelNode add = Util.createAddOperation((PathAddress)forkAddress.append(new PathElement[]{StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement("MERGE3")}), (int)0);
        ModelTestUtils.checkOutcome((ModelNode)services.executeOperation(add, new InputStream[0]));
        ModelNode subsystemModel = services.readWholeModel().get(JGroupsSubsystemResourceDefinitionRegistrar.REGISTRATION.getPathElement().getKeyValuePair());
        ModelNode channelModel = subsystemModel.get(JGroupsResourceRegistration.CHANNEL.pathElement("ee").getKeyValuePair());
        ModelNode forkModel = channelModel.get(JGroupsResourceRegistration.FORK.pathElement("web").getKeyValuePair());
        Assert.assertEquals((long)(originalForkModel.keys().size() + 1), (long)forkModel.get(StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement().getKey()).keys().size());
        Assert.assertEquals((Object)"MERGE3", forkModel.get(StackResourceDefinitionRegistrar.Component.PROTOCOL.getPathElement().getKey()).keys().iterator().next());
        ModelNode remove = Util.createRemoveOperation((PathAddress)stackAddress.append(new PathElement[]{StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement("FD")}));
        ModelTestUtils.checkOutcome((ModelNode)services.executeOperation(remove, new InputStream[0]));
        add = Util.createAddOperation((PathAddress)stackAddress.append(new PathElement[]{StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement("FD")}), (int)3);
        ModelTestUtils.checkOutcome((ModelNode)services.executeOperation(add, new InputStream[0]));
        subsystemModel = services.readWholeModel().get(JGroupsSubsystemResourceDefinitionRegistrar.REGISTRATION.getPathElement().getKeyValuePair());
        ModelNode stackModel = subsystemModel.get(JGroupsResourceRegistration.STACK.pathElement("maximal").getKeyValuePair());
        Assert.assertEquals((Object)originalStackModel, (Object)stackModel);
    }
}

