/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.controller.CommonServiceDescriptor;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemModel;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.model.test.FailedOperationTransformationConfig;
import org.jboss.as.model.test.ModelTestControllerVersion;
import org.jboss.as.model.test.ModelTestKernelServices;
import org.jboss.as.model.test.ModelTestUtils;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.as.subsystem.test.KernelServicesBuilder;
import org.jgroups.conf.ClassConfigurator;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JGroupsTransformersTestCase
extends AbstractSubsystemTest {
    private static final Map<ModelTestControllerVersion, JGroupsSubsystemModel> VERSIONS = new EnumMap<ModelTestControllerVersion, JGroupsSubsystemModel>(ModelTestControllerVersion.class);
    private final ModelTestControllerVersion controllerVersion;
    private final ModelVersion subsystemVersion;

    @Parameterized.Parameters
    public static Iterable<ModelTestControllerVersion> parameters() {
        return VERSIONS.keySet();
    }

    public JGroupsTransformersTestCase(ModelTestControllerVersion version) {
        super(JGroupsSubsystemResourceDefinitionRegistrar.REGISTRATION.getName(), (Extension)new JGroupsExtension());
        this.controllerVersion = version;
        this.subsystemVersion = VERSIONS.get(version).getVersion();
    }

    private String[] getDependencies() {
        switch (this.controllerVersion) {
            case EAP_7_4_0: {
                return new String[]{this.formatArtifact("wildfly-clustering-jgroups-extension"), this.formatArtifact("wildfly-clustering-api"), this.formatArtifact("wildfly-clustering-common"), this.formatArtifact("wildfly-clustering-jgroups-spi"), this.formatArtifact("wildfly-clustering-server"), this.formatArtifact("wildfly-clustering-service"), this.formatArtifact("wildfly-clustering-spi")};
            }
            case EAP_8_0_0: {
                return new String[]{this.formatArtifact("wildfly-clustering-jgroups-extension"), this.formatArtifact("wildfly-clustering-common"), this.formatArtifact("wildfly-clustering-jgroups-spi"), this.formatArtifact("wildfly-clustering-server-service"), this.formatArtifact("wildfly-clustering-server-spi"), this.formatArtifact("wildfly-clustering-service")};
            }
        }
        throw new IllegalArgumentException();
    }

    private String formatArtifact(String artifactId) {
        return String.format("%s:%s:%s", this.controllerVersion.getMavenGroupId(), artifactId, this.controllerVersion.getMavenGavVersion());
    }

    private static org.jboss.as.clustering.subsystem.AdditionalInitialization createAdditionalInitialization() {
        return new org.jboss.as.clustering.subsystem.AdditionalInitialization().require(SocketBinding.SERVICE_DESCRIPTOR, List.of("jgroups-tcp", "jgroups-udp", "jgroups-udp-fd", "some-binding", "client-binding", "jgroups-diagnostics", "jgroups-mping", "jgroups-tcp-fd", "jgroups-client-fd", "jgroups-state-xfr")).require(CommonServiceDescriptor.KEY_STORE, "my-key-store").require(CommonServiceDescriptor.CREDENTIAL_STORE, "my-credential-store");
    }

    private KernelServicesBuilder createKernelServicesBuilder() {
        return this.createKernelServicesBuilder((AdditionalInitialization)JGroupsTransformersTestCase.createAdditionalInitialization());
    }

    private KernelServices build(KernelServicesBuilder builder) throws Exception {
        builder.createLegacyKernelServicesBuilder((AdditionalInitialization)JGroupsTransformersTestCase.createAdditionalInitialization(), this.controllerVersion, this.subsystemVersion).addMavenResourceURL(this.getDependencies()).addSingleChildFirstClass(new Class[]{org.jboss.as.clustering.subsystem.AdditionalInitialization.class}).addSingleChildFirstClass(new Class[]{ClassConfigurator.class}).skipReverseControllerCheck().dontPersistXml();
        KernelServices services = builder.build();
        Assert.assertTrue((String)services.getBootErrorDescription(), (boolean)services.isSuccessfulBoot());
        KernelServices legacyServices = (KernelServices)services.getLegacyServices(this.subsystemVersion);
        Assert.assertTrue((String)legacyServices.getBootErrorDescription(), (boolean)legacyServices.isSuccessfulBoot());
        return services;
    }

    @Test
    public void testTransformations() throws Exception {
        KernelServicesBuilder builder = this.createKernelServicesBuilder().setSubsystemXmlResource(String.format("jgroups-transform-%s.xml", this.subsystemVersion.toString()));
        KernelServices services = this.build(builder);
        this.checkSubsystemModelTransformation(services, this.subsystemVersion, null, false);
    }

    @Test
    public void testRejections() throws Exception {
        KernelServicesBuilder builder = this.createKernelServicesBuilder();
        KernelServices services = this.build(builder);
        FailedOperationTransformationConfig config = new FailedOperationTransformationConfig();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinitionRegistrar.REGISTRATION.getPathElement()});
        if (JGroupsSubsystemModel.VERSION_8_0_0.requiresTransformation(this.subsystemVersion)) {
            config.addFailedAttribute(subsystemAddress.append(new PathElement[]{JGroupsResourceRegistration.STACK.pathElement("credentialReference1")}).append(new PathElement[]{StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement("SYM_ENCRYPT")}), FailedOperationTransformationConfig.REJECTED_RESOURCE);
        }
        List operations = builder.parseXmlResource("jgroups-reject.xml");
        ModelTestUtils.checkFailedTransformedBootOperations((ModelTestKernelServices)services, (ModelVersion)this.subsystemVersion, (List)operations, (FailedOperationTransformationConfig)config);
    }

    static {
        VERSIONS.put(ModelTestControllerVersion.EAP_7_4_0, JGroupsSubsystemModel.VERSION_8_0_0);
        VERSIONS.put(ModelTestControllerVersion.EAP_8_0_0, JGroupsSubsystemModel.VERSION_10_0_0);
    }
}

