/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.io.IOException;
import java.util.List;
import org.jboss.as.clustering.jgroups.subsystem.AbstractTransportResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsExtension;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceRegistration;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsSubsystemSchema;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolChildResourceDefinitionRegistrar;
import org.jboss.as.clustering.jgroups.subsystem.StackResourceDefinitionRegistrar;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemSchema;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.IntVersion;
import org.wildfly.service.descriptor.UnaryServiceDescriptor;

public class OperationTestCaseBase
extends AbstractSubsystemTest {
    static final String SUBSYSTEM_XML_FILE = String.format("jgroups-%d.%d.xml", ((IntVersion)JGroupsSubsystemSchema.CURRENT.getVersion()).major(), ((IntVersion)JGroupsSubsystemSchema.CURRENT.getVersion()).minor());

    public OperationTestCaseBase() {
        super(JGroupsSubsystemResourceDefinitionRegistrar.REGISTRATION.getName(), (Extension)new JGroupsExtension());
    }

    protected static ModelNode getSubsystemAddOperation(String defaultStack) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getSubsystemAddress());
    }

    protected static ModelNode getSubsystemReadOperation(AttributeDefinition attribute) {
        return Util.getReadAttributeOperation((PathAddress)OperationTestCaseBase.getSubsystemAddress(), (String)attribute.getName());
    }

    protected static ModelNode getSubsystemWriteOperation(AttributeDefinition attribute, String value) {
        return Util.getWriteAttributeOperation((PathAddress)OperationTestCaseBase.getSubsystemAddress(), (String)attribute.getName(), (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getSubsystemRemoveOperation() {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getSubsystemAddress());
    }

    protected static ModelNode getProtocolStackAddOperation(String stackName) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getProtocolStackAddress(stackName));
    }

    protected static ModelNode getProtocolStackAddOperationWithParameters(String stackName) {
        return Util.createCompositeOperation(List.of(OperationTestCaseBase.getProtocolStackAddOperation(stackName), OperationTestCaseBase.getTransportAddOperation(stackName, "UDP"), OperationTestCaseBase.getProtocolAddOperation(stackName, "PING"), OperationTestCaseBase.getProtocolAddOperation(stackName, "pbcast.FLUSH")));
    }

    protected static ModelNode getProtocolStackRemoveOperation(String stackName) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolStackAddress(stackName));
    }

    protected static ModelNode getTransportAddOperation(String stackName, String protocol) {
        ModelNode operation = Util.createAddOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, protocol));
        operation.get(AbstractTransportResourceDefinitionRegistrar.SocketBindingAttribute.SERVER.getName()).set("some-binding");
        return operation;
    }

    protected static ModelNode getTransportRemoveOperation(String stackName, String type) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type));
    }

    protected static ModelNode getTransportReadOperation(String stackName, String type, AttributeDefinition attribute) {
        return Util.getReadAttributeOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)attribute.getName());
    }

    protected static ModelNode getTransportWriteOperation(String stackName, String type, AttributeDefinition attribute, String value) {
        return Util.getWriteAttributeOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)attribute.getName(), (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getTransportGetPropertyOperation(String stackName, String type, String propertyName) {
        return Util.createMapGetOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getTransportPutPropertyOperation(String stackName, String type, String propertyName, String propertyValue) {
        return Util.createMapPutOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName(), (String)propertyName, (String)propertyValue);
    }

    protected static ModelNode getTransportRemovePropertyOperation(String stackName, String type, String propertyName) {
        return Util.createMapRemoveOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getTransportClearPropertiesOperation(String stackName, String type) {
        return Util.createMapClearOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName());
    }

    protected static ModelNode getTransportUndefinePropertiesOperation(String stackName, String type) {
        return Util.getUndefineAttributeOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName());
    }

    protected static ModelNode getTransportSetPropertiesOperation(String stackName, String type, ModelNode values) {
        return Util.getWriteAttributeOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type), (String)ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName(), (ModelNode)values);
    }

    protected static ModelNode getThreadPoolAddOperation(String stackName, String type, String threadPoolName) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getTransportAddress(stackName, type).append("thread-pool", threadPoolName));
    }

    protected static ModelNode getProtocolAddOperation(String stackName, String type) {
        return Util.createAddOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, type));
    }

    protected static ModelNode getProtocolReadOperation(String stackName, String protocolName, AttributeDefinition attribute) {
        return Util.getReadAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)attribute.getName());
    }

    protected static ModelNode getProtocolWriteOperation(String stackName, String protocolName, AttributeDefinition attribute, String value) {
        return Util.getWriteAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)attribute.getName(), (ModelNode)new ModelNode(value));
    }

    protected static ModelNode getProtocolGetPropertyOperation(String stackName, String protocolName, String propertyName) {
        return Util.createMapGetOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getProtocolPutPropertyOperation(String stackName, String protocolName, String propertyName, String propertyValue) {
        return Util.createMapPutOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName(), (String)propertyName, (String)propertyValue);
    }

    protected static ModelNode getProtocolRemovePropertyOperation(String stackName, String protocolName, String propertyName) {
        return Util.createMapRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName(), (String)propertyName);
    }

    protected static ModelNode getProtocolClearPropertiesOperation(String stackName, String protocolName) {
        return Util.createMapClearOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName());
    }

    protected static ModelNode getProtocolUndefinePropertiesOperation(String stackName, String protocolName) {
        return Util.getUndefineAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName());
    }

    protected static ModelNode getProtocolSetPropertiesOperation(String stackName, String protocolName, ModelNode values) {
        return Util.getWriteAttributeOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, protocolName), (String)ProtocolChildResourceDefinitionRegistrar.PROPERTIES.getName(), (ModelNode)values);
    }

    protected static ModelNode getProtocolRemoveOperation(String stackName, String type) {
        return Util.createRemoveOperation((PathAddress)OperationTestCaseBase.getProtocolAddress(stackName, type));
    }

    protected static PathAddress getSubsystemAddress() {
        return PathAddress.pathAddress((PathElement[])new PathElement[]{JGroupsSubsystemResourceDefinitionRegistrar.REGISTRATION.getPathElement()});
    }

    protected static PathAddress getProtocolStackAddress(String stackName) {
        return OperationTestCaseBase.getSubsystemAddress().append(new PathElement[]{JGroupsResourceRegistration.STACK.pathElement(stackName)});
    }

    protected static PathAddress getTransportAddress(String stackName, String type) {
        return OperationTestCaseBase.getProtocolStackAddress(stackName).append(new PathElement[]{StackResourceDefinitionRegistrar.Component.TRANSPORT.pathElement(type)});
    }

    protected static PathAddress getProtocolAddress(String stackName, String type) {
        return OperationTestCaseBase.getProtocolStackAddress(stackName).append(new PathElement[]{StackResourceDefinitionRegistrar.Component.PROTOCOL.pathElement(type)});
    }

    protected String getSubsystemXml() throws IOException {
        return this.readResource(SUBSYSTEM_XML_FILE);
    }

    protected KernelServices buildKernelServices() throws Exception {
        return this.createKernelServicesBuilder(AdditionalInitialization.withCapabilities((SubsystemSchema)JGroupsSubsystemSchema.CURRENT, (String[])new String[]{RuntimeCapability.resolveCapabilityName((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)"some-binding"), RuntimeCapability.resolveCapabilityName((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)"jgroups-diagnostics"), RuntimeCapability.resolveCapabilityName((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)"jgroups-mping"), RuntimeCapability.resolveCapabilityName((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)"jgroups-tcp-fd"), RuntimeCapability.resolveCapabilityName((UnaryServiceDescriptor)SocketBinding.SERVICE_DESCRIPTOR, (String)"new-socket-binding")})).setSubsystemXml(this.getSubsystemXml()).build();
    }
}

